/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TransientVariableInstance;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;

public abstract class VariableScopeImpl
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances = null;
    protected Map<String, VariableInstanceEntity> usedVariablesCache = new HashMap<String, VariableInstanceEntity>();
    protected Map<String, VariableInstance> transientVariabes;
    protected ELContext cachedElContext;
    protected String id;

    protected abstract List<VariableInstanceEntity> loadVariableInstances();

    protected abstract VariableScopeImpl getParentVariableScope();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    protected void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                throw new ActivitiException("lazy loading outside command context");
            }
            List<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
            }
        }
    }

    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    public Map<String, VariableInstance> getVariableInstances() {
        return this.collectVariableInstances(new HashMap<String, VariableInstance>());
    }

    public Map<String, Object> getVariables(Collection<String> variableNames) {
        return this.getVariables(variableNames, true);
    }

    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames) {
        return this.getVariableInstances(variableNames, true);
    }

    public Map<String, Object> getVariables(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(string)) {
                requestedVariables.put(string, this.transientVariabes.get(string).getValue());
                variableNamesToFetch.remove(string);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string).getValue());
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariables();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
            return requestedVariables;
        }
        List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
        for (VariableInstanceEntity variable : variables) {
            requestedVariables.put(variable.getName(), variable.getValue());
        }
        VariableScopeImpl variableScopeImpl = this.getParentVariableScope();
        if (variableScopeImpl != null) {
            requestedVariables.putAll(variableScopeImpl.getVariables(variableNamesToFetch, fetchAllVariables));
        }
        return requestedVariables;
    }

    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String string : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(string)) {
                requestedVariables.put(string, this.transientVariabes.get(string));
                variableNamesToFetch.remove(string);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(string)) continue;
            requestedVariables.put(string, this.usedVariablesCache.get(string));
            variableNamesToFetch.remove(string);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstances();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
            return requestedVariables;
        }
        List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
        for (VariableInstanceEntity variable : variables) {
            requestedVariables.put(variable.getName(), variable);
        }
        VariableScopeImpl variableScopeImpl = this.getParentVariableScope();
        if (variableScopeImpl != null) {
            requestedVariables.putAll(variableScopeImpl.getVariableInstances(variableNamesToFetch, fetchAllVariables));
        }
        return requestedVariables;
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
        }
        if (this.transientVariabes != null) {
            for (String variableName : this.transientVariabes.keySet()) {
                variables.put(variableName, this.transientVariabes.get(variableName).getValue());
            }
        }
        return variables;
    }

    protected Map<String, VariableInstance> collectVariableInstances(HashMap<String, VariableInstance> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariableInstances(variables));
        }
        for (VariableInstance variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (String string : this.usedVariablesCache.keySet()) {
            variables.put(string, this.usedVariablesCache.get(string));
        }
        if (this.transientVariabes != null) {
            variables.putAll(this.transientVariabes);
        }
        return variables;
    }

    public Object getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    public VariableInstance getVariableInstance(String variableName) {
        return this.getVariableInstance(variableName, true);
    }

    public Object getVariable(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstance(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    public VariableInstance getVariableInstance(String variableName, boolean fetchAllVariables) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return this.transientVariabes.get(variableName);
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (fetchAllVariables) {
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            VariableScopeImpl parentScope = this.getParentVariableScope();
            if (parentScope != null) {
                return parentScope.getVariableInstance(variableName, true);
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            return this.variableInstances.get(variableName);
        }
        VariableInstanceEntity variable = this.getSpecificVariable(variableName);
        if (variable != null) {
            this.usedVariablesCache.put(variableName, variable);
            return variable;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariableInstance(variableName, false);
        }
        return null;
    }

    protected abstract VariableInstanceEntity getSpecificVariable(String var1);

    public Object getVariableLocal(String variableName) {
        return this.getVariableLocal(variableName, true);
    }

    public VariableInstance getVariableInstanceLocal(String variableName) {
        return this.getVariableInstanceLocal(variableName, true);
    }

    public Object getVariableLocal(String variableName, boolean fetchAllVariables) {
        Object value = null;
        VariableInstance variable = this.getVariableInstanceLocal(variableName, fetchAllVariables);
        if (variable != null) {
            value = variable.getValue();
        }
        return value;
    }

    public VariableInstance getVariableInstanceLocal(String variableName, boolean fetchAllVariables) {
        VariableInstanceEntity variable;
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return this.transientVariabes.get(variableName);
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            return this.usedVariablesCache.get(variableName);
        }
        if (fetchAllVariables) {
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance != null) {
                return variableInstance;
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName) && (variable = this.usedVariablesCache.get(variableName)) != null) {
            return variable;
        }
        if (this.variableInstances != null && this.variableInstances.containsKey(variableName) && (variable = this.variableInstances.get(variableName)) != null) {
            return this.variableInstances.get(variableName);
        }
        variable = this.getSpecificVariable(variableName);
        if (variable != null) {
            this.usedVariablesCache.put(variableName, variable);
            return variable;
        }
        return null;
    }

    public boolean hasVariables() {
        if (this.transientVariabes != null && !this.transientVariabes.isEmpty()) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        if (!this.variableInstances.isEmpty()) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariables();
        }
        return false;
    }

    public boolean hasVariablesLocal() {
        if (this.transientVariabes != null && !this.transientVariabes.isEmpty()) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        return !this.variableInstances.isEmpty();
    }

    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariable(variableName);
        }
        return false;
    }

    public boolean hasVariableLocal(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return true;
        }
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        if (this.transientVariabes != null) {
            variableNames.addAll(this.transientVariabes.keySet());
        }
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
        }
        if (this.transientVariabes != null) {
            for (String variableName : this.transientVariabes.keySet()) {
                variables.put(variableName, this.transientVariabes.get(variableName).getValue());
            }
        }
        return variables;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal() {
        HashMap<String, VariableInstance> variables = new HashMap<String, VariableInstance>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance);
        }
        for (String variableName : this.usedVariablesCache.keySet()) {
            variables.put(variableName, this.usedVariablesCache.get(variableName));
        }
        if (this.transientVariabes != null) {
            variables.putAll(this.transientVariabes);
        }
        return variables;
    }

    public Map<String, Object> getVariablesLocal(Collection<String> variableNames) {
        return this.getVariablesLocal(variableNames, true);
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames) {
        return this.getVariableInstancesLocal(variableNames, true);
    }

    public Map<String, Object> getVariablesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, Object> requestedVariables = new HashMap<String, Object>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
                requestedVariables.put(variableName, this.transientVariabes.get(variableName).getValue());
                variableNamesToFetch.remove(variableName);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName).getValue());
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, Object> allVariables = this.getVariablesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable.getValue());
            }
        }
        return requestedVariables;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        HashMap<String, VariableInstance> requestedVariables = new HashMap<String, VariableInstance>();
        HashSet<String> variableNamesToFetch = new HashSet<String>(variableNames);
        for (String variableName : variableNames) {
            if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
                requestedVariables.put(variableName, this.transientVariabes.get(variableName));
                variableNamesToFetch.remove(variableName);
                continue;
            }
            if (!this.usedVariablesCache.containsKey(variableName)) continue;
            requestedVariables.put(variableName, this.usedVariablesCache.get(variableName));
            variableNamesToFetch.remove(variableName);
        }
        if (fetchAllVariables) {
            Map<String, VariableInstance> allVariables = this.getVariableInstancesLocal();
            for (String variableName : variableNamesToFetch) {
                requestedVariables.put(variableName, allVariables.get(variableName));
            }
        } else {
            List<VariableInstanceEntity> variables = this.getSpecificVariables(variableNamesToFetch);
            for (VariableInstanceEntity variable : variables) {
                requestedVariables.put(variable.getName(), variable);
            }
        }
        return requestedVariables;
    }

    protected abstract List<VariableInstanceEntity> getSpecificVariables(Collection<String> var1);

    public Set<String> getVariableNamesLocal() {
        HashSet<String> variableNames = new HashSet<String>();
        if (this.transientVariabes != null) {
            variableNames.addAll(this.transientVariabes.keySet());
        }
        this.ensureVariableInstancesInitialized();
        variableNames.addAll(this.variableInstances.keySet());
        return variableNames;
    }

    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return Collections.unmodifiableMap(this.variableInstances);
    }

    public Map<String, VariableInstanceEntity> getUsedVariablesCache() {
        return this.usedVariablesCache;
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    public void removeVariables() {
        this.ensureVariableInstancesInitialized();
        HashSet<String> variableNames = new HashSet<String>(this.variableInstances.keySet());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    public void deleteVariablesInstanceForLeavingScope() {
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
            variableInstance.delete();
        }
    }

    public void removeVariables(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariable(variableName);
            }
        }
    }

    public void removeVariablesLocal(Collection<String> variableNames) {
        if (variableNames != null) {
            for (String variableName : variableNames) {
                this.removeVariableLocal(variableName);
            }
        }
    }

    public void setVariable(String variableName, Object value) {
        this.setVariable(variableName, value, this.getSourceActivityExecution(), true);
    }

    public void setVariable(String variableName, Object value, boolean fetchAllVariables) {
        this.setVariable(variableName, value, this.getSourceActivityExecution(), fetchAllVariables);
    }

    protected void setVariable(String variableName, Object value, ExecutionEntity sourceActivityExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
            }
            if (this.hasVariableLocal(variableName)) {
                this.setVariableLocal(variableName, value, sourceActivityExecution, true);
                return;
            }
            VariableScopeImpl parentVariableScope = this.getParentVariableScope();
            if (parentVariableScope != null) {
                if (sourceActivityExecution == null) {
                    parentVariableScope.setVariable(variableName, value);
                } else {
                    parentVariableScope.setVariable(variableName, value, sourceActivityExecution, true);
                }
                return;
            }
            this.createVariableLocal(variableName, value);
        } else if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value, sourceActivityExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceActivityExecution);
                this.usedVariablesCache.put(variableName, variable);
            } else {
                VariableScopeImpl parent = this.getParentVariableScope();
                if (parent != null) {
                    parent.setVariable(variableName, value, sourceActivityExecution, fetchAllVariables);
                    return;
                }
                variable = this.createVariableInstance(variableName, value, sourceActivityExecution);
                this.usedVariablesCache.put(variableName, variable);
            }
        }
    }

    public Object setVariableLocal(String variableName, Object value) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution(), true);
    }

    public Object setVariableLocal(String variableName, Object value, boolean fetchAllVariables) {
        return this.setVariableLocal(variableName, value, this.getSourceActivityExecution(), fetchAllVariables);
    }

    public Object setVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution, boolean fetchAllVariables) {
        if (fetchAllVariables) {
            if (this.usedVariablesCache.containsKey(variableName)) {
                this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
            }
            this.ensureVariableInstancesInitialized();
            VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
            if (variableInstance == null) {
                variableInstance = this.usedVariablesCache.get(variableName);
            }
            if (variableInstance == null) {
                this.createVariableLocal(variableName, value);
            } else {
                this.updateVariableInstance(variableInstance, value, sourceActivityExecution);
            }
            return null;
        }
        if (this.usedVariablesCache.containsKey(variableName)) {
            this.updateVariableInstance(this.usedVariablesCache.get(variableName), value, sourceActivityExecution);
        } else if (this.variableInstances != null && this.variableInstances.containsKey(variableName)) {
            this.updateVariableInstance(this.variableInstances.get(variableName), value, sourceActivityExecution);
        } else {
            VariableInstanceEntity variable = this.getSpecificVariable(variableName);
            if (variable != null) {
                this.updateVariableInstance(variable, value, sourceActivityExecution);
            } else {
                variable = this.createVariableInstance(variableName, value, sourceActivityExecution);
            }
            this.usedVariablesCache.put(variableName, variable);
        }
        return null;
    }

    public void createVariableLocal(String variableName, Object value) {
        this.createVariableLocal(variableName, value, this.getSourceActivityExecution());
    }

    protected void createVariableLocal(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new ActivitiException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        this.createVariableInstance(variableName, value, sourceActivityExecution);
    }

    public void removeVariable(String variableName) {
        this.removeVariable(variableName, this.getSourceActivityExecution());
    }

    protected void removeVariable(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            this.removeVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            if (sourceActivityExecution == null) {
                parentVariableScope.removeVariable(variableName);
            } else {
                parentVariableScope.removeVariable(variableName, sourceActivityExecution);
            }
        }
    }

    public void removeVariableLocal(String variableName) {
        this.removeVariableLocal(variableName, this.getSourceActivityExecution());
    }

    protected ExecutionEntity getSourceActivityExecution() {
        return null;
    }

    protected void removeVariableLocal(String variableName, ExecutionEntity sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            this.deleteVariableInstanceForExplicitUserCall(variableInstance, sourceActivityExecution);
        }
    }

    protected void deleteVariableInstanceForExplicitUserCall(VariableInstanceEntity variableInstance, ExecutionEntity sourceActivityExecution) {
        variableInstance.delete();
        variableInstance.setValue(null);
        Context.getCommandContext().getHistoryManager().recordVariableRemoved(variableInstance);
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
    }

    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType newType = variableTypes.findVariableType(value);
        if (newType != null && !newType.equals(variableInstance.getType())) {
            variableInstance.setValue(null);
            variableInstance.setType(newType);
            variableInstance.forceUpdate();
            variableInstance.setValue(value);
        } else {
            variableInstance.setValue(value);
        }
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
        Context.getCommandContext().getHistoryManager().recordVariableUpdate(variableInstance);
    }

    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(value);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        if (this.variableInstances != null) {
            this.variableInstances.put(variableName, variableInstance);
        }
        Context.getCommandContext().getHistoryManager().recordVariableCreate(variableInstance);
        Context.getCommandContext().getHistoryManager().recordHistoricDetailVariableCreate(variableInstance, sourceActivityExecution, this.isActivityIdUsedForDetails());
        return variableInstance;
    }

    protected boolean isActivityIdUsedForDetails() {
        return true;
    }

    public void setTransientVariablesLocal(Map<String, Object> transientVariables) {
        for (String variableName : transientVariables.keySet()) {
            this.setTransientVariableLocal(variableName, transientVariables.get(variableName));
        }
    }

    public void setTransientVariableLocal(String variableName, Object variableValue) {
        if (this.transientVariabes == null) {
            this.transientVariabes = new HashMap<String, VariableInstance>();
        }
        this.transientVariabes.put(variableName, new TransientVariableInstance(variableName, variableValue));
    }

    public void setTransientVariables(Map<String, Object> transientVariables) {
        for (String variableName : transientVariables.keySet()) {
            this.setTransientVariable(variableName, transientVariables.get(variableName));
        }
    }

    public void setTransientVariable(String variableName, Object variableValue) {
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.setTransientVariable(variableName, variableValue);
            return;
        }
        this.setTransientVariableLocal(variableName, variableValue);
    }

    public Object getTransientVariableLocal(String variableName) {
        if (this.transientVariabes != null) {
            return this.transientVariabes.get(variableName).getValue();
        }
        return null;
    }

    public Map<String, Object> getTransientVariablesLocal() {
        if (this.transientVariabes != null) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (String variableName : this.transientVariabes.keySet()) {
                variables.put(variableName, this.transientVariabes.get(variableName).getValue());
            }
            return variables;
        }
        return Collections.emptyMap();
    }

    public Object getTransientVariable(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            return this.transientVariabes.get(variableName).getValue();
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getTransientVariable(variableName);
        }
        return null;
    }

    public Map<String, Object> getTransientVariables() {
        return this.collectTransientVariables(new HashMap<String, Object>());
    }

    protected Map<String, Object> collectTransientVariables(HashMap<String, Object> variables) {
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        if (this.transientVariabes != null) {
            for (String variableName : this.transientVariabes.keySet()) {
                variables.put(variableName, this.transientVariabes.get(variableName).getValue());
            }
        }
        return variables;
    }

    public void removeTransientVariableLocal(String variableName) {
        if (this.transientVariabes != null) {
            this.transientVariabes.remove(variableName);
        }
    }

    public void removeTransientVariablesLocal() {
        if (this.transientVariabes != null) {
            this.transientVariabes.clear();
        }
    }

    public void removeTransientVariable(String variableName) {
        if (this.transientVariabes != null && this.transientVariabes.containsKey(variableName)) {
            this.removeTransientVariableLocal(variableName);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeTransientVariable(variableName);
        }
    }

    public void removeTransientVariables() {
        this.removeTransientVariablesLocal();
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeTransientVariablesLocal();
        }
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public <T> T getVariable(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariable(variableName));
    }

    public <T> T getVariableLocal(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariableLocal(variableName));
    }
}

