/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.PvmExecution;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.pvm.runtime.OutgoingExecution;
import org.activiti.engine.impl.pvm.runtime.StartingExecution;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionImpl
implements Serializable,
ActivityExecution,
ExecutionListenerExecution,
PvmExecution,
InterpretableExecution {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionImpl.class);
    protected ProcessDefinitionImpl processDefinition;
    protected ActivityImpl activity;
    protected FlowElement currentFlowElement;
    protected TransitionImpl transition;
    protected ExecutionImpl processInstance;
    protected ExecutionImpl parent;
    protected List<ExecutionImpl> executions;
    protected ExecutionImpl superExecution;
    protected ExecutionImpl subProcessInstance;
    protected StartingExecution startingExecution;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent;
    protected boolean isEnded;
    protected boolean isEventScope;
    protected Map<String, Object> variables;
    protected String eventName;
    protected PvmProcessElement eventSource;
    protected int executionListenerIndex;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected ExecutionImpl replacedBy;
    protected AtomicOperation nextOperation;
    protected boolean isOperating;

    public ExecutionImpl() {
    }

    public ExecutionImpl(ActivityImpl initial) {
        this.startingExecution = new StartingExecution(initial);
    }

    @Override
    public ExecutionImpl createExecution() {
        ExecutionImpl createdExecution = this.newExecution();
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        return createdExecution;
    }

    protected ExecutionImpl newExecution() {
        return new ExecutionImpl();
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition) {
        ExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        return subProcessInstance;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy() {
        this.setScope(false);
    }

    @Override
    public void remove() {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.ensureExecutionsInitialized();
            this.parent.executions.remove(this);
        }
        ArrayList<ExecutionImpl> childExecutions = new ArrayList<ExecutionImpl>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : childExecutions) {
            if (!interpretableExecution.isEventScope()) continue;
            LOGGER.debug("removing eventScope {}", (Object)interpretableExecution);
            interpretableExecution.destroy();
            interpretableExecution.remove();
        }
    }

    @Override
    public void destroyScope(String reason) {
        LOGGER.debug("performing destroy scope behavior for execution {}", (Object)this);
        ArrayList<ExecutionImpl> executions = new ArrayList<ExecutionImpl>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : executions) {
            if (interpretableExecution.getSubProcessInstance() != null) {
                interpretableExecution.getSubProcessInstance().deleteCascade(reason);
            }
            interpretableExecution.deleteCascade(reason);
        }
    }

    @Override
    public ExecutionImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    public String getSuperExecutionId() {
        this.ensureActivityInitialized();
        if (this.superExecution != null) {
            return this.superExecution.getId();
        }
        return null;
    }

    public String getParentId() {
        this.ensureActivityInitialized();
        if (this.parent != null) {
            return this.parent.getId();
        }
        return null;
    }

    @Override
    public void setParent(InterpretableExecution parent) {
        this.parent = (ExecutionImpl)parent;
    }

    protected void ensureParentInitialized() {
    }

    public List<ExecutionImpl> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    @Override
    public ExecutionImpl getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    public void setSuperExecution(ExecutionImpl superExecution) {
        this.superExecution = superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
    }

    protected void ensureSuperExecutionInitialized() {
    }

    @Override
    public ExecutionImpl getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(InterpretableExecution subProcessInstance) {
        this.subProcessInstance = (ExecutionImpl)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(AtomicOperation.DELETE_CASCADE);
    }

    @Override
    public void end() {
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(AtomicOperation.ACTIVITY_END);
    }

    @Override
    public ExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (ExecutionImpl nestedExecution : this.getExecutions()) {
            ExecutionImpl result = nestedExecution.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        this.ensureActivityInitialized();
        if (this.isActive && this.activity != null) {
            activeActivityIds.add(this.activity.getId());
        }
        this.ensureExecutionsInitialized();
        for (ExecutionImpl execution : this.executions) {
            execution.collectActiveActivityIds(activeActivityIds);
        }
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = new ArrayList<ExecutionImpl>();
        }
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    public String getProcessDefinitionId() {
        return this.getProcessDefinition().getId();
    }

    protected void ensureProcessDefinitionInitialized() {
    }

    @Override
    public ExecutionImpl getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    public String getProcessInstanceId() {
        return this.getProcessInstance().getId();
    }

    public String getRootProcessInstanceId() {
        return this.getProcessInstance().getId();
    }

    public String getBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    public String getProcessInstanceBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessInstance(InterpretableExecution processInstance) {
        this.processInstance = (ExecutionImpl)processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
    }

    public FlowElement getCurrentFlowElement() {
        String processDefinitionId;
        if (this.currentFlowElement == null && (processDefinitionId = this.getProcessDefinitionId()) != null) {
            Process process = ProcessDefinitionUtil.getProcess((String)processDefinitionId);
            this.currentFlowElement = process.getFlowElement(this.getCurrentActivityId(), true);
        }
        return this.currentFlowElement;
    }

    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
    }

    public FlowableListener getCurrentFlowableListener() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentFlowableListener(FlowableListener currentListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return this.activity;
    }

    @Override
    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
    }

    protected void ensureActivityInitialized() {
    }

    protected void ensureScopeInitialized() {
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void start() {
        if (this.startingExecution == null && this.isProcessInstanceType()) {
            this.startingExecution = new StartingExecution(this.processDefinition.getInitial());
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    @Override
    public void signal(String signalName, Object signalData) {
        this.ensureActivityInitialized();
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition, boolean fireActivityCompletedEvent) {
        this.take(transition);
    }

    @Override
    public void take(PvmTransition transition) {
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        this.setTransition((TransitionImpl)transition);
        this.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        this.setActivity((ActivityImpl)activity);
        this.performOperation(AtomicOperation.ACTIVITY_START);
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<ActivityExecution> otherConcurrentExecutions = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            List<ExecutionImpl> concurrentExecutions = this.getParent().getExecutions();
            for (ActivityExecution activityExecution : concurrentExecutions) {
                if (activityExecution.getActivity() != null && activityExecution.getActivity().getId().equals(activity.getId())) {
                    if (activityExecution.isActive()) {
                        throw new PvmException("didn't expect active execution in " + activity + ". bug?");
                    }
                    inactiveConcurrentExecutionsInActivity.add(activityExecution);
                    continue;
                }
                otherConcurrentExecutions.add(activityExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("inactive concurrent executions in '{}': {}", (Object)activity, inactiveConcurrentExecutionsInActivity);
            LOGGER.debug("other concurrent executions: {}", otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> transitions, List<ActivityExecution> recyclableExecutions) {
        transitions = new ArrayList<PvmTransition>(transitions);
        List<ActivityExecution> list = recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (ActivityExecution recyclableExecution : recyclableExecutions) {
                if (!((ExecutionImpl)recyclableExecution).isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        ExecutionImpl concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<ExecutionImpl> concurrentActiveExecutions = new ArrayList<ExecutionImpl>();
        for (ExecutionImpl executionImpl : concurrentRoot.getExecutions()) {
            if (!executionImpl.isActive()) continue;
            concurrentActiveExecutions.add(executionImpl);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("transitions to take concurrent: {}", transitions);
            LOGGER.debug("active concurrent executions: {}", concurrentActiveExecutions);
        }
        if (transitions.size() == 1 && concurrentActiveExecutions.isEmpty()) {
            List<ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            for (ExecutionImpl executionImpl : recyclableExecutionImpls) {
                if (executionImpl.isEnded()) continue;
                LOGGER.debug("pruning execution {}", (Object)executionImpl);
                executionImpl.remove();
            }
            LOGGER.debug("activating the concurrent root {} as the single path of execution going forward", (Object)concurrentRoot);
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(false);
            concurrentRoot.take(transitions.get(0));
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            LOGGER.debug("recyclable executions for reused: {}", recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var7_13;
                PvmTransition pvmTransition = transitions.remove(0);
                Object var7_14 = null;
                if (recyclableExecutions.isEmpty()) {
                    ExecutionImpl executionImpl = concurrentRoot.createExecution();
                    LOGGER.debug("new {} created to take transition {}", (Object)executionImpl, (Object)pvmTransition);
                } else {
                    ExecutionImpl executionImpl = (ExecutionImpl)recyclableExecutions.remove(0);
                    LOGGER.debug("recycled {} to take transition {}", (Object)executionImpl, (Object)pvmTransition);
                }
                var7_13.setActive(true);
                var7_13.setScope(false);
                var7_13.setConcurrent(true);
                outgoingExecutions.add(new OutgoingExecution((InterpretableExecution)var7_13, pvmTransition, true));
            }
            for (ActivityExecution activityExecution : recyclableExecutions) {
                LOGGER.debug("pruning execution {}", (Object)activityExecution);
                activityExecution.end();
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
        }
    }

    @Override
    public void performOperation(AtomicOperation executionOperation) {
        this.nextOperation = executionOperation;
        if (!this.isOperating) {
            this.isOperating = true;
            while (this.nextOperation != null) {
                AtomicOperation currentOperation = this.nextOperation;
                this.nextOperation = null;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("AtomicOperation: {} on {}", (Object)currentOperation, (Object)this);
                }
                currentOperation.execute(this);
            }
            this.isOperating = false;
        }
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public Object getVariable(String variableName) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        this.ensureParentInitialized();
        if (this.parent != null) {
            return this.parent.getVariable(variableName);
        }
        return null;
    }

    public Object getVariable(String variableName, boolean fetchAllVariables) {
        return this.getVariable(variableName);
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> collectedVariables = new HashMap<String, Object>();
        this.collectVariables(collectedVariables);
        return collectedVariables;
    }

    public Map<String, Object> getVariables(Collection<String> variableNames) {
        Map<String, Object> allVariables = this.getVariables();
        HashMap<String, Object> filteredVariables = new HashMap<String, Object>();
        for (String variableName : variableNames) {
            filteredVariables.put(variableName, allVariables.get(variableName));
        }
        return filteredVariables;
    }

    public Map<String, Object> getVariables(Collection<String> variableNames, boolean fetchAllVariables) {
        return this.getVariables(variableNames);
    }

    protected void collectVariables(Map<String, Object> collectedVariables) {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.collectVariables(collectedVariables);
        }
        this.ensureVariablesInitialized();
        for (String variableName : this.variables.keySet()) {
            collectedVariables.put(variableName, this.variables.get(variableName));
        }
    }

    public void setVariables(Map<String, ? extends Object> variables) {
        this.ensureVariablesInitialized();
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariable(String variableName, Object value) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            this.setVariableLocally(variableName, value);
        } else {
            this.ensureParentInitialized();
            if (this.parent != null) {
                this.parent.setVariable(variableName, value);
            } else {
                this.setVariableLocally(variableName, value);
            }
        }
    }

    public void setVariable(String variableName, Object value, boolean fetchAllVariables) {
        this.setVariable(variableName, value);
    }

    public void setVariableLocally(String variableName, Object value) {
        LOGGER.debug("setting variable '{}' to value '{}' on {}", new Object[]{variableName, value, this});
        this.variables.put(variableName, value);
    }

    public Object setVariableLocal(String variableName, Object value, boolean fetchAllVariables) {
        return this.setVariableLocal(variableName, value);
    }

    @Override
    public boolean hasVariable(String variableName) {
        this.ensureVariablesInitialized();
        if (this.variables.containsKey(variableName)) {
            return true;
        }
        this.ensureParentInitialized();
        if (this.parent != null) {
            return this.parent.hasVariable(variableName);
        }
        return false;
    }

    protected void ensureVariablesInitialized() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
    }

    public String toString() {
        if (this.isProcessInstanceType()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isEventScope ? "EventScope" : "") + (this.isConcurrent ? "Concurrent" : "") + (this.isScope() ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public boolean isProcessInstanceType() {
        this.ensureParentInitialized();
        return this.parent == null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public String getId() {
        return null;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    @Override
    public Integer getExecutionListenerIndex() {
        return this.executionListenerIndex;
    }

    @Override
    public void setExecutionListenerIndex(Integer executionListenerIndex) {
        this.executionListenerIndex = executionListenerIndex;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public void setEnded(boolean ended) {
        this.isEnded = ended;
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public PvmProcessElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(PvmProcessElement eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public ExecutionImpl getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(InterpretableExecution replacedBy) {
        this.replacedBy = (ExecutionImpl)replacedBy;
    }

    public void setExecutions(List<ExecutionImpl> executions) {
        this.executions = executions;
    }

    @Override
    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public String getCurrentActivityId() {
        String currentActivityId = null;
        if (this.activity != null) {
            currentActivityId = this.activity.getId();
        }
        return currentActivityId;
    }

    public String getCurrentActivityName() {
        String currentActivityName = null;
        if (this.activity != null) {
            currentActivityName = (String)this.activity.getProperty("name");
        }
        return currentActivityName;
    }

    public Map<String, VariableInstance> getVariableInstances() {
        return null;
    }

    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames) {
        return null;
    }

    public Map<String, VariableInstance> getVariableInstances(Collection<String> variableNames, boolean fetchAllVariables) {
        return null;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal() {
        return null;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames) {
        return null;
    }

    public Map<String, VariableInstance> getVariableInstancesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        return null;
    }

    public VariableInstance getVariableInstance(String variableName) {
        return null;
    }

    public VariableInstance getVariableInstance(String variableName, boolean fetchAllVariables) {
        return null;
    }

    public void createVariableLocal(String variableName, Object value) {
    }

    public void createVariablesLocal(Map<String, ? extends Object> variables) {
    }

    public Object getVariableLocal(String variableName) {
        return null;
    }

    public VariableInstanceEntity getVariableInstanceLocal(String variableName) {
        return null;
    }

    public Object getVariableLocal(String variableName, boolean fetchAllVariables) {
        return this.getVariableLocal(variableName);
    }

    public VariableInstanceEntity getVariableInstanceLocal(String variableName, boolean fetchAllVariables) {
        return null;
    }

    public <T> T getVariable(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariable(variableName));
    }

    public <T> T getVariableLocal(String variableName, Class<T> variableClass) {
        return variableClass.cast(this.getVariableLocal(variableName));
    }

    public Set<String> getVariableNames() {
        return null;
    }

    public Set<String> getVariableNamesLocal() {
        return null;
    }

    public Map<String, Object> getVariablesLocal() {
        return null;
    }

    public Map<String, Object> getVariablesLocal(Collection<String> variableNames) {
        return null;
    }

    public Map<String, Object> getVariablesLocal(Collection<String> variableNames, boolean fetchAllVariables) {
        return null;
    }

    public boolean hasVariableLocal(String variableName) {
        return false;
    }

    public boolean hasVariables() {
        return false;
    }

    public boolean hasVariablesLocal() {
        return false;
    }

    public void removeVariable(String variableName) {
    }

    public void removeVariableLocal(String variableName) {
    }

    public void removeVariables(Collection<String> variableNames) {
    }

    public void removeVariablesLocal(Collection<String> variableNames) {
    }

    public void removeVariables() {
    }

    public void removeVariablesLocal() {
    }

    public void deleteVariablesLocal() {
    }

    public Object setVariableLocal(String variableName, Object value) {
        return null;
    }

    public void setVariablesLocal(Map<String, ? extends Object> variables) {
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public StartingExecution getStartingExecution() {
        return this.startingExecution;
    }

    @Override
    public void disposeStartingExecution() {
        this.startingExecution = null;
    }

    public String updateProcessBusinessKey(String bzKey) {
        return this.getProcessInstance().updateProcessBusinessKey(bzKey);
    }

    public String getTenantId() {
        return null;
    }

    public boolean isMultiInstanceRoot() {
        return false;
    }

    public void setMultiInstanceRoot(boolean isMultiInstanceRoot) {
    }

    public void setTransientVariablesLocal(Map<String, Object> transientVariables) {
        throw new UnsupportedOperationException();
    }

    public void setTransientVariableLocal(String variableName, Object variableValue) {
        throw new UnsupportedOperationException();
    }

    public void setTransientVariables(Map<String, Object> transientVariables) {
        throw new UnsupportedOperationException();
    }

    public void setTransientVariable(String variableName, Object variableValue) {
        throw new UnsupportedOperationException();
    }

    public Object getTransientVariableLocal(String variableName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getTransientVariablesLocal() {
        throw new UnsupportedOperationException();
    }

    public Object getTransientVariable(String variableName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getTransientVariables() {
        throw new UnsupportedOperationException();
    }

    public void removeTransientVariableLocal(String variableName) {
        throw new UnsupportedOperationException();
    }

    public void removeTransientVariablesLocal() {
        throw new UnsupportedOperationException();
    }

    public void removeTransientVariable(String variableName) {
        throw new UnsupportedOperationException();
    }

    public void removeTransientVariables() {
        throw new UnsupportedOperationException();
    }
}

