/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

final class SelectionImpl<PS, SEG, S>
implements Selection<PS, SEG, S> {
    private final SuspendableVal<IndexRange> range;
    private final SuspendableVal<Integer> length;
    private final Val<Integer> paragraphSpan;
    private final SuspendableVal<StyledDocument<PS, SEG, S>> selectedDocument;
    private final SuspendableVal<String> selectedText;
    private final SuspendableVal<Integer> startPosition;
    private final Val<Integer> startParagraphIndex;
    private final Val<Integer> startColumnPosition;
    private final SuspendableVal<Integer> endPosition;
    private final Val<Integer> endParagraphIndex;
    private final Val<Integer> endColumnPosition;
    private final Val<Optional<Bounds>> bounds;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final GenericStyledArea<PS, SEG, S> area;
    private final SuspendableNo dependentBeingUpdated;
    private final Var<IndexRange> internalRange;
    private final EventStream<?> dirty;
    private final Var<TwoDimensional.Position> start2DPosition;
    private final Val<TwoDimensional.Position> end2DPosition;
    private Subscription subscription = () -> {};

    @Override
    public final IndexRange getRange() {
        return (IndexRange)this.range.getValue();
    }

    @Override
    public final ObservableValue<IndexRange> rangeProperty() {
        return this.range;
    }

    @Override
    public final int getLength() {
        return (Integer)this.length.getValue();
    }

    @Override
    public final ObservableValue<Integer> lengthProperty() {
        return this.length;
    }

    @Override
    public final int getParagraphSpan() {
        return (Integer)this.paragraphSpan.getValue();
    }

    @Override
    public final ObservableValue<Integer> paragraphSpanProperty() {
        return this.paragraphSpan;
    }

    @Override
    public final ObservableValue<StyledDocument<PS, SEG, S>> selectedDocumentProperty() {
        return this.selectedDocument;
    }

    @Override
    public final StyledDocument<PS, SEG, S> getSelectedDocument() {
        return (StyledDocument)this.selectedDocument.getValue();
    }

    @Override
    public final String getSelectedText() {
        return (String)this.selectedText.getValue();
    }

    @Override
    public final ObservableValue<String> selectedTextProperty() {
        return this.selectedText;
    }

    @Override
    public final int getStartPosition() {
        return (Integer)this.startPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> startPositionProperty() {
        return this.startPosition;
    }

    @Override
    public final int getStartParagraphIndex() {
        return (Integer)this.startParagraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> startParagraphIndexProperty() {
        return this.startParagraphIndex;
    }

    @Override
    public final int getStartColumnPosition() {
        return (Integer)this.startColumnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> startColumnPositionProperty() {
        return this.startColumnPosition;
    }

    @Override
    public final int getEndPosition() {
        return (Integer)this.endPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> endPositionProperty() {
        return this.endPosition;
    }

    @Override
    public final int getEndParagraphIndex() {
        return (Integer)this.endParagraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> endParagraphIndexProperty() {
        return this.endParagraphIndex;
    }

    @Override
    public final int getEndColumnPosition() {
        return (Integer)this.endColumnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> endColumnPositionProperty() {
        return this.endColumnPosition;
    }

    @Override
    public final Optional<Bounds> getSelectionBounds() {
        return (Optional)this.bounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.bounds;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public final ObservableValue<Boolean> beingUpdatedProperty() {
        return this.beingUpdated;
    }

    public SelectionImpl(GenericStyledArea<PS, SEG, S> area) {
        this(area, 0, 0);
    }

    public SelectionImpl(GenericStyledArea<PS, SEG, S> area, int startPosition, int endPosition) {
        this(area, area.beingUpdatedProperty(), new IndexRange(startPosition, endPosition));
    }

    public SelectionImpl(GenericStyledArea<PS, SEG, S> area, SuspendableNo dependentBeingUpdated, int startPosition, int endPosition) {
        this(area, dependentBeingUpdated, new IndexRange(startPosition, endPosition));
    }

    public SelectionImpl(GenericStyledArea<PS, SEG, S> area, SuspendableNo dependentBeingUpdated, IndexRange range) {
        this.area = area;
        this.dependentBeingUpdated = dependentBeingUpdated;
        this.internalRange = Var.newSimpleVar((Object)range);
        this.range = this.internalRange.suspendable();
        this.length = this.internalRange.map(IndexRange::getLength).suspendable();
        Val documentVal = Val.create(() -> area.subDocument((IndexRange)this.internalRange.getValue()), (Observable[])new Observable[]{this.internalRange, area.getParagraphs()});
        this.selectedDocument = documentVal.suspendable();
        this.selectedText = documentVal.map(StyledDocument::getText).suspendable();
        this.start2DPosition = Var.newSimpleVar((Object)this.position(0, 0));
        this.end2DPosition = this.start2DPosition.map(startPos2D -> this.getLength() == 0 ? startPos2D : startPos2D.offsetBy(this.getLength(), TwoDimensional.Bias.Backward));
        this.internalRange.addListener(obs -> {
            IndexRange sel = (IndexRange)this.internalRange.getValue();
            this.start2DPosition.setValue((Object)area.offsetToPosition(sel.getStart(), TwoDimensional.Bias.Forward));
        });
        this.startPosition = this.internalRange.map(IndexRange::getStart).suspendable();
        this.startParagraphIndex = this.start2DPosition.map(TwoDimensional.Position::getMajor);
        this.startColumnPosition = this.start2DPosition.map(TwoDimensional.Position::getMinor);
        this.endPosition = this.internalRange.map(IndexRange::getEnd).suspendable();
        this.endParagraphIndex = this.end2DPosition.map(TwoDimensional.Position::getMajor);
        this.endColumnPosition = this.end2DPosition.map(TwoDimensional.Position::getMinor);
        this.paragraphSpan = Val.combine(this.startParagraphIndex, this.endParagraphIndex, (startP, endP) -> endP - startP + 1);
        this.dirty = EventStreams.merge((EventStream[])new EventStream[]{EventStreams.invalidationsOf(this.rangeProperty()), EventStreams.invalidationsOf(area.getParagraphs())});
        this.bounds = Val.create(() -> area.getSelectionBoundsOnScreen(this), area.boundsDirtyFor(this.dirty));
        this.manageSubscription(area.plainTextChanges(), plainTextChange -> {
            int netLength = plainTextChange.getNetLength();
            if (netLength != 0) {
                int indexOfChange = plainTextChange.getPosition();
                int endOfChange = indexOfChange + Math.abs(netLength);
                if (this.getLength() != 0) {
                    int selectionStart = this.getStartPosition();
                    int selectionEnd = this.getEndPosition();
                    if (indexOfChange < selectionStart) {
                        int n = selectionStart = selectionStart < endOfChange ? indexOfChange : selectionStart + netLength;
                    }
                    if (indexOfChange < selectionEnd) {
                        selectionEnd = selectionEnd < endOfChange ? indexOfChange : selectionEnd + netLength;
                    }
                    this.selectRange(selectionStart, selectionEnd);
                } else if (this.getLength() < this.getEndPosition()) {
                    this.selectRange(this.getLength(), this.getLength());
                }
            }
        });
        Suspendable omniSuspendable = Suspendable.combine((Suspendable[])new Suspendable[]{this.beingUpdated, this.endPosition, this.startPosition, this.selectedText, this.selectedDocument, this.length, this.range});
        this.manageSubscription(omniSuspendable.suspendWhen((ObservableValue)dependentBeingUpdated));
    }

    @Override
    public void selectRange(int startParagraphIndex, int startColPosition, int endParagraphIndex, int endColPosition) {
        this.selectRange(this.textPosition(startParagraphIndex, startColPosition), this.textPosition(endParagraphIndex, endColPosition));
    }

    @Override
    public void selectRange(int startPosition, int endPosition) {
        this.selectRange(new IndexRange(startPosition, endPosition));
    }

    private void selectRange(IndexRange range) {
        Runnable updateRange = () -> this.internalRange.setValue((Object)range);
        if (this.dependentBeingUpdated.get()) {
            updateRange.run();
        } else {
            this.dependentBeingUpdated.suspendWhile(updateRange);
        }
    }

    @Override
    public void updateStartBy(int amount, Selection.Direction direction) {
        this.moveBoundary(direction, amount, this.getStartPosition(), newStartTextPos -> IndexRange.normalize((int)newStartTextPos, (int)this.getEndPosition()));
    }

    @Override
    public void updateEndBy(int amount, Selection.Direction direction) {
        this.moveBoundary(direction, amount, this.getEndPosition(), newEndTextPos -> IndexRange.normalize((int)this.getStartPosition(), (int)newEndTextPos));
    }

    @Override
    public void updateStartTo(int position) {
        this.selectRange(position, this.getEndPosition());
    }

    @Override
    public void updateStartTo(int paragraphIndex, int columnPosition) {
        this.selectRange(this.textPosition(paragraphIndex, columnPosition), this.getEndPosition());
    }

    @Override
    public void updateStartByBreaksForward(int numOfBreaks, BreakIterator breakIterator) {
        this.updateStartByBreaks(numOfBreaks, breakIterator, true);
    }

    @Override
    public void updateStartByBreaksBackward(int numOfBreaks, BreakIterator breakIterator) {
        this.updateStartByBreaks(numOfBreaks, breakIterator, false);
    }

    @Override
    public void updateEndTo(int position) {
        this.selectRange(this.getStartPosition(), position);
    }

    @Override
    public void updateEndTo(int paragraphIndex, int columnPosition) {
        this.selectRange(this.getStartPosition(), this.textPosition(paragraphIndex, columnPosition));
    }

    @Override
    public void updateEndByBreaksForward(int numOfBreaks, BreakIterator breakIterator) {
        this.updateEndByBreaks(numOfBreaks, breakIterator, true);
    }

    @Override
    public void updateEndByBreaksBackward(int numOfBreaks, BreakIterator breakIterator) {
        this.updateEndByBreaks(numOfBreaks, breakIterator, false);
    }

    @Override
    public void selectAll() {
        this.selectRange(0, this.area.getLength());
    }

    @Override
    public void selectParagraph(int paragraphIndex) {
        int start = this.textPosition(paragraphIndex, 0);
        int end = start + this.area.getParagraphLength(paragraphIndex);
        this.selectRange(start, end);
    }

    @Override
    public void selectWord(int wordPositionInArea) {
        if (this.area.getLength() == 0) {
            return;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(this.area.getText());
        breakIterator.preceding(wordPositionInArea);
        breakIterator.next();
        int wordStart = breakIterator.current();
        breakIterator.following(wordPositionInArea);
        breakIterator.next();
        int wordEnd = breakIterator.current();
        this.selectRange(wordStart, wordEnd);
    }

    @Override
    public void dispose() {
        this.subscription.unsubscribe();
    }

    private <T> void manageSubscription(EventStream<T> stream, Consumer<T> consumer) {
        this.manageSubscription(stream.subscribe(consumer));
    }

    private void manageSubscription(Subscription s) {
        this.subscription = this.subscription.and(s);
    }

    private TwoDimensional.Position position(int row, int col) {
        return this.area.position(row, col);
    }

    private int textPosition(int row, int col) {
        return this.position(row, col).toOffset();
    }

    private void moveBoundary(Selection.Direction direction, int amount, int oldBoundaryPosition, Function<Integer, IndexRange> updatedRange) {
        switch (direction) {
            case LEFT: {
                this.moveBoundary(() -> oldBoundaryPosition - amount, pos -> 0 <= pos, updatedRange);
                break;
            }
            default: {
                this.moveBoundary(() -> oldBoundaryPosition + amount, pos -> pos <= this.area.getLength(), updatedRange);
            }
        }
    }

    private void moveBoundary(IntSupplier textPosition, Function<Integer, Boolean> boundsCheckPasses, Function<Integer, IndexRange> updatedRange) {
        int newTextPosition = textPosition.getAsInt();
        if (boundsCheckPasses.apply(newTextPosition).booleanValue()) {
            this.selectRange(updatedRange.apply(newTextPosition));
        }
    }

    private void updateStartByBreaks(int numOfBreaks, BreakIterator breakIterator, boolean forwardsNotBackwards) {
        this.updateSelectionByBreaks(numOfBreaks, breakIterator, forwardsNotBackwards, true);
    }

    private void updateEndByBreaks(int numOfBreaks, BreakIterator breakIterator, boolean forwardsNotBackwards) {
        this.updateSelectionByBreaks(numOfBreaks, breakIterator, forwardsNotBackwards, false);
    }

    private void updateSelectionByBreaks(int numOfBreaks, BreakIterator breakIterator, boolean followingNotPreceding, boolean updateStartNotEnd) {
        Runnable updateSelection;
        int pos;
        if (this.area.getLength() == 0) {
            return;
        }
        breakIterator.setText(this.area.getText());
        if (updateStartNotEnd) {
            pos = this.getStartPosition();
            updateSelection = () -> this.selectRange(breakIterator.current(), this.getEndPosition());
        } else {
            pos = this.getEndPosition();
            updateSelection = () -> this.selectRange(this.getStartPosition(), breakIterator.current());
        }
        if (followingNotPreceding) {
            breakIterator.following(pos);
        } else {
            breakIterator.preceding(pos);
        }
        breakIterator.next(numOfBreaks);
        updateSelection.run();
    }
}

