/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableValue;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.MaterializedListModification;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.SuspendableList;
import org.reactfx.collection.UnmodifiableByDefaultLiveList;
import org.reactfx.util.BiIndex;
import org.reactfx.util.Lists;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;

class GenericEditableStyledDocumentBase<PS, SEG, S>
implements EditableStyledDocument<PS, SEG, S> {
    private ReadOnlyStyledDocument<PS, SEG, S> doc;
    private final EventSource<RichTextChange<PS, SEG, S>> internalRichChanges = new EventSource();
    private final SuspendableEventStream<RichTextChange<PS, SEG, S>> richChanges = this.internalRichChanges.pausable();
    private final Val<String> internalText = Val.create(() -> this.doc.getText(), this.internalRichChanges);
    private final SuspendableVal<String> text = this.internalText.suspendable();
    private final Val<Integer> internalLength = Val.create(() -> this.doc.length(), this.internalRichChanges);
    private final SuspendableVal<Integer> length = this.internalLength.suspendable();
    private final EventSource<MaterializedListModification<Paragraph<PS, SEG, S>>> parChanges = new EventSource();
    private final SuspendableList<Paragraph<PS, SEG, S>> paragraphs = new ParagraphList().suspendable();
    private final SuspendableNo beingUpdated = new SuspendableNo();

    @Override
    public EventStream<RichTextChange<PS, SEG, S>> richChanges() {
        return this.richChanges;
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    public Val<String> textProperty() {
        return this.text;
    }

    @Override
    public int getLength() {
        return (Integer)this.length.getValue();
    }

    @Override
    public Val<Integer> lengthProperty() {
        return this.length;
    }

    @Override
    public int length() {
        return (Integer)this.length.getValue();
    }

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public ReadOnlyStyledDocument<PS, SEG, S> snapshot() {
        return this.doc;
    }

    @Override
    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    GenericEditableStyledDocumentBase(ReadOnlyStyledDocument<PS, SEG, S> initialContent) {
        this.doc = initialContent;
        Suspendable omniSuspendable = Suspendable.combine((Suspendable[])new Suspendable[]{this.text, this.length, this.richChanges, this.paragraphs});
        omniSuspendable.suspendWhen((ObservableValue)this.beingUpdated);
    }

    GenericEditableStyledDocumentBase(Paragraph<PS, SEG, S> initialParagraph) {
        this(new ReadOnlyStyledDocument<PS, SEG, S>(Collections.singletonList(initialParagraph)));
    }

    GenericEditableStyledDocumentBase(PS initialParagraphStyle, S initialStyle, SegmentOps<SEG, S> segmentOps) {
        this(new Paragraph<PS, SEG, S>(initialParagraphStyle, segmentOps, segmentOps.createEmptySeg(), initialStyle));
    }

    @Override
    public TwoDimensional.Position position(int major, int minor) {
        return this.doc.position(major, minor);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int offset, TwoDimensional.Bias bias) {
        return this.doc.offsetToPosition(offset, bias);
    }

    @Override
    public void replace(int start, int end, StyledDocument<PS, SEG, S> replacement) {
        this.ensureValidRange(start, end);
        this.doc.replace(start, end, ReadOnlyStyledDocument.from(replacement)).exec(this::update);
    }

    @Override
    public void setStyle(int from, int to, S style) {
        this.ensureValidRange(from, to);
        this.doc.replace(from, to, removed -> removed.mapParagraphs(par -> par.restyle(style))).exec(this::update);
    }

    @Override
    public void setStyle(int paragraphIndex, S style) {
        this.ensureValidParagraphIndex(paragraphIndex);
        this.doc.replaceParagraph(paragraphIndex, p -> p.restyle(style)).exec(this::update);
    }

    @Override
    public void setStyle(int paragraphIndex, int fromCol, int toCol, S style) {
        this.ensureValidParagraphRange(paragraphIndex, fromCol, toCol);
        this.doc.replace(new BiIndex(paragraphIndex, fromCol), new BiIndex(paragraphIndex, toCol), d -> d.mapParagraphs(p -> p.restyle(style))).exec(this::update);
    }

    @Override
    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        this.ensureValidRange(from, from + len);
        this.doc.replace(from, from + len, d -> {
            TwoDimensional.Position i = styleSpans.position(0, 0);
            ArrayList pars = new ArrayList(d.getParagraphs().size());
            for (Paragraph p : d.getParagraphs()) {
                TwoDimensional.Position j = i.offsetBy(p.length(), TwoDimensional.Bias.Backward);
                StyleSpans spans = styleSpans.subView(i, j);
                pars.add(p.restyle(0, spans));
                i = j.offsetBy(1, TwoDimensional.Bias.Forward);
            }
            return new ReadOnlyStyledDocument(pars);
        }).exec(this::update);
    }

    @Override
    public void setStyleSpans(int paragraphIndex, int from, StyleSpans<? extends S> styleSpans) {
        this.setStyleSpans(this.doc.position(paragraphIndex, from).toOffset(), styleSpans);
    }

    @Override
    public void setParagraphStyle(int paragraphIndex, PS style) {
        this.ensureValidParagraphIndex(paragraphIndex);
        this.doc.replaceParagraph(paragraphIndex, p -> p.setParagraphStyle(style)).exec(this::update);
    }

    @Override
    public StyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> that) {
        return this.doc.concat((StyledDocument)that);
    }

    @Override
    public StyledDocument<PS, SEG, S> subSequence(int start, int end) {
        return this.doc.subSequence(start, end);
    }

    private void ensureValidParagraphIndex(int parIdx) {
        Lists.checkIndex((int)parIdx, (int)this.doc.getParagraphCount());
    }

    private void ensureValidRange(int start, int end) {
        Lists.checkRange((int)start, (int)end, (int)this.length());
    }

    private void ensureValidParagraphRange(int par, int start, int end) {
        this.ensureValidParagraphIndex(par);
        Lists.checkRange((int)start, (int)end, (int)this.fullLength(par));
    }

    private int fullLength(int par) {
        int n = this.doc.getParagraphCount();
        return this.doc.getParagraph(par).length() + (par == n - 1 ? 0 : 1);
    }

    private void update(ReadOnlyStyledDocument<PS, SEG, S> newValue, RichTextChange<PS, SEG, S> change, MaterializedListModification<Paragraph<PS, SEG, S>> parChange) {
        this.doc = newValue;
        this.beingUpdated.suspendWhile(() -> {
            this.internalRichChanges.push((Object)change);
            this.parChanges.push((Object)parChange);
        });
    }

    private class ParagraphList
    extends LiveListBase<Paragraph<PS, SEG, S>>
    implements UnmodifiableByDefaultLiveList<Paragraph<PS, SEG, S>> {
        private ParagraphList() {
        }

        public Paragraph<PS, SEG, S> get(int index) {
            return GenericEditableStyledDocumentBase.this.doc.getParagraph(index);
        }

        public int size() {
            return GenericEditableStyledDocumentBase.this.doc.getParagraphCount();
        }

        protected Subscription observeInputs() {
            return GenericEditableStyledDocumentBase.this.parChanges.subscribe(mod -> {
                mod = mod.trim();
                QuasiListModification qmod = QuasiListModification.create((int)mod.getFrom(), (List)mod.getRemoved(), (int)mod.getAddedSize());
                this.notifyObservers(qmod.asListChange());
            });
        }
    }
}

