/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.undo;

import java.time.Duration;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.impl.FixedSizeChangeQueue;
import org.fxmisc.undo.impl.UndoManagerImpl;
import org.fxmisc.undo.impl.UnlimitedChangeQueue;
import org.fxmisc.undo.impl.ZeroSizeChangeQueue;
import org.reactfx.EventStream;

public interface UndoManagerFactory {
    default public <C> UndoManager<C> create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
        return this.create(changeStream, invert, apply, (c1, c2) -> Optional.empty());
    }

    default public <C> UndoManager<C> create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
        return this.create(changeStream, invert, apply, merge, c -> false);
    }

    default public <C> UndoManager<C> create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity) {
        return this.create(changeStream, invert, apply, merge, isIdentity, Duration.ZERO);
    }

    public <C> UndoManager<C> create(EventStream<C> var1, Function<? super C, ? extends C> var2, Consumer<C> var3, BiFunction<C, C, Optional<C>> var4, Predicate<C> var5, Duration var6);

    public static <C> UndoManager<C> unlimitedHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply) {
        return UndoManagerFactory.unlimitedHistoryUndoManager(changeStream, invert, apply, (c1, c2) -> Optional.empty());
    }

    public static <C> UndoManager<C> unlimitedHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge) {
        return UndoManagerFactory.unlimitedHistoryUndoManager(changeStream, invert, apply, merge, c -> false, Duration.ZERO);
    }

    public static <C> UndoManager<C> unlimitedHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity) {
        return UndoManagerFactory.unlimitedHistoryUndoManager(changeStream, invert, apply, merge, isIdentity, Duration.ZERO);
    }

    public static <C> UndoManager<C> unlimitedHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
        UnlimitedChangeQueue queue = new UnlimitedChangeQueue();
        return new UndoManagerImpl<C>(queue, invert, apply, merge, isIdentity, changeStream, preventMergeDelay);
    }

    public static UndoManagerFactory unlimitedHistoryFactory() {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager<C> create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.unlimitedHistoryUndoManager(changeStream, invert, apply, merge, isIdentity, preventMergeDelay);
            }
        };
    }

    public static <C> UndoManager<C> fixedSizeHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, int capacity) {
        return UndoManagerFactory.fixedSizeHistoryUndoManager(changeStream, invert, apply, (c1, c2) -> Optional.empty(), capacity);
    }

    public static <C> UndoManager<C> fixedSizeHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, int capacity) {
        return UndoManagerFactory.fixedSizeHistoryUndoManager(changeStream, invert, apply, merge, c -> false, Duration.ZERO, capacity);
    }

    public static <C> UndoManager<C> fixedSizeHistoryUndoManager(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay, int capacity) {
        FixedSizeChangeQueue queue = new FixedSizeChangeQueue(capacity);
        return new UndoManagerImpl<C>(queue, invert, apply, merge, isIdentity, changeStream, preventMergeDelay);
    }

    public static UndoManagerFactory fixedSizeHistoryFactory(final int capacity) {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager<C> create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.fixedSizeHistoryUndoManager(changeStream, invert, apply, merge, isIdentity, preventMergeDelay, capacity);
            }
        };
    }

    public static <C> UndoManager<C> zeroHistoryUndoManager(EventStream<C> changeStream) {
        ZeroSizeChangeQueue queue = new ZeroSizeChangeQueue();
        return new UndoManagerImpl<Object>(queue, c -> c, c -> {}, (c1, c2) -> Optional.empty(), c -> false, changeStream);
    }

    public static UndoManagerFactory zeroHistoryFactory() {
        return new UndoManagerFactory(){

            @Override
            public <C> UndoManager<C> create(EventStream<C> changeStream, Function<? super C, ? extends C> invert, Consumer<C> apply, BiFunction<C, C, Optional<C>> merge, Predicate<C> isIdentity, Duration preventMergeDelay) {
                return UndoManagerFactory.zeroHistoryUndoManager(changeStream);
            }
        };
    }
}

