/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.gaul.modernizer_maven_plugin.Utils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public final class SuppressModernizerAnnotationDetector {
    private final Set<String> annotatedClassNames = new HashSet<String>();
    private final Set<String> allClassNames = new HashSet<String>();

    private SuppressModernizerAnnotationDetector() {
    }

    public static Set<String> detect(File file) throws IOException {
        SuppressModernizerAnnotationDetector detector = new SuppressModernizerAnnotationDetector();
        detector.detectInternal(file);
        return detector.computeSuppressedClassNames();
    }

    static Set<String> detect(Class<?> ... classes) throws IOException {
        SuppressModernizerAnnotationDetector detector = new SuppressModernizerAnnotationDetector();
        for (Class<?> clazz : classes) {
            ClassReader classReader = new ClassReader(clazz.getName());
            detector.detectInternal(classReader);
        }
        return detector.computeSuppressedClassNames();
    }

    private Set<String> computeSuppressedClassNames() {
        HashSet<String> suppressedClassNames = new HashSet<String>(this.annotatedClassNames);
        block0: for (String className : this.allClassNames) {
            int index;
            if (suppressedClassNames.contains(className)) continue;
            int fromIndex = 0;
            while ((index = className.indexOf(36, fromIndex)) != -1) {
                boolean outerSuppressed = this.annotatedClassNames.contains(className.substring(0, index));
                if (outerSuppressed) {
                    suppressedClassNames.add(className);
                    continue block0;
                }
                fromIndex = index + 1;
            }
        }
        return suppressedClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectInternal(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] children = file.list();
            if (children != null) {
                for (String child : children) {
                    this.detectInternal(new File(file, child));
                }
            }
        } else if (file.getPath().endsWith(".class")) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                this.detectInternal(new ClassReader((InputStream)inputStream));
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(inputStream);
                throw throwable;
            }
            Utils.closeQuietly(inputStream);
        }
    }

    private void detectInternal(ClassReader classReader) {
        classReader.accept((ClassVisitor)new Visitor(), 0);
    }

    private final class Visitor
    extends ClassVisitor {
        private String className;

        Visitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            SuppressModernizerAnnotationDetector.this.allClassNames.add(this.className);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            boolean isSuppressModernizer = Type.getType((String)desc).getClassName().equals(SuppressModernizer.class.getName());
            if (isSuppressModernizer) {
                SuppressModernizerAnnotationDetector.this.annotatedClassNames.add(this.className);
            }
            return super.visitAnnotation(desc, visible);
        }
    }
}

