/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.deopt.DeoptimizationRuntime;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.nodes.UnreachableNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

public final class DeoptHostedSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    protected static void deoptSnippet(@Snippet.ConstantParameter DeoptimizationReason reason, @Snippet.ConstantParameter Boolean mustNotAllocate, String message) {
        if (reason == DeoptimizationReason.NullCheckException) {
            if (mustNotAllocate.booleanValue()) {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_CACHED_NULL_POINTER_EXCEPTION);
            } else {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_NEW_NULL_POINTER_EXCEPTION);
            }
        } else if (reason == DeoptimizationReason.BoundsCheckException) {
            if (mustNotAllocate.booleanValue()) {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION);
            } else {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_NEW_OUT_OF_BOUNDS_EXCEPTION);
            }
        } else if (reason == DeoptimizationReason.ClassCastException) {
            if (mustNotAllocate.booleanValue()) {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_CACHED_CLASS_CAST_EXCEPTION);
            } else {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_NEW_CLASS_CAST_EXCEPTION);
            }
        } else if (reason == DeoptimizationReason.ArrayStoreException) {
            if (mustNotAllocate.booleanValue()) {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_CACHED_ARRAY_STORE_EXCEPTION);
            } else {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_NEW_ARRAY_STORE_EXCEPTION);
            }
        } else if (reason == DeoptimizationReason.ArithmeticException) {
            if (mustNotAllocate.booleanValue()) {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_CACHED_ARITHMETIC_EXCEPTION);
            } else {
                SubstrateIntrinsics.runtimeCall(ImplicitExceptions.THROW_NEW_ARITHMETIC_EXCEPTION);
            }
        } else if (reason == DeoptimizationReason.UnreachedCode || reason == DeoptimizationReason.TypeCheckedInliningViolated || reason == DeoptimizationReason.NotCompiledExceptionHandler || reason == DeoptimizationReason.Unresolved || reason == DeoptimizationReason.JavaSubroutineMismatch) {
            SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)SnippetRuntime.UNSUPPORTED_FEATURE, message);
        } else if (reason == DeoptimizationReason.TransferToInterpreter && DeoptimizationSupport.enabled()) {
            SubstrateIntrinsics.runtimeCall((ForeignCallDescriptor)DeoptimizationRuntime.DEOPTIMIZE, Deoptimizer.encodeDeoptActionAndReasonToLong(DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter, 0), null);
        }
        throw UnreachableNode.unreachable();
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new DeoptHostedSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private DeoptHostedSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(DeoptimizeNode.class, new DeoptimizeLowering());
    }

    private static boolean mustNotAllocate(ResolvedJavaMethod method) {
        return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(method);
    }

    protected class DeoptimizeLowering
    implements NodeLoweringProvider<DeoptimizeNode> {
        private final SnippetTemplate.SnippetInfo deopt;

        protected DeoptimizeLowering() {
            this.deopt = DeoptHostedSnippets.this.snippet(DeoptHostedSnippets.class, "deoptSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(DeoptimizeNode node, LoweringTool tool) {
            String message;
            LoweringTool.LoweringStage loweringStage = tool.getLoweringStage();
            if (loweringStage != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            switch (node.getReason()) {
                case NullCheckException: 
                case BoundsCheckException: 
                case ClassCastException: 
                case ArrayStoreException: 
                case ArithmeticException: {
                    message = null;
                    break;
                }
                case UnreachedCode: 
                case TypeCheckedInliningViolated: 
                case NotCompiledExceptionHandler: {
                    message = "Code that was considered unreachable by closed-world analysis was reached";
                    break;
                }
                case Unresolved: {
                    message = "Unresolved element found " + (node.getNodeSourcePosition() != null ? node.getNodeSourcePosition().toString() : "");
                    break;
                }
                case JavaSubroutineMismatch: {
                    message = "A JSR/RET structure that could not be simplified by the compiler was reached. The JSR bytecode is unused and deprecated since Java 6. Please recompile your application with a newer Java compiler.";
                    break;
                }
                case TransferToInterpreter: {
                    message = null;
                    if (DeoptimizationSupport.enabled()) break;
                    throw VMError.shouldNotReachHere("TransferToInterpreter is only intended for deoptimization testing when the DeoptimizationFeature is enabled");
                }
                default: {
                    throw VMError.shouldNotReachHere("Unexpected reason: " + node.getReason());
                }
            }
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.deopt, graph.getGuardsStage(), loweringStage);
            args.addConst("reason", (Object)node.getReason());
            args.addConst("mustNotAllocate", (Object)DeoptHostedSnippets.mustNotAllocate(graph.method()));
            args.add("message", (Object)message);
            DeoptHostedSnippets.this.template((ValueNode)node, args).instantiate(DeoptHostedSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

