/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoaderHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class NativeLibrarySupport {
    private final ReentrantLock lock = new ReentrantLock();
    private final List<PlatformNativeLibrarySupport.NativeLibrary> knownLibraries = new ArrayList<PlatformNativeLibrarySupport.NativeLibrary>();
    private final Deque<PlatformNativeLibrarySupport.NativeLibrary> currentLoadContext = new ArrayDeque<PlatformNativeLibrarySupport.NativeLibrary>();
    private String[] paths;
    private LibraryInitializer libraryInitializer;

    static void initialize() {
        ImageSingletons.add(NativeLibrarySupport.class, (Object)new NativeLibrarySupport());
    }

    public static NativeLibrarySupport singleton() {
        return (NativeLibrarySupport)ImageSingletons.lookup(NativeLibrarySupport.class);
    }

    private NativeLibrarySupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerLibraryInitializer(LibraryInitializer initializer) {
        assert (this.libraryInitializer == null);
        this.libraryInitializer = initializer;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void preregisterUninitializedBuiltinLibrary(String name) {
        this.knownLibraries.add(PlatformNativeLibrarySupport.singleton().createLibrary(name, true));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isPreregisteredBuiltinLibrary(String name) {
        return this.knownLibraries.stream().anyMatch(l -> l.isBuiltin() && l.getCanonicalIdentifier().equals(name));
    }

    public void loadLibrary(String name, boolean isAbsolute) {
        if (isAbsolute) {
            if (this.loadLibrary0(new File(name), false)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + name);
        }
        if (this.loadLibrary0(new File(name), true)) {
            return;
        }
        String libname = System.mapLibraryName(name);
        if (this.paths == null) {
            String[] tokens = SubstrateUtil.split(System.getProperty("java.library.path", ""), File.pathSeparator);
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].isEmpty()) continue;
                tokens[i] = ".";
            }
            this.paths = tokens;
        }
        for (String path : this.paths) {
            File libpath = new File(path, libname);
            if (this.loadLibrary0(libpath, false)) {
                return;
            }
            File altpath = Target_java_lang_ClassLoaderHelper.mapAlternativeName(libpath);
            if (altpath == null || !this.loadLibrary0(libpath, false)) continue;
            return;
        }
        throw new UnsatisfiedLinkError("no " + name + " in java.library.path");
    }

    private boolean loadLibrary0(File file, boolean asBuiltin) {
        String canonical;
        try {
            canonical = asBuiltin ? file.getName() : file.getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        return this.addLibrary(asBuiltin, canonical, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addLibrary(boolean asBuiltin, String canonical, boolean loadAndInitialize) {
        this.lock.lock();
        try {
            PlatformNativeLibrarySupport.NativeLibrary lib = null;
            for (PlatformNativeLibrarySupport.NativeLibrary known : this.knownLibraries) {
                if (!canonical.equals(known.getCanonicalIdentifier())) continue;
                if (known.isLoaded()) {
                    boolean bl = true;
                    return bl;
                }
                assert (known.isBuiltin()) : "non-built-in libraries must always have been loaded";
                assert (asBuiltin) : "must have tried loading as built-in first";
                lib = known;
                break;
            }
            if (asBuiltin && lib == null && (this.libraryInitializer == null || !this.libraryInitializer.isBuiltinLibrary(canonical))) {
                boolean bl = false;
                return bl;
            }
            for (PlatformNativeLibrarySupport.NativeLibrary loading : this.currentLoadContext) {
                if (!canonical.equals(loading.getCanonicalIdentifier())) continue;
                boolean bl = true;
                return bl;
            }
            boolean created = false;
            if (lib == null) {
                lib = PlatformNativeLibrarySupport.singleton().createLibrary(canonical, asBuiltin);
                created = true;
            }
            if (loadAndInitialize) {
                this.currentLoadContext.push(lib);
                try {
                    if (!lib.load()) {
                        boolean loading = false;
                        return loading;
                    }
                    if (this.libraryInitializer != null) {
                        this.libraryInitializer.initialize(lib);
                    }
                }
                finally {
                    PlatformNativeLibrarySupport.NativeLibrary top = this.currentLoadContext.pop();
                    assert (top == lib);
                }
            }
            if (created) {
                this.knownLibraries.add(lib);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointerBase findSymbol(String name) {
        this.lock.lock();
        try {
            for (PlatformNativeLibrarySupport.NativeLibrary lib : this.knownLibraries) {
                PointerBase entry = lib.findSymbol(name);
                if (!entry.isNonNull()) continue;
                PointerBase pointerBase = entry;
                return pointerBase;
            }
            PointerBase pointerBase = WordFactory.nullPointer();
            return pointerBase;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void registerInitializedBuiltinLibrary(String name) {
        this.addLibrary(true, name, false);
    }

    public static interface LibraryInitializer {
        public boolean isBuiltinLibrary(String var1);

        public void initialize(PlatformNativeLibrarySupport.NativeLibrary var1);
    }
}

