/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.headers.ZLib;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
public final class JavaUtilZipSubstitutions {

    public static final class Util_java_util_zip_Inflater {
        public static void doSetDictionary(long addr, CCharPointer bytes, int len) {
            ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
            int res = ZLib.inflateSetDictionary(strm, bytes, len);
            if (res == ZLib.Z_OK()) {
                return;
            }
            if (res == ZLib.Z_STREAM_ERROR() || res == ZLib.Z_DATA_ERROR()) {
                throw new IllegalArgumentException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
            throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
    }

    public static class Util_java_util_zip_Deflater {
        static int DEF_MEM_LEVEL = 8;

        public static void doSetDictionary(long addr, CCharPointer buf, int len) {
            ZLib.z_stream strm = (ZLib.z_stream)WordFactory.pointer((long)addr);
            int res = ZLib.deflateSetDictionary(strm, buf, len);
            if (res == ZLib.Z_OK()) {
                return;
            }
            if (res == ZLib.Z_STREAM_ERROR()) {
                throw new IllegalArgumentException(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
            }
            throw new InternalError(CTypeConversion.toJavaString((CCharPointer)strm.msg()));
        }
    }
}

