/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.ParkEventConsCell;

final class ParkEventList {
    private static final ParkEventList SINGLETON = new ParkEventList();
    private final UninterruptibleUtils.AtomicReference<ParkEventConsCell> freeList = new UninterruptibleUtils.AtomicReference<Object>(null);

    public static ParkEventList getSingleton() {
        return SINGLETON;
    }

    private ParkEventList() {
    }

    protected void push(ParkEvent element) {
        ParkEventConsCell sampleHead;
        ParkEventConsCell nextHead = element.consumeConsCell();
        do {
            sampleHead = this.freeList.get();
            nextHead.setNext(sampleHead);
        } while (!this.freeList.compareAndSet(sampleHead, nextHead));
    }

    public ParkEvent pop() {
        ParkEventConsCell sampleNext;
        ParkEventConsCell sampleHead;
        do {
            if ((sampleHead = this.freeList.get()) != null) continue;
            return null;
        } while (!this.freeList.compareAndSet(sampleHead, sampleNext = sampleHead.getNext()));
        return sampleHead.getElement();
    }
}

