/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.hosted.c.info.ElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class CInterfaceError {
    private final List<Object> context;
    private final String message;

    public CInterfaceError(String msg, Object ... context) {
        this.context = CInterfaceError.fillContext(context, new ArrayList<Object>());
        this.message = this.fullMessage(msg);
    }

    public List<Object> getContext() {
        return this.context;
    }

    private String fullMessage(String msg) {
        StringBuilder result = new StringBuilder(msg);
        for (Object element : this.context) {
            if (element instanceof ResolvedJavaMethod) {
                result.append("\n    method ").append(((ResolvedJavaMethod)element).format("%H.%n(%p)"));
                continue;
            }
            if (element instanceof ResolvedJavaType) {
                result.append("\n    type ").append(((ResolvedJavaType)element).toJavaName(true));
                continue;
            }
            result.append("\n    ").append(element);
        }
        return result.toString();
    }

    private static List<Object> fillContext(Object obj, List<Object> result) {
        if (obj != null) {
            if (obj instanceof Object[]) {
                for (Object inner : (Object[])obj) {
                    CInterfaceError.fillContext(inner, result);
                }
            } else if (obj instanceof Collection) {
                for (Object inner : (Collection)obj) {
                    CInterfaceError.fillContext(inner, result);
                }
            } else if (obj instanceof ElementInfo) {
                result.add(((ElementInfo)obj).getAnnotatedElement());
            } else {
                result.add(obj);
            }
        }
        return result;
    }

    public String getMessage() {
        return this.message;
    }
}

