/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.server;

import com.oracle.svm.hosted.server.NativeImageBuildServer;
import com.oracle.svm.hosted.server.SubstrateServerMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;

public class NativeImageBuildClient {
    private static final String COMMAND_PREFIX = "-command=";
    private static final int EXIT_FAIL = -1;
    public static final int EXIT_SUCCESS = 0;

    private static void usage(Consumer<String> out) {
        out.accept("Usage:");
        out.accept(String.format("  java -cp <svm_jar_path> " + NativeImageBuildClient.class.getName() + " %s<command> [%s<port_number>] [<command_arguments>]", COMMAND_PREFIX, "-port="));
    }

    public static int run(String[] argsArray, Consumer<byte[]> out, Consumer<byte[]> err) {
        Consumer<String> outln = s -> out.accept((s + "\n").getBytes());
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
        if (args.size() < 1) {
            NativeImageBuildClient.usage(outln);
            return -1;
        }
        if (args.size() == 1 && ((String)args.get(0)).equals("--help")) {
            NativeImageBuildClient.usage(outln);
            return 0;
        }
        Optional<String> command = NativeImageBuildServer.extractArg(args, COMMAND_PREFIX).map(arg -> arg.substring(COMMAND_PREFIX.length()));
        Optional<Integer> port = NativeImageBuildServer.extractPort(args);
        if (port.isPresent() && command.isPresent()) {
            SubstrateServerMessage.ServerCommand serverCommand = SubstrateServerMessage.ServerCommand.valueOf(command.get());
            return NativeImageBuildClient.sendRequest(serverCommand, String.join((CharSequence)" ", args).getBytes(), port.get(), out, err);
        }
        NativeImageBuildClient.usage(outln);
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int sendRequest(SubstrateServerMessage.ServerCommand command, byte[] payload, int port, Consumer<byte[]> out, Consumer<byte[]> err) {
        Consumer<String> outln = s -> out.accept((s + "\n").getBytes());
        Consumer<String> errln = s -> err.accept((s + "\n").getBytes());
        try (Socket svmClient = new Socket((String)null, port);
             DataOutputStream os = new DataOutputStream(svmClient.getOutputStream());
             DataInputStream is = new DataInputStream(svmClient.getInputStream());){
            SubstrateServerMessage serverCommand;
            SubstrateServerMessage.send(new SubstrateServerMessage(command, payload), os);
            if (SubstrateServerMessage.ServerCommand.GET_VERSION.equals((Object)command)) {
                SubstrateServerMessage response = SubstrateServerMessage.receive(is);
                if (response == null) return 0;
                outln.accept(new String(response.payload));
                return 0;
            }
            while ((serverCommand = SubstrateServerMessage.receive(is)) != null) {
                Consumer<byte[]> selectedConsumer;
                switch (serverCommand.command) {
                    case WRITE_OUT: {
                        selectedConsumer = out;
                        break;
                    }
                    case WRITE_ERR: {
                        selectedConsumer = err;
                        break;
                    }
                    case SEND_STATUS: {
                        int n = ByteBuffer.wrap(serverCommand.payload).getInt();
                        return n;
                    }
                    default: {
                        throw new RuntimeException("Invalid command sent by the image build server: " + (Object)((Object)serverCommand.command));
                    }
                }
                if (selectedConsumer == null) continue;
                selectedConsumer.accept(serverCommand.payload);
            }
            int n = -1;
            return n;
        }
        catch (IOException e) {
            if (SubstrateServerMessage.ServerCommand.GET_VERSION.equals((Object)command)) return -1;
            errln.accept("Could not connect to image build server running on port " + port);
            errln.accept("Underlying exception: " + e);
            return -1;
        }
    }

    public static void main(String[] argsArray) {
        System.exit(NativeImageBuildClient.run(argsArray, System.out::print, System.err::print));
    }
}

