/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage.impl;

import java.util.Objects;

public final class UnresolvedConfigurationCondition
implements Comparable<UnresolvedConfigurationCondition> {
    private static final UnresolvedConfigurationCondition JAVA_LANG_OBJECT_REACHED = new UnresolvedConfigurationCondition(Object.class.getTypeName(), true);
    public static final String TYPE_REACHED_KEY = "typeReached";
    public static final String TYPE_REACHABLE_KEY = "typeReachable";
    private final String typeName;
    private final boolean runtimeChecked;

    public static UnresolvedConfigurationCondition create(String typeName, boolean runtimeChecked) {
        Objects.requireNonNull(typeName);
        if (JAVA_LANG_OBJECT_REACHED.getTypeName().equals(typeName)) {
            return JAVA_LANG_OBJECT_REACHED;
        }
        return new UnresolvedConfigurationCondition(typeName, runtimeChecked);
    }

    private UnresolvedConfigurationCondition(String typeName, boolean runtimeChecked) {
        this.typeName = typeName;
        this.runtimeChecked = runtimeChecked;
    }

    public static UnresolvedConfigurationCondition alwaysTrue() {
        return JAVA_LANG_OBJECT_REACHED;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isRuntimeChecked() {
        return this.runtimeChecked;
    }

    public boolean isAlwaysTrue() {
        return this.typeName.equals(JAVA_LANG_OBJECT_REACHED.getTypeName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedConfigurationCondition that = (UnresolvedConfigurationCondition)o;
        return this.runtimeChecked == that.runtimeChecked && Objects.equals(this.typeName, that.typeName);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.runtimeChecked);
    }

    @Override
    public int compareTo(UnresolvedConfigurationCondition o) {
        int res = Boolean.compare(this.runtimeChecked, o.runtimeChecked);
        if (res != 0) {
            return res;
        }
        return this.typeName.compareTo(o.typeName);
    }

    public String toString() {
        String field = this.runtimeChecked ? TYPE_REACHED_KEY : TYPE_REACHABLE_KEY;
        return "[" + field + ": \"" + this.typeName + "\"]";
    }
}

