/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSLogHandler;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.logging.LogRecord;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.word.PointerBase;

final class HSLogHandlerGen {
    HSLogHandlerGen() {
    }

    static HSLogHandler createNativeToHS(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
        return new StartPoint(hSPolyglotObject, jNIEnv);
    }

    private static final class StartPoint
    extends HSLogHandler {
        private static final BinaryMarshaller<LogRecord> logRecordMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(HSPolyglotObject hSPolyglotObject, JNI.JNIEnv jNIEnv) {
            super(hSPolyglotObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void publishImpl(LogRecord logRecord) {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = logRecordMarshaller.inferSize((Object)logRecord);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        logRecordMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)logRecord);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostHandler.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.publishImplMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        void flushImpl() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostHandler.getHandle());
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.flushImplMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            logRecordMarshaller = jNIConfig.lookupMarshaller(LogRecord.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod publishImplMethod;
            final JNICalls.JNIMethod flushImplMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.publishImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"publishImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$LogHandler;[B)V");
                this.flushImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"flushImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$LogHandler;)V");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<LogRecord> logRecordMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void publishImpl(AbstractPolyglotImpl.LogHandler logHandler, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                LogRecord logRecord = (LogRecord)logRecordMarshaller.read(binaryInput);
                logHandler.publish(logRecord);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void flushImpl(AbstractPolyglotImpl.LogHandler logHandler) {
            try {
                logHandler.flush();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            logRecordMarshaller = jNIConfig.lookupMarshaller(LogRecord.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

