/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.polyglot.enterprise.CleanableWeakReference;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineOptions;
import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineOptionsOptionDescriptors;
import com.oracle.truffle.polyglot.enterprise.HSFileSystem;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativeContextDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativeEngine;
import com.oracle.truffle.polyglot.enterprise.NativeEngineDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativeExecutionEventDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativeExecutionListenerDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativeInstrumentDispatch;
import com.oracle.truffle.polyglot.enterprise.NativeInstrumentDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativeLanguageDispatch;
import com.oracle.truffle.polyglot.enterprise.NativeLanguageDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativePolyglotIsolateServices;
import com.oracle.truffle.polyglot.enterprise.NativePolyglotIsolateServicesGen;
import com.oracle.truffle.polyglot.enterprise.NativeSourceDispatchGen;
import com.oracle.truffle.polyglot.enterprise.NativeSourceSectionDispatchGen;
import com.oracle.truffle.polyglot.enterprise.PolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateCreateException;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateHostFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.enterprise.EnterpriseTruffle;
import com.oracle.truffle.sandbox.enterprise.e;
import com.oracle.truffle.sandbox.enterprise.h;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.graalvm.collections.Pair;
import org.graalvm.home.HomeFinder;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectCleaner;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.word.WordFactory;

public final class EnterprisePolyglotImpl
extends AbstractPolyglotImpl {
    static final String[] EMPTY_LANGUAGES = new String[0];
    private static final String ISOLATE_RESOURCE_FORMAT = "%s-isolate-%s-%s";
    private static final String[] ISOLATE_SPECIFIC_OPTIONS = new String[]{"engine.HostCallStackHeadRoom", "engine.IsolateMemoryProtection", "engine.UntrustedCodeMitigation", "engine.MaxIsolateMemory"};
    private static final String ENTERPRISE_TRUFFLE_VERSION;
    private static final long INTERPRETER_CALL_OVERHEAD = 4096L;
    private static final long INTERPRETER_NODE_OVERHEAD = 128L;
    static EnterprisePolyglotImpl instance;
    private volatile Lazy lazy;
    private final Map<String, LibraryConfig> libraryCache = new ConcurrentHashMap<String, LibraryConfig>();

    private static long getMinInterpreterCallStackheadRoom(int n2) {
        return 4096L + 128L * (long)n2;
    }

    public EnterprisePolyglotImpl() {
        EnterprisePolyglotImpl.storeInstance(this);
    }

    private static void storeInstance(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        instance = enterprisePolyglotImpl;
    }

    private static <T> T parseOption(OptionKey<T> optionKey, String string, Map<String, String> map) {
        String string2 = map.get(string);
        if (string2 != null) {
            return (T)optionKey.getType().convert(string2);
        }
        return (T)optionKey.getDefaultValue();
    }

    private static boolean hasBeenSet(String string, Map<String, String> map) {
        return map.get(string) != null;
    }

    protected OptionDescriptors createEngineOptionDescriptors() {
        return new EnterpriseEngineOptionsOptionDescriptors();
    }

    public Object buildEngine(String[] stringArray, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, Map<String, String> map, boolean bl, boolean bl2, MessageTransport messageTransport, Object object, Object object2, boolean bl3, boolean bl4, Object object3) {
        Map<String, String> map2;
        String[] stringArray2;
        if ((!ImageInfo.inImageCode() || ImageSingletons.contains(PolyglotIsolateHostFeatureEnabled.class) && PolyglotIsolate.lazy == null) && (stringArray2 = EnterprisePolyglotImpl.resolveIsolatedLanguages(map2 = EnterprisePolyglotImpl.validateOptions(sandboxPolicy, map))) != null) {
            Object object4 = super.buildEngine(EMPTY_LANGUAGES, sandboxPolicy, outputStream, outputStream2, inputStream, this.localOptions(map2), bl, bl2, messageTransport, object, object2, true, false, null);
            LibraryConfig libraryConfig = this.resolveNativeIsolatePath(this.getAPIAccess().getEngineReceiver(object4), stringArray, stringArray2, map2);
            return this.spawnIsolatedEngine(object4, stringArray, sandboxPolicy, outputStream, outputStream2, inputStream, map2, bl, bl2, messageTransport, libraryConfig, bl4);
        }
        return this.getNext().buildEngine(stringArray, sandboxPolicy, outputStream, outputStream2, inputStream, map, bl, bl2, messageTransport, object, object2, bl3, bl4, object3);
    }

    public void onEngineCreated(Object object) {
        EngineData engineData = (EngineData)EnterpriseEngineAccessor.ENGINE.getEngineData(object);
        OptionValues optionValues = EnterpriseEngineAccessor.ENGINE.getEngineOptionValues(object);
        engineData.interpreterCallStackHeadRoom = (Long)optionValues.get(EnterpriseEngineOptions.InterpreterCallStackHeadRoom);
        if (engineData.interpreterCallStackHeadRoom != 0L && !h.al()) {
            throw EnterpriseEngineAccessor.ENGINE.createPolyglotEngineException((RuntimeException)new IllegalArgumentException("The engine.InterpreterCallStackHeadRoom option is set to a non-zero value, but the option is not supported on the current VM. In order to resolve this either switch to a VM that supports the option or don't set it."));
        }
        this.getNext().onEngineCreated(object);
    }

    private static Map<String, String> validateOptions(SandboxPolicy sandboxPolicy, Map<String, String> map) {
        EnterpriseEngineOptions.UntrustedCodeMitigationPolicy untrustedCodeMitigationPolicy;
        Map<String, String> map2;
        if (sandboxPolicy == SandboxPolicy.TRUSTED) {
            map2 = map;
        } else {
            map2 = new HashMap<String, String>(map);
            if (sandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED)) {
                long l2 = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.MaxIsolateMemory, "engine.MaxIsolateMemory", map);
                if (l2 == -1L) {
                    throw EngineData.sandboxPolicyException((SandboxPolicy)sandboxPolicy, (String)"The engine.MaxIsolateMemory option is not set, but must be set to maximum polyglot isolate heap size.", (String)"set Builder.option(\"engine.MaxIsolateMemory\", \"<maximum isolate heap size>\")");
                }
                long l3 = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.HostCallStackHeadRoom, "engine.HostCallStackHeadRoom", map);
                if (l3 < 131072L) {
                    throw EngineData.sandboxPolicyException((SandboxPolicy)sandboxPolicy, (String)String.format("The engine.HostCallStackHeadRoom option is set to %dB, but must be set to at least 128KB.", l3), (String)String.format("use the default value by removing Builder.option(\"engine.HostCallStackHeadRoom\", \"%dB\") or increase its value", l3));
                }
                String[] stringArray = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.SpawnIsolate, "engine.SpawnIsolate", map);
                if (stringArray == null) {
                    if (EnterprisePolyglotImpl.hasBeenSet("engine.SpawnIsolate", map)) {
                        throw EngineData.sandboxPolicyException((SandboxPolicy)sandboxPolicy, (String)"The engine.SpawnIsolate option is set to false, but must be set to true or to the set of languages that should be initialized.", (String)"use the engine's permitted languages by removing Builder.option(\"engine.SpawnIsolate\", \"false\") or set it to the set of languages that should be initialized");
                    }
                    map2.put("engine.SpawnIsolate", "true");
                }
            }
            if (sandboxPolicy.isStricterOrEqual(SandboxPolicy.UNTRUSTED)) {
                EnterpriseEngineOptions.UntrustedCodeMitigationPolicy untrustedCodeMitigationPolicy2;
                if (!h.ak() && EnterprisePolyglotImpl.hasBeenSet("sandbox.MaxASTDepth", map)) {
                    int n2 = EnterprisePolyglotImpl.parseOption(e.bd, "sandbox.MaxASTDepth", map);
                    long l4 = EnterprisePolyglotImpl.getMinInterpreterCallStackheadRoom(n2);
                    if (EnterprisePolyglotImpl.hasBeenSet("engine.InterpreterCallStackHeadRoom", map)) {
                        long l5 = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.InterpreterCallStackHeadRoom, "engine.InterpreterCallStackHeadRoom", map);
                        if (l5 < l4) {
                            throw EngineData.sandboxPolicyException((SandboxPolicy)sandboxPolicy, (String)("The engine.InterpreterCallStackHeadRoom option is set too low, minimum engine.InterpreterCallStackHeadRoom for sandbox.MaxASTDepth " + n2 + " is " + l4 + " bytes."), (String)"set engine.InterpreterCallStackHeadRoom higher, sandbox.MaxASTDepth lower, or leave engine.InterpreterCallStackHeadRoom unset and let the system figure out the right value");
                        }
                    } else {
                        map2.put("engine.InterpreterCallStackHeadRoom", l4 + "B");
                    }
                }
                if ((untrustedCodeMitigationPolicy2 = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.UntrustedCodeMitigation, "engine.UntrustedCodeMitigation", map)) == EnterpriseEngineOptions.UntrustedCodeMitigationPolicy.NONE) {
                    if (EnterprisePolyglotImpl.hasBeenSet("engine.UntrustedCodeMitigation", map)) {
                        throw EngineData.sandboxPolicyException((SandboxPolicy)sandboxPolicy, (String)"The engine.UntrustedCodeMitigation option is set to none, but must be set to software.", (String)"use the default value (software) by removing Builder.option(\"engine.UntrustedCodeMitigation\", \"none\") or set it to software");
                    }
                    map2.put("engine.UntrustedCodeMitigation", "software");
                } else if (untrustedCodeMitigationPolicy2 == EnterpriseEngineOptions.UntrustedCodeMitigationPolicy.HARDWARE) {
                    throw EngineData.sandboxPolicyException((SandboxPolicy)sandboxPolicy, (String)"The engine.UntrustedCodeMitigation option is set to hardware, but must be set to software.", (String)"use the default value (software) by removing Builder.option(\"engine.UntrustedCodeMitigation\", \"hardware\") or set it to software");
                }
            }
        }
        if (EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.SpawnIsolate, "engine.SpawnIsolate", map2) == null) {
            String string = null;
            for (int i2 = 0; i2 < ISOLATE_SPECIFIC_OPTIONS.length; ++i2) {
                if (!EnterprisePolyglotImpl.hasBeenSet(ISOLATE_SPECIFIC_OPTIONS[i2], map2)) continue;
                string = ISOLATE_SPECIFIC_OPTIONS[i2];
                break;
            }
            if (string != null) {
                throw new IllegalArgumentException(String.format("The isolated heap is not enabled, but isolate specific option %s is set. In order to resolve this enable heap isolation by setting Builder.sandbox(SandboxPolicy.ISOLATED) or by setting the Builder.option(\"engine.SpawnIsolate\", \"true\") or remove the isolate specific option.", string));
            }
        }
        if ((untrustedCodeMitigationPolicy = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.UntrustedCodeMitigation, "engine.UntrustedCodeMitigation", map2)) == EnterpriseEngineOptions.UntrustedCodeMitigationPolicy.HARDWARE) {
            boolean bl = EnterprisePolyglotImpl.hasBeenSet("engine.IsolateMemoryProtection", map2);
            boolean bl2 = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.IsolateMemoryProtection, "engine.IsolateMemoryProtection", map2);
            if (bl && !bl2) {
                throw new IllegalArgumentException("The engine.UntrustedCodeMitigation is set to hardware, but the engine.IsolateMemoryProtection is set to false. In order to resolve this remove Builder.option(\"engine.UntrustedCodeMitigation\", \"hardware\") to use the software untrusted code mitigation or remove Builder.option(\"engine.IsolateMemoryProtection\", \"false\") to use the hardware untrusted code mitigation");
            }
        }
        return map2;
    }

    private static String[] resolveIsolatedLanguages(Map<String, String> map) {
        String[] stringArray = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.SpawnIsolate, "engine.SpawnIsolate", map);
        if (stringArray == null && EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.UntrustedCodeMitigation, "engine.UntrustedCodeMitigation", map) != EnterpriseEngineOptions.UntrustedCodeMitigationPolicy.NONE) {
            stringArray = EMPTY_LANGUAGES;
        }
        return stringArray;
    }

    private LibraryConfig resolveNativeIsolatePath(Object object, String[] stringArray, String[] stringArray2, Map<String, String> map) {
        assert (stringArray2 != null);
        String string = EnterprisePolyglotImpl.parseOption(EnterpriseEngineOptions.IsolateLibrary, "engine.IsolateLibrary", map);
        return this.resolveLibraryPath(object, string, stringArray, stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object spawnIsolatedEngine(Object object, String[] stringArray, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, Map<String, String> map, boolean bl, boolean bl2, MessageTransport messageTransport, LibraryConfig libraryConfig, boolean bl3) {
        Lazy lazy = this.ensureIsolateLibraryInitialized(libraryConfig);
        AbstractPolyglotImpl.APIAccess aPIAccess = this.getAPIAccess();
        OptionValues optionValues = EnterpriseEngineAccessor.ENGINE.getEngineOptionValues(aPIAccess.getEngineReceiver(object));
        int n2 = 0;
        if (EnterpriseEngineOptions.isIsolateMemoryProtection(optionValues)) {
            n2 = -1;
        }
        long l2 = EnterprisePolyglotImpl.createIsolate(n2);
        long l3 = EnterprisePolyglotImpl.getIsolateId(l2);
        NativeIsolate nativeIsolate = NativeIsolate.forIsolateId((long)l3, (JNIConfig)PolyglotJNIConfig.getInstance());
        boolean bl4 = false;
        NativeIsolateThread nativeIsolateThread = nativeIsolate.enter();
        try {
            long l4 = EnterprisePolyglotImpl.initializeIsolate(nativeIsolateThread.getIsolateThreadId());
            if (l4 == 0L) {
                throw new IllegalStateException("Failed to initialize an isolate.");
            }
            NativePolyglotIsolateServices nativePolyglotIsolateServices = NativePolyglotIsolateServicesGen.create(nativeIsolate, l4);
            String string = libraryConfig.resourcePath != null ? libraryConfig.resourcePath.toAbsolutePath().toString() : null;
            nativePolyglotIsolateServices.initialize(lazy.polyglotHostServices, string);
            if (EnterpriseEngineOptions.isIsolateMemoryProtection(optionValues) && !nativePolyglotIsolateServices.isMemoryProtected()) {
                throw new PolyglotIsolateCreateException("Memory Protection not available");
            }
            long l5 = (Long)EnterpriseEngineOptions.HostCallStackHeadRoom.getValue(optionValues);
            Object object2 = aPIAccess.getEngineReceiver(object);
            AbstractPolyglotImpl.AbstractEngineDispatch abstractEngineDispatch = aPIAccess.getEngineDispatch(object);
            AbstractPolyglotImpl.LogHandler logHandler = EnterpriseEngineAccessor.ENGINE.getEngineLogHandler(object2);
            long l6 = nativePolyglotIsolateServices.buildEngine(stringArray, sandboxPolicy, outputStream, outputStream2, inputStream, map, bl, bl2, messageTransport, logHandler, lazy.notificationHostService);
            NativeEngine nativeEngine = new NativeEngine(this, nativeIsolate, l6, object, bl2, l5, nativePolyglotIsolateServices);
            Object object3 = aPIAccess.newEngine(lazy.hostEngineDispatch, (Object)nativeEngine, bl3);
            abstractEngineDispatch.setAPI(object2, object3);
            lazy.registerEngine(object3, nativeEngine);
            bl4 = true;
            Object object4 = object3;
            return object4;
        }
        finally {
            nativeIsolateThread.leave();
            if (!bl4) {
                nativeIsolate.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lazy ensureIsolateLibraryInitialized(LibraryConfig libraryConfig) {
        Path path = libraryConfig.libraryPath();
        Lazy lazy = this.lazy;
        if (lazy == null) {
            EnterprisePolyglotImpl enterprisePolyglotImpl = this;
            synchronized (enterprisePolyglotImpl) {
                lazy = this.lazy;
                if (lazy == null) {
                    Path path2 = path.toAbsolutePath();
                    System.load(path2.toString());
                    this.lazy = lazy = new Lazy(this, path2);
                }
            }
        }
        try {
            if (!lazy.libraryPath.equals(path) && !Files.isSameFile(lazy.libraryPath, path)) {
                throw new IllegalStateException(String.format("A native library for engine.SpawnIsolate at location '%s' was already loaded. A new native library was attempted to be loaded at path '%s'. Only one native library can be used per process at a time. Explicitly specify the set loaded library with the --engine.IsolateLibrary=/path/to/lib option or use --engine.SpawnIsolate=false to disable this feature to resolve this problem.", lazy.libraryPath, path));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Cannot resolve isolate library path.", iOException);
        }
        return lazy;
    }

    private LibraryConfig resolveLibraryPath(Object object, String string, String[] stringArray, String[] stringArray2) {
        String string2;
        if (string != null) {
            Path path = Paths.get(string, new String[0]);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return new LibraryConfig(path);
            }
            throw new IllegalArgumentException(String.format("The isolate library specified at path '%s' does not exist.", string));
        }
        HomeFinder homeFinder = HomeFinder.getInstance();
        if (stringArray.length > 1 || stringArray2.length > 1 || stringArray.length == 0 && stringArray2.length == 0) {
            Collection<String> collection = EnterprisePolyglotImpl.resolveAvailableLanguages(homeFinder);
            throw new IllegalArgumentException(String.format("Spawning multiple languages using the --engine.SpawnIsolate option is not yet supported. The following languages currently support spawning isolates: %s. To resolve this problem either: %n - Specify one of the supported languages when constructing the engine or context with Engine.newBuilder(...) or Context.newBuilder(...). %n - Specify one of the supported languages using the --engine.SpawnIsolate=<language> option or alternatively using -Dpolyglot.engine.SpawnIsolate=<language> system property. %n - Specify the path to the isolate libary using --engine.IsolateLibrary=/path/to/lib (use only for testing).", collection));
        }
        if (stringArray.length > 0 && stringArray2.length > 0) {
            if (!stringArray[0].equals(stringArray2[0])) {
                throw new IllegalArgumentException(String.format("The permitted language %s does not match the spawned language %s. They must match in order to resolve an isolate library.", stringArray[0], stringArray2[0]));
            }
            string2 = stringArray[0];
        } else if (stringArray.length > 0) {
            string2 = stringArray[0];
        } else {
            assert (stringArray2.length > 0);
            string2 = stringArray2[0];
        }
        assert (string2 != null);
        LibraryConfig libraryConfig = this.resolveLanguagePath(object, string2, (Path)homeFinder.getLanguageHomes().get(string2));
        if (libraryConfig == null) {
            Collection<String> collection = EnterprisePolyglotImpl.resolveAvailableLanguages(homeFinder);
            throw new IllegalArgumentException(String.format("No native isolate library found for language '%s'. The following languages currently support spawning isolates: %s. To resolve this problem either: %n - Specify one of the supported languages when constructing the engine or context with Engine.newBuilder(...) or Context.newBuilder(...). %n - Specify one of the supported languages using the --engine.SpawnIsolate=<language> option or alternatively using -Dpolyglot.engine.SpawnIsolate=<language> system property. %n - Specify the path to the isolate libary using --engine.IsolateLibrary=/path/to/lib (use only for testing).", string2, collection));
        }
        return libraryConfig;
    }

    private static Collection<String> resolveAvailableLanguages(HomeFinder homeFinder) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Object object : homeFinder.getLanguageHomes().keySet()) {
            Object object2 = EnterprisePolyglotImpl.resolveLibraryInLanguageHome((String)object, (Path)homeFinder.getLanguageHomes().get(object));
            if (object2 == null) continue;
            treeSet.add((String)object);
        }
        String string = String.format(ISOLATE_RESOURCE_FORMAT, "", InternalResource.OS.getCurrent(), InternalResource.CPUArchitecture.getCurrent());
        for (Object object2 : EnterpriseEngineAccessor.ENGINE.getResourceIds("engine")) {
            if (!((String)object2).endsWith(string)) continue;
            treeSet.add(((String)object2).substring(0, ((String)object2).length() - string.length()));
        }
        return treeSet;
    }

    private LibraryConfig resolveLanguagePath(Object object, String string, Path path) {
        LibraryConfig libraryConfig = this.libraryCache.get(string);
        if (libraryConfig == null && (libraryConfig = path == null ? EnterprisePolyglotImpl.resolveLibraryFromResource(object, string) : EnterprisePolyglotImpl.resolveLibraryInLanguageHome(string, path)) != null) {
            this.libraryCache.putIfAbsent(string, libraryConfig);
        }
        return libraryConfig;
    }

    private static LibraryConfig resolveLibraryInLanguageHome(String string, Path path) {
        Path path2 = path.resolve("lib").resolve(EnterprisePolyglotImpl.languageLibraryName(string));
        if (Files.isRegularFile(path2, new LinkOption[0])) {
            return new LibraryConfig(path2);
        }
        return null;
    }

    private static LibraryConfig resolveLibraryFromResource(Object object, String string) {
        String string2 = String.format(ISOLATE_RESOURCE_FORMAT, string, InternalResource.OS.getCurrent(), InternalResource.CPUArchitecture.getCurrent());
        try {
            Path path = EnterpriseEngineAccessor.ENGINE.getEngineResource(object, string2);
            if (path != null) {
                return new LibraryConfig(path.resolve(EnterprisePolyglotImpl.languageLibraryName(string)), path.resolve("resources"));
            }
            return null;
        }
        catch (IOException iOException) {
            throw new InternalError(iOException);
        }
    }

    private static String languageLibraryName(String string) {
        return System.mapLibraryName(string + "vm");
    }

    public int getPriority() {
        if (EnterpriseTruffle.supportsEnterpriseExtensions()) {
            return 42;
        }
        return Integer.MIN_VALUE;
    }

    public AbstractPolyglotImpl.ThreadScope createThreadScope() {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return new JNIThreadScope(this, lazy);
        }
        return super.createThreadScope();
    }

    public boolean isInCurrentEngineHostCallback(Object object) {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return lazy.polyglotHostServices.isInCurrentEngineHostCallback(CurrentIsolate.getIsolate().rawValue(), lazy.engineHandleByEngineReceiver.get(object));
        }
        return super.isInCurrentEngineHostCallback(object);
    }

    public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return lazy.polyglotHostServices.isDefaultProcessHandler(processHandler);
        }
        return super.isDefaultProcessHandler(processHandler);
    }

    public boolean isInternalFileSystem(FileSystem fileSystem) {
        if (fileSystem instanceof HSFileSystem) {
            HSFileSystem hSFileSystem = (HSFileSystem)fileSystem;
            PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
            return lazy.polyglotHostServices.isInternalFileSystem(hSFileSystem);
        }
        return super.isInternalFileSystem(fileSystem);
    }

    public String getTruffleVersion() {
        return ENTERPRISE_TRUFFLE_VERSION;
    }

    public void validateVirtualThreadCreation(OptionValues optionValues) {
        if (optionValues.get(EnterpriseEngineOptions.SpawnIsolate) != null) {
            throw EnterpriseEngineAccessor.ENGINE.createPolyglotEngineException((RuntimeException)new IllegalStateException("Using isolated polyglot contexts together with Java virtual threads is currently not supported."));
        }
    }

    AbstractPolyglotImpl.AbstractSourceDispatch getSourceDispatch() {
        return this.lazy.hostSourceDispatch;
    }

    AbstractPolyglotImpl.AbstractSourceSectionDispatch getSourceSectionDispatch() {
        return this.lazy.hostSourceSectionDispatch;
    }

    AbstractPolyglotImpl.AbstractExecutionListenerDispatch getExecutionListenerDispatch() {
        return this.lazy.hostExecutionListenerDispatch;
    }

    AbstractPolyglotImpl.AbstractExecutionEventDispatch getExecutionEventDispatch() {
        return this.lazy.hostExecutionEventDispatch;
    }

    NativeInstrumentDispatch getHostInstrumentDispatch() {
        return this.lazy.hostInstrumentDispatch;
    }

    NativeLanguageDispatch getHostLanguageDispatch() {
        return this.lazy.hostLanguageDispatch;
    }

    AbstractPolyglotImpl.AbstractContextDispatch getHostContextDispatch() {
        return this.lazy.hostContextDispatch;
    }

    void registerContext(Object object, NativeContext nativeContext) {
        this.lazy.registerContext(object, nativeContext);
    }

    void releaseContextRegisteredRequirement(NativeContext nativeContext, boolean bl) {
        this.lazy.releaseContextRegisteredRequirement(nativeContext, bl);
    }

    boolean requireContextRegistered(NativeContext nativeContext) {
        return this.lazy.requireContextRegistered(nativeContext);
    }

    Object findContextByHandle(long l2, long l3) {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return lazy.findContextByHandle(l3);
        }
        Object object = this.lazy.findContextByHandle(l2, l3);
        return object != null ? this.getAPIAccess().getContextReceiver(object) : null;
    }

    Object findEngineReceiverByHandle(long l2, long l3) {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return lazy.findEngineByHandle(l3);
        }
        Object object = this.lazy.findEngineByHandle(l2, l3);
        return object != null ? this.getAPIAccess().getEngineReceiver(object) : null;
    }

    long findEngineHandleByEngineReceiver(Object object) {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return lazy.engineHandleByEngineReceiver.getOrDefault(object, 0L);
        }
        NativeEngine nativeEngine = object instanceof NativeEngine ? (NativeEngine)((Object)object) : (NativeEngine)((Object)this.getAPIAccess().getEngineReceiver(EnterpriseEngineAccessor.ENGINE.getPolyglotEngineAPI(object)));
        return nativeEngine.getHandle();
    }

    long findContextHandleByContextReceiver(Object object) {
        PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
        if (lazy != null) {
            return lazy.contextHandleByContextReceiver.getOrDefault(object, 0L);
        }
        NativeContext nativeContext = object instanceof NativeContext ? (NativeContext)((Object)object) : (NativeContext)((Object)this.getAPIAccess().getContextReceiver(EnterpriseEngineAccessor.ENGINE.getPolyglotContextAPI(object)));
        return nativeContext.getHandle();
    }

    private static void triggerIsolateGC(Object object) {
        Object object2 = instance.getAPIAccess().getEngineReceiver(object);
        if (!(object2 instanceof NativeEngine)) {
            throw new IllegalStateException("Not an isolated engine.");
        }
        EnterprisePolyglotImpl.triggerIsolateGCImpl((NativeEngine)((Object)object2));
    }

    private static Path dumpIsolateHeap(Object object, Path path) throws IOException {
        Object object2 = instance.getAPIAccess().getEngineReceiver(object);
        if (!(object2 instanceof NativeEngine)) {
            throw new IllegalStateException("Not an isolated engine.");
        }
        NativeEngine nativeEngine = (NativeEngine)((Object)object2);
        EnterprisePolyglotImpl.triggerIsolateGCImpl(nativeEngine);
        return Paths.get(nativeEngine.getPolyglotIsolateServices().heapDump(path == null ? null : path.toString()), new String[0]);
    }

    private static NativeIsolate getIsolate(Object object) {
        Object object2 = instance.getAPIAccess().getEngineReceiver(object);
        if (!(object2 instanceof NativeEngine)) {
            throw new IllegalStateException("Not an isolated engine.");
        }
        return ((NativeEngine)((Object)object2)).getIsolate();
    }

    private static void invokeCleaners() {
        CleanableWeakReference.clean();
        NativeObjectCleaner.processPendingCleaners();
    }

    private static void triggerIsolateGCImpl(NativeEngine nativeEngine) {
        EnterprisePolyglotImpl.invokeCleaners();
        nativeEngine.getPolyglotIsolateServices().triggerGC();
    }

    Map<String, String> localOptions(Map<String, String> map) {
        OptionDescriptors optionDescriptors = EnterpriseEngineAccessor.RUNTIME.getRuntimeOptionDescriptors();
        OptionDescriptors optionDescriptors2 = EnterpriseEngineAccessor.LANGUAGE.createOptionDescriptorsUnion(new OptionDescriptors[]{optionDescriptors, this.createAllEngineOptionDescriptors()});
        return map.entrySet().stream().filter(entry -> EnterprisePolyglotImpl.filterLocalOption((String)entry.getKey(), optionDescriptors2)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean filterLocalOption(String string, OptionDescriptors optionDescriptors) {
        if (string.startsWith("engine.") && !string.equals("engine.InterpreterCallStackHeadRoom")) {
            return optionDescriptors.get(string) != null;
        }
        return string.startsWith("log.");
    }

    private static native long createIsolate(int var0) throws PolyglotIsolateCreateException;

    static native long getIsolateId(long var0);

    static native long attachIsolate(long var0);

    static native int detachIsolate(long var0);

    static native long releaseHandle(long var0, long var2);

    private static native int tearDownIsolate(long var0);

    private static native long initializeIsolate(long var0);

    static int tearDownIsolate(long l2, long l3) {
        Lazy lazy = EnterprisePolyglotImpl.instance.lazy;
        AbstractPolyglotImpl.APIAccess aPIAccess = instance.getAPIAccess();
        EngineCleanUpReference engineCleanUpReference = lazy.findEngineReferenceByIsolate(l2);
        if (engineCleanUpReference != null) {
            Object t2 = engineCleanUpReference.get();
            if (t2 != null) {
                NativeEngine nativeEngine = (NativeEngine)((Object)aPIAccess.getEngineReceiver(t2));
                nativeEngine.close();
            }
            lazy.unregisterEngine(engineCleanUpReference.key);
            engineCleanUpReference.polyglotIsolateServices.onIsolateTearDown();
        }
        return EnterprisePolyglotImpl.tearDownIsolate(l3);
    }

    static {
        if (Boolean.getBoolean("polyglotimpl.DisableVersionChecks")) {
            ENTERPRISE_TRUFFLE_VERSION = null;
        } else {
            InputStream inputStream = EnterprisePolyglotImpl.class.getResourceAsStream("/META-INF/graalvm/com.oracle.truffle.enterprise/version");
            if (inputStream == null) {
                throw new InternalError("Enterprise Truffle runtime must have a version file.");
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                ENTERPRISE_TRUFFLE_VERSION = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                throw new InternalError(iOException);
            }
        }
    }

    private record LibraryConfig(Path libraryPath, Path resourcePath) {
        private LibraryConfig {
            Objects.requireNonNull(path, "LibraryPath must be non-null.");
        }

        LibraryConfig(Path path) {
            this(path, null);
        }
    }

    private static final class Lazy {
        final EnterprisePolyglotImpl polyglot;
        final AbstractPolyglotImpl.AbstractEngineDispatch hostEngineDispatch;
        final NativeInstrumentDispatch hostInstrumentDispatch;
        final NativeLanguageDispatch hostLanguageDispatch;
        final AbstractPolyglotImpl.AbstractExecutionListenerDispatch hostExecutionListenerDispatch;
        final AbstractPolyglotImpl.AbstractExecutionEventDispatch hostExecutionEventDispatch;
        final AbstractPolyglotImpl.AbstractSourceDispatch hostSourceDispatch;
        final AbstractPolyglotImpl.AbstractSourceSectionDispatch hostSourceSectionDispatch;
        final AbstractPolyglotImpl.AbstractContextDispatch hostContextDispatch;
        final AbstractPolyglotImpl.AbstractPolyglotHostService notificationHostService;
        final Path libraryPath;
        final PolyglotHostServices polyglotHostServices;
        private final Map<Pair<Long, Long>, CleanableWeakReference<Object>> isolatedEnginesByHandle;
        private final Map<Long, EngineCleanUpReference> isolatedEnginesByIsolate;
        private final Map<Pair<Long, Long>, ContextCleanUpReference> isolatedContextsByHandle;

        private Lazy(EnterprisePolyglotImpl enterprisePolyglotImpl, Path path) {
            this.polyglot = enterprisePolyglotImpl;
            this.libraryPath = path;
            this.isolatedEnginesByHandle = new HashMap<Pair<Long, Long>, CleanableWeakReference<Object>>();
            this.isolatedEnginesByIsolate = new HashMap<Long, EngineCleanUpReference>();
            this.isolatedContextsByHandle = new HashMap<Pair<Long, Long>, ContextCleanUpReference>();
            this.hostEngineDispatch = NativeEngineDispatchGen.create(enterprisePolyglotImpl);
            this.hostInstrumentDispatch = NativeInstrumentDispatchGen.create(enterprisePolyglotImpl);
            this.hostLanguageDispatch = NativeLanguageDispatchGen.create(enterprisePolyglotImpl);
            this.hostSourceDispatch = NativeSourceDispatchGen.create(enterprisePolyglotImpl);
            this.hostSourceSectionDispatch = NativeSourceSectionDispatchGen.create(enterprisePolyglotImpl);
            this.hostExecutionListenerDispatch = NativeExecutionListenerDispatchGen.create(enterprisePolyglotImpl);
            this.hostExecutionEventDispatch = NativeExecutionEventDispatchGen.create(enterprisePolyglotImpl);
            this.hostContextDispatch = NativeContextDispatchGen.create(enterprisePolyglotImpl);
            this.polyglotHostServices = new PolyglotHostServicesImpl(enterprisePolyglotImpl);
            this.notificationHostService = new PolyglotHostServiceImpl(enterprisePolyglotImpl);
        }

        synchronized void registerEngine(Object object, NativeEngine nativeEngine) {
            Pair<Long, Long> pair = nativeEngine.getKey();
            EngineCleanUpReference engineCleanUpReference = new EngineCleanUpReference(object, pair, nativeEngine.getPolyglotIsolateServices());
            assert (this.isolatedEnginesByHandle.get(pair) == null);
            this.isolatedEnginesByHandle.put(pair, engineCleanUpReference);
            this.isolatedEnginesByIsolate.put((Long)pair.getLeft(), engineCleanUpReference);
        }

        synchronized void unregisterEngine(Pair<Long, Long> pair) {
            CleanableWeakReference<Object> cleanableWeakReference = this.isolatedEnginesByHandle.remove(pair);
            if (cleanableWeakReference != null) {
                cleanableWeakReference.invalidate();
            }
            this.isolatedEnginesByIsolate.remove(pair.getLeft());
        }

        synchronized void registerContext(Object object, NativeContext nativeContext) {
            Pair<Long, Long> pair = nativeContext.getKey();
            ContextCleanUpReference contextCleanUpReference = new ContextCleanUpReference(object, this, nativeContext.getIsolate(), nativeContext.getHandle());
            ContextCleanUpReference contextCleanUpReference2 = this.isolatedContextsByHandle.get(pair);
            if (contextCleanUpReference2 != null) {
                if (contextCleanUpReference2.isolate.isDisposed()) {
                    contextCleanUpReference2.invalidate();
                } else {
                    throw new AssertionError((Object)"Replacing an active context reference.");
                }
            }
            this.isolatedContextsByHandle.put(pair, contextCleanUpReference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void releaseContextRegisteredRequirement(NativeContext nativeContext, boolean bl) {
            Object var5_6;
            CleanableWeakReference cleanableWeakReference;
            assert (nativeContext.registrationRequired > 0);
            boolean bl2 = false;
            --nativeContext.registrationRequired;
            if (nativeContext.registrationRequired == 0 && bl) {
                bl2 = true;
                cleanableWeakReference = nativeContext.getIsolate().tryEnter();
                if (cleanableWeakReference != null) {
                    try {
                        nativeContext.release();
                    }
                    finally {
                        cleanableWeakReference.leave();
                    }
                }
            }
            Object v0 = var5_6 = (cleanableWeakReference = (CleanableWeakReference)this.isolatedContextsByHandle.get(nativeContext.getKey())) != null ? cleanableWeakReference.get() : null;
            if (var5_6 != null && this.polyglot.getAPIAccess().getContextReceiver(var5_6) == nativeContext && bl2) {
                cleanableWeakReference.invalidate();
                this.isolatedContextsByHandle.remove(nativeContext.getKey());
            }
        }

        synchronized boolean requireContextRegistered(NativeContext nativeContext) {
            Object var3_3;
            WeakReference weakReference = this.isolatedContextsByHandle.get(nativeContext.getKey());
            Object v0 = var3_3 = weakReference != null ? weakReference.get() : null;
            if (var3_3 != null && this.polyglot.getAPIAccess().getContextReceiver(var3_3) == nativeContext) {
                ++nativeContext.registrationRequired;
                return true;
            }
            return false;
        }

        synchronized Object findEngineByHandle(long l2, long l3) {
            Reference reference = l3 == 0L ? null : (WeakReference)this.isolatedEnginesByHandle.get(Pair.create((Object)l2, (Object)l3));
            return reference == null ? null : reference.get();
        }

        synchronized EngineCleanUpReference findEngineReferenceByIsolate(long l2) {
            return this.isolatedEnginesByIsolate.get(l2);
        }

        synchronized Object findContextByHandle(long l2, long l3) {
            Reference reference = l3 == 0L ? null : (WeakReference)this.isolatedContextsByHandle.get(Pair.create((Object)l2, (Object)l3));
            return reference == null ? null : reference.get();
        }

        private synchronized void cleanUpContext(Pair<Long, Long> pair, ContextCleanUpReference contextCleanUpReference) {
            this.isolatedContextsByHandle.remove(pair, contextCleanUpReference);
        }
    }

    private static final class JNIThreadScope
    extends AbstractPolyglotImpl.ThreadScope {
        private final boolean polyglotThread;
        private final boolean detachFromVM;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        JNIThreadScope(AbstractPolyglotImpl abstractPolyglotImpl, PolyglotIsolate.Lazy lazy) {
            super(abstractPolyglotImpl);
            if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                this.polyglotThread = false;
                this.detachFromVM = false;
                return;
            }
            Thread thread = Thread.currentThread();
            boolean bl = EnterpriseEngineAccessor.ENGINE.isCurrentThreadPolyglotThread();
            boolean bl2 = false;
            if (!lazy.disposed) {
                JNI.JNIEnv jNIEnv = JNIUtil.GetEnv((JNI.JavaVM)lazy.javaVM);
                if (jNIEnv.isNull()) {
                    jNIEnv = JNIUtil.attachCurrentThread((JNI.JavaVM)lazy.javaVM, (boolean)thread.isDaemon(), (String)thread.getName(), (JNI.JObject)((JNI.JObject)WordFactory.nullPointer()));
                    bl2 = true;
                }
                if (!jNIEnv.isNonNull()) throw new AssertionError((Object)String.format("Failed to attach thread %s to host VM.", thread));
                new JNIMethodScope(thread.getName(), jNIEnv);
                if (bl && bl2) {
                    TruffleContext truffleContext = EnterpriseEngineAccessor.ENGINE.getCurrentCreatorTruffleContext();
                    Object object = truffleContext != null ? EnterpriseEngineAccessor.LANGUAGE.getPolyglotContext(truffleContext) : null;
                    lazy.polyglotHostServices.attachPolyglotThread(CurrentIsolate.getIsolate().rawValue(), CurrentIsolate.getCurrentThread().rawValue(), object != null ? lazy.contextHandleByContextReceiver.get(EnterpriseEngineAccessor.ENGINE.getOuterContext(object)) : 0L, truffleContext != null);
                }
            } else if (bl) {
                throw new AssertionError((Object)"Polyglot thread was created during polyglot isolate tear down.");
            }
            this.polyglotThread = bl;
            this.detachFromVM = bl2;
        }

        public void close() {
            if (!ImageSingletons.contains(PolyglotIsolateGuestFeatureEnabled.class)) {
                return;
            }
            JNIMethodScope jNIMethodScope = JNIMethodScope.scopeOrNull();
            if (jNIMethodScope != null) {
                PolyglotIsolate.Lazy lazy = PolyglotIsolate.lazy;
                if (this.polyglotThread && this.detachFromVM) {
                    TruffleContext truffleContext = EnterpriseEngineAccessor.ENGINE.getCurrentCreatorTruffleContext();
                    Object object = truffleContext != null ? EnterpriseEngineAccessor.LANGUAGE.getPolyglotContext(truffleContext) : null;
                    lazy.polyglotHostServices.detachPolyglotThread(CurrentIsolate.getIsolate().rawValue(), CurrentIsolate.getCurrentThread().rawValue(), object != null ? lazy.contextHandleByContextReceiver.get(EnterpriseEngineAccessor.ENGINE.getOuterContext(object)) : 0L, truffleContext != null);
                }
                jNIMethodScope.close();
                if (this.detachFromVM) {
                    JNIUtil.DetachCurrentThread((JNI.JavaVM)lazy.javaVM);
                }
            } else if (this.polyglotThread) {
                throw new AssertionError((Object)"Should not reach here.");
            }
        }
    }

    private static final class EngineCleanUpReference
    extends CleanableWeakReference<Object> {
        private final Pair<Long, Long> key;
        private final NativePolyglotIsolateServices polyglotIsolateServices;

        EngineCleanUpReference(Object object, Pair<Long, Long> pair, NativePolyglotIsolateServices nativePolyglotIsolateServices) {
            super(object);
            this.key = pair;
            this.polyglotIsolateServices = nativePolyglotIsolateServices;
        }

        @Override
        public void run() {
            this.polyglotIsolateServices.getIsolate().shutdown();
        }
    }

    private static final class ContextCleanUpReference
    extends CleanableWeakReference<Object> {
        private final Lazy lazy;
        private final NativeIsolate isolate;
        private final long foreignHandle;

        ContextCleanUpReference(Object object, Lazy lazy, NativeIsolate nativeIsolate, long l2) {
            super(object);
            this.lazy = lazy;
            this.isolate = nativeIsolate;
            this.foreignHandle = l2;
        }

        @Override
        public void run() {
            this.lazy.cleanUpContext((Pair<Long, Long>)Pair.create((Object)this.isolate.getIsolateId(), (Object)this.foreignHandle), this);
        }
    }

    private static final class PolyglotHostServicesImpl
    implements PolyglotHostServices {
        private final EnterprisePolyglotImpl polyglot;

        PolyglotHostServicesImpl(EnterprisePolyglotImpl enterprisePolyglotImpl) {
            this.polyglot = enterprisePolyglotImpl;
        }

        @Override
        public void attachPolyglotThread(long l2, long l3, long l4, boolean bl) {
            NativeIsolate.get((long)l2).registerNativeThread(l3);
            if (bl) {
                NativeContext nativeContext = (NativeContext)((Object)this.polyglot.findContextByHandle(l2, l4));
                if (nativeContext == null) {
                    throw EnterpriseEngineAccessor.ENGINE.createCancelExecution(null, "Context disposed.", false);
                }
                Object object = this.polyglot.getAPIAccess().getContextReceiver(nativeContext.getLocalContext());
                Object[] objectArray = EnterpriseEngineAccessor.ENGINE.enterContextAsPolyglotThread(object);
                assert (objectArray == null);
            }
        }

        @Override
        public void detachPolyglotThread(long l2, long l3, long l4, boolean bl) {
            if (bl) {
                NativeContext nativeContext = (NativeContext)((Object)this.polyglot.findContextByHandle(l2, l4));
                Object object = this.polyglot.getAPIAccess().getContextReceiver(nativeContext.getLocalContext());
                EnterpriseEngineAccessor.ENGINE.leaveContextAsPolyglotThread(object, null);
            }
        }

        @Override
        public long retrieveHostStackOverflowLimit() {
            return OptimizedTruffleRuntime.getRuntime().getStackOverflowLimit();
        }

        @Override
        public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
            return this.polyglot.isDefaultProcessHandler(processHandler);
        }

        @Override
        public boolean isInternalFileSystem(FileSystem fileSystem) {
            return this.polyglot.isInternalFileSystem(fileSystem);
        }

        @Override
        public boolean isInCurrentEngineHostCallback(long l2, long l3) {
            NativeEngine nativeEngine = (NativeEngine)((Object)this.polyglot.findEngineReceiverByHandle(l2, l3));
            Object object = this.polyglot.getAPIAccess().getEngineReceiver(nativeEngine.getLocalEngine());
            return this.polyglot.isInCurrentEngineHostCallback(object);
        }
    }

    public static class PolyglotHostServiceImpl
    extends AbstractPolyglotImpl.AbstractPolyglotHostService {
        final EnterprisePolyglotImpl polyglot;

        public PolyglotHostServiceImpl(EnterprisePolyglotImpl enterprisePolyglotImpl) {
            super((AbstractPolyglotImpl)enterprisePolyglotImpl);
            this.polyglot = enterprisePolyglotImpl;
        }

        public void notifyClearExplicitContextStack(Object object) {
            if (object != null) {
                NativeContext nativeContext = (NativeContext)((Object)object);
                Object object2 = this.polyglot.getAPIAccess().getContextReceiver(nativeContext.getLocalContext());
                EnterpriseEngineAccessor.ENGINE.clearExplicitContextStack(object2);
            }
        }

        public void notifyContextCancellingOrExiting(Object object, boolean bl, int n2, boolean bl2, String string) {
            if (object != null) {
                NativeContext nativeContext = (NativeContext)((Object)object);
                Object object2 = this.polyglot.getAPIAccess().getContextReceiver(nativeContext.getLocalContext());
                EnterpriseEngineAccessor.ENGINE.initiateCancelOrExit(object2, bl, n2, bl2, string);
            }
        }

        public void notifyContextClosed(Object object, boolean bl, boolean bl2, String string) {
            if (object != null) {
                NativeContext nativeContext = (NativeContext)((Object)object);
                Object object2 = this.polyglot.getAPIAccess().getContextReceiver(nativeContext.getLocalContext());
                EnterpriseEngineAccessor.ENGINE.closeContext(object2, bl, bl2, string);
            }
        }

        public void notifyEngineClosed(Object object, boolean bl) {
            if (object != null) {
                NativeEngine nativeEngine = (NativeEngine)((Object)object);
                Object object2 = this.polyglot.getAPIAccess().getEngineReceiver(nativeEngine.getLocalEngine());
                EnterpriseEngineAccessor.ENGINE.closeEngine(object2, bl);
                nativeEngine.getIsolate().shutdown();
            }
        }

        public RuntimeException hostToGuestException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, Throwable throwable) {
            throw new AssertionError((Object)"Should not reach here.");
        }
    }
}

