/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFILibrary;
import com.oracle.truffle.nfi.backend.libffi.LibFFISignature;
import com.oracle.truffle.nfi.backend.libffi.NFIUnsatisfiedLinkError;
import com.oracle.truffle.nfi.backend.libffi.NFIUnsupportedException;
import com.oracle.truffle.nfi.backend.spi.NFIBackend;
import com.oracle.truffle.nfi.backend.spi.NFIBackendLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeLibraryDescriptor;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;
import java.util.Iterator;

@ExportLibrary(value=NFIBackendLibrary.class)
final class LibFFINFIBackend
implements NFIBackend {
    private final LibFFILanguage language;

    LibFFINFIBackend(LibFFILanguage language) {
        this.language = language;
    }

    public CallTarget parse(NativeLibraryDescriptor descriptor) {
        RootNode root;
        LibFFIContext ctx = LibFFILanguage.getCurrentContext();
        if (descriptor.isDefaultLibrary()) {
            root = new GetDefaultLibraryNode(this.language);
        } else {
            int flags = 0;
            boolean lazyOrNow = false;
            if (descriptor.getFlags() != null) {
                Iterator iterator = descriptor.getFlags().iterator();
                while (iterator.hasNext()) {
                    String flag;
                    switch (flag = (String)iterator.next()) {
                        case "RTLD_GLOBAL": {
                            flags |= ctx.RTLD_GLOBAL;
                            break;
                        }
                        case "RTLD_LOCAL": {
                            flags |= ctx.RTLD_LOCAL;
                            break;
                        }
                        case "RTLD_LAZY": {
                            flags |= ctx.RTLD_LAZY;
                            lazyOrNow = true;
                            break;
                        }
                        case "RTLD_NOW": {
                            flags |= ctx.RTLD_NOW;
                            lazyOrNow = true;
                            break;
                        }
                        case "ISOLATED_NAMESPACE": {
                            if (ctx.ISOLATED_NAMESPACE == 0) {
                                throw new NFIUnsupportedException("isolated namespace not supported");
                            }
                            flags |= ctx.ISOLATED_NAMESPACE;
                        }
                    }
                }
            }
            if (!lazyOrNow) {
                flags |= ctx.RTLD_NOW;
            }
            root = new LoadLibraryNode(this.language, descriptor.getFilename(), flags);
        }
        return root.getCallTarget();
    }

    @ExportMessage
    Object getSimpleType(NativeSimpleType type, @CachedLibrary(value="this") InteropLibrary self) {
        return LibFFIContext.get((Node)self).lookupSimpleType(type);
    }

    @ExportMessage
    Object getArrayType(NativeSimpleType type, @CachedLibrary(value="this") InteropLibrary self) {
        return LibFFIContext.get((Node)self).lookupArrayType(type);
    }

    @ExportMessage
    Object getEnvType(@CachedLibrary(value="this") InteropLibrary self) {
        return LibFFIContext.get((Node)self).lookupEnvType();
    }

    @ExportMessage
    Object createSignatureBuilder(@CachedLibrary(value="this") NFIBackendLibrary self, @Cached ProfiledArrayBuilder.ArrayBuilderFactory builderFactory) {
        if (!LibFFIContext.get((Node)self).env.isNativeAccessAllowed()) {
            CompilerDirectives.transferToInterpreter();
            throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)self);
        }
        return new LibFFISignature.SignatureBuilder(builderFactory);
    }

    private static class GetDefaultLibraryNode
    extends RootNode {
        GetDefaultLibraryNode(LibFFILanguage language) {
            super((TruffleLanguage)language);
        }

        public boolean isInternal() {
            return true;
        }

        public Object execute(VirtualFrame frame) {
            if (!LibFFIContext.get((Node)this).env.isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)this);
            }
            return LibFFILibrary.createDefault();
        }
    }

    private static class LoadLibraryNode
    extends RootNode {
        private final String name;
        private final int flags;

        LoadLibraryNode(LibFFILanguage language, String name, int flags) {
            super((TruffleLanguage)language);
            this.name = name;
            this.flags = flags;
        }

        public boolean isInternal() {
            return true;
        }

        public Object execute(VirtualFrame frame) {
            LibFFIContext context = LibFFIContext.get((Node)this);
            if (!context.env.isNativeAccessAllowed()) {
                CompilerDirectives.transferToInterpreter();
                throw new NFIUnsatisfiedLinkError("Access to native code is not allowed by the host environment.", (Node)this);
            }
            return context.loadLibrary(this.name, this.flags);
        }
    }
}

