/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.backend.libffi.ClosureNativePointer;
import com.oracle.truffle.nfi.backend.libffi.FunctionExecuteNode;
import com.oracle.truffle.nfi.backend.libffi.LibFFIClosure;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.LibFFILanguage;
import com.oracle.truffle.nfi.backend.libffi.LibFFISymbol;
import com.oracle.truffle.nfi.backend.libffi.LibFFIType;
import com.oracle.truffle.nfi.backend.libffi.NativeAllocation;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativePointer;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;
import java.util.Arrays;

@ExportLibrary(value=NFIBackendSignatureLibrary.class, useForAOT=true, useForAOTPriority=1)
final class LibFFISignature {
    private final long cif;
    final CachedSignatureInfo signatureInfo;

    @CompilerDirectives.TruffleBoundary
    @NeverDefault
    public static LibFFISignature create(LibFFIContext context, CachedSignatureInfo info, LibFFIType retType, int argCount, int fixedArgCount, LibFFIType[] argTypes) {
        long cif;
        LibFFIType realRetType = retType;
        if (retType == null) {
            realRetType = context.lookupSimpleType(NativeSimpleType.VOID);
        }
        if ((cif = fixedArgCount == -1 ? context.prepareSignature(realRetType, argCount, argTypes) : context.prepareSignatureVarargs(realRetType, argCount, fixedArgCount, argTypes)) == 0L) {
            throw CompilerDirectives.shouldNotReachHere((String)String.format("invalid signature (ret: %s, argCount: %d, fixedArgCount: %d, args: %s)", retType, argCount, fixedArgCount, Arrays.toString(argTypes)));
        }
        return LibFFISignature.create(cif, info);
    }

    private static LibFFISignature create(long cif, CachedSignatureInfo info) {
        assert (cif > 0L);
        LibFFISignature ret = new LibFFISignature(cif, info);
        NativeAllocation.getGlobalQueue().registerNativeAllocation(ret, new NativeAllocation.FreeDestructor(cif));
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    @NeverDefault
    public static CachedSignatureInfo prepareSignatureInfo(LibFFIType.CachedTypeInfo retTypeInfo, ArgsState state) {
        LibFFIType.Direction allowedCallDirection;
        if (retTypeInfo instanceof LibFFIType.ArrayType) {
            throw new IllegalArgumentException("array type as return value is not supported");
        }
        boolean allowJavaToNativeCall = state.allowJavaToNativeCall;
        boolean allowNativeToJavaCall = state.allowNativeToJavaCall;
        switch (retTypeInfo.allowedDataFlowDirection) {
            case JAVA_TO_NATIVE_ONLY: {
                allowJavaToNativeCall = false;
                break;
            }
            case NATIVE_TO_JAVA_ONLY: {
                allowNativeToJavaCall = false;
            }
        }
        if (allowNativeToJavaCall) {
            allowedCallDirection = allowJavaToNativeCall ? LibFFIType.Direction.BOTH : LibFFIType.Direction.NATIVE_TO_JAVA_ONLY;
        } else if (allowJavaToNativeCall) {
            allowedCallDirection = LibFFIType.Direction.JAVA_TO_NATIVE_ONLY;
        } else {
            throw new IllegalArgumentException("invalid signature");
        }
        LibFFIType.CachedTypeInfo[] argTypesInfo = new LibFFIType.CachedTypeInfo[state.argCount];
        ArgsState curState = state;
        for (int i = state.argCount - 1; i >= 0; --i) {
            argTypesInfo[i] = curState.lastArg;
            curState = curState.prev;
        }
        return new CachedSignatureInfo(LibFFILanguage.get(null), retTypeInfo, argTypesInfo, state.primitiveSize, state.objectCount, allowedCallDirection);
    }

    private LibFFISignature(long cif, CachedSignatureInfo signatureInfo) {
        this.cif = cif;
        this.signatureInfo = signatureInfo;
    }

    @ExportLibrary(value=NFIBackendSignatureBuilderLibrary.class)
    static final class SignatureBuilder {
        static final int NOT_VARARGS = -1;
        @NeverDefault
        ArgsState state = ArgsState.NO_ARGS;
        LibFFIType.CachedTypeInfo retTypeInfo;
        LibFFIType retType;
        ProfiledArrayBuilder<LibFFIType> argTypes;
        int fixedArgCount = -1;
        private static final ProfiledArrayBuilder.ArrayFactory<LibFFIType> FACTORY = new ProfiledArrayBuilder.ArrayFactory<LibFFIType>(){

            public LibFFIType[] create(int size) {
                return new LibFFIType[size];
            }
        };

        SignatureBuilder(ProfiledArrayBuilder.ArrayBuilderFactory factory) {
            this.argTypes = factory.allocate(FACTORY);
        }

        void addArg(LibFFIType arg, ArgsState newState) {
            assert (this.state.argCount + 1 == newState.argCount);
            this.argTypes.add((Object)arg);
            this.state = newState;
        }

        LibFFIType maybePromote(Node node, LibFFIType argType) {
            if (this.fixedArgCount == -1) {
                return argType;
            }
            return argType.varargsPromoteType(node);
        }

        @ExportMessage
        void makeVarargs() {
            this.fixedArgCount = this.state.argCount;
        }

        @ExportMessage
        @ImportStatic(value={LibFFISignature.class})
        static class Build {
            Build() {
            }

            @Specialization(guards={"builder.state == cachedState", "builder.retTypeInfo == cachedRetType"}, limit="1")
            static Object doCached(SignatureBuilder builder, @Cached(value="builder.state") ArgsState cachedState, @Cached(value="builder.retType.typeInfo") LibFFIType.CachedTypeInfo cachedRetType, @CachedLibrary(value="builder") NFIBackendSignatureBuilderLibrary self, @Cached(value="prepareSignatureInfo(cachedRetType, cachedState)") CachedSignatureInfo cachedSigInfo) {
                return LibFFISignature.create(LibFFIContext.get((Node)self), cachedSigInfo, builder.retType, cachedState.argCount, builder.fixedArgCount, (LibFFIType[])builder.argTypes.getFinalArray());
            }

            @Specialization(replaces={"doCached"})
            static Object doGeneric(SignatureBuilder builder, @CachedLibrary(value="builder") NFIBackendSignatureBuilderLibrary self) {
                CachedSignatureInfo sigInfo = LibFFISignature.prepareSignatureInfo(builder.retType.typeInfo, builder.state);
                return LibFFISignature.create(LibFFIContext.get((Node)self), sigInfo, builder.retType, builder.state.argCount, builder.fixedArgCount, (LibFFIType[])builder.argTypes.getFinalArray());
            }
        }

        @ExportMessage
        static class AddArgument {
            AddArgument() {
            }

            static boolean isSame(LibFFIType.CachedTypeInfo v0, LibFFIType.CachedTypeInfo v1) {
                return v0 == v1;
            }

            @Specialization(guards={"builder.state == oldState", "isSame(promotedType.typeInfo, cachedTypeInfo)"}, limit="1")
            static void doCached(SignatureBuilder builder, LibFFIType argType, @CachedLibrary(value="builder") NFIBackendSignatureBuilderLibrary self, @Bind(value="builder.maybePromote(self, argType)") LibFFIType promotedType, @Cached(value="builder.state") ArgsState oldState, @Cached(value="promotedType.typeInfo") LibFFIType.CachedTypeInfo cachedTypeInfo, @Cached(value="oldState.addArg(cachedTypeInfo)") ArgsState newState) {
                assert (builder.state == oldState && promotedType.typeInfo == cachedTypeInfo);
                builder.addArg(promotedType, newState);
            }

            @Specialization(replaces={"doCached"})
            static void doGeneric(SignatureBuilder builder, LibFFIType argType, @CachedLibrary(value="builder") NFIBackendSignatureBuilderLibrary self) {
                LibFFIType promotedType = builder.maybePromote((Node)self, argType);
                ArgsState newState = builder.state.addArg(promotedType.typeInfo);
                builder.addArg(promotedType, newState);
            }
        }

        @ExportMessage
        static class SetReturnType {
            SetReturnType() {
            }

            @Specialization
            static void doSet(SignatureBuilder builder, LibFFIType retType) {
                builder.retType = retType;
                builder.retTypeInfo = retType.typeInfo;
            }
        }
    }

    static final class CachedSignatureInfo {
        final LibFFIType.CachedTypeInfo retType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final LibFFIType.CachedTypeInfo[] argTypes;
        final int primitiveSize;
        final int objectCount;
        final LibFFIType.Direction allowedCallDirection;
        final CallTarget callTarget;
        LibFFIClosure.PolymorphicClosureInfo cachedClosureInfo;

        CachedSignatureInfo(LibFFILanguage language, LibFFIType.CachedTypeInfo retType, LibFFIType.CachedTypeInfo[] argTypes, int primitiveSize, int objectCount, LibFFIType.Direction allowedCallDirection) {
            this.retType = retType;
            this.argTypes = argTypes;
            this.primitiveSize = primitiveSize;
            this.objectCount = objectCount;
            this.allowedCallDirection = allowedCallDirection;
            this.callTarget = new FunctionExecuteNode.SignatureExecuteNode(language, this).getCallTarget();
        }

        NativeArgumentBuffer.Array prepareBuffer() {
            return new NativeArgumentBuffer.Array(this.primitiveSize, this.objectCount);
        }

        LibFFIType.CachedTypeInfo[] getArgTypes() {
            return this.argTypes;
        }

        LibFFIType.CachedTypeInfo getRetType() {
            return this.retType;
        }

        LibFFIType.Direction getAllowedCallDirection() {
            return this.allowedCallDirection;
        }

        Object execute(Node node, LibFFISignature signature, LibFFIContext ctx, long functionPointer, NativeArgumentBuffer.Array argBuffer) {
            assert (signature.signatureInfo == this);
            LibFFIType.CachedTypeInfo localRetType = this.retType;
            CompilerAsserts.partialEvaluationConstant((Object)localRetType);
            if (localRetType == null) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            if (localRetType instanceof LibFFIType.ObjectType) {
                Object ret = ctx.executeObject(signature.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects);
                if (ret == null) {
                    return NativePointer.NULL;
                }
                return ret;
            }
            if (localRetType instanceof LibFFIType.SimpleType) {
                LibFFIType.SimpleType simpleType = (LibFFIType.SimpleType)localRetType;
                long ret = ctx.executePrimitive(signature.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects);
                return simpleType.fromPrimitive(ret);
            }
            NativeArgumentBuffer.Array retBuffer = new NativeArgumentBuffer.Array(localRetType.size, localRetType.objectCount);
            ctx.executeNative(signature.cif, functionPointer, argBuffer.prim, argBuffer.getPatchCount(), argBuffer.patches, argBuffer.objects, retBuffer.prim);
            return localRetType.deserializeRet(node, retBuffer);
        }

        @CompilerDirectives.TruffleBoundary
        private synchronized void initCachedClosureInfo() {
            if (this.cachedClosureInfo == null) {
                this.cachedClosureInfo = LibFFIClosure.PolymorphicClosureInfo.create(this);
            }
        }

        @NeverDefault
        LibFFIClosure.PolymorphicClosureInfo getCachedClosureInfo() {
            if (this.cachedClosureInfo == null) {
                this.initCachedClosureInfo();
            }
            assert (this.cachedClosureInfo != null);
            return this.cachedClosureInfo;
        }
    }

    static final class ArgsState {
        static final ArgsState NO_ARGS = new ArgsState(0, 0, 0, true, true, null, null);
        final int argCount;
        final int primitiveSize;
        final int objectCount;
        final boolean allowJavaToNativeCall;
        final boolean allowNativeToJavaCall;
        final LibFFIType.CachedTypeInfo lastArg;
        final ArgsState prev;

        ArgsState(int argCount, int primitiveSize, int objectCount, boolean allowJavaToNativeCall, boolean allowNativeToJavaCall, LibFFIType.CachedTypeInfo lastArg, ArgsState prev) {
            this.argCount = argCount;
            this.primitiveSize = primitiveSize;
            this.objectCount = objectCount;
            this.allowJavaToNativeCall = allowJavaToNativeCall;
            this.allowNativeToJavaCall = allowNativeToJavaCall;
            this.lastArg = lastArg;
            this.prev = prev;
        }

        @NeverDefault
        ArgsState addArg(LibFFIType.CachedTypeInfo typeInfo) {
            if (typeInfo instanceof LibFFIType.VoidType) {
                throw new IllegalArgumentException("void is not a valid argument type");
            }
            boolean newAllowNativeToJavaCall = this.allowNativeToJavaCall;
            boolean newAllowJavaToNativeCall = this.allowJavaToNativeCall;
            switch (typeInfo.allowedDataFlowDirection) {
                case JAVA_TO_NATIVE_ONLY: {
                    newAllowNativeToJavaCall = false;
                    break;
                }
                case NATIVE_TO_JAVA_ONLY: {
                    newAllowJavaToNativeCall = false;
                }
            }
            int align = typeInfo.alignment;
            int newPrimitiveSize = this.primitiveSize;
            if (this.primitiveSize % align != 0) {
                newPrimitiveSize += align - this.primitiveSize % align;
            }
            int newObjectCount = this.objectCount + typeInfo.objectCount;
            return new ArgsState(this.argCount + 1, newPrimitiveSize += typeInfo.size, newObjectCount, newAllowJavaToNativeCall, newAllowNativeToJavaCall, typeInfo, this);
        }
    }

    @ExportMessage
    @ImportStatic(value={LibFFILanguage.class})
    static class CreateClosure {
        CreateClosure() {
        }

        @Specialization(guards={"signature.signatureInfo == cachedSignatureInfo", "executable == cachedExecutable"}, assumptions={"getSingleContextAssumption()"}, limit="3")
        static LibFFIClosure doCachedExecutable(LibFFISignature signature, Object executable, @Cached(value="signature.signatureInfo") CachedSignatureInfo cachedSignatureInfo, @Cached(value="executable") Object cachedExecutable, @CachedLibrary(value="signature") NFIBackendSignatureLibrary self, @Cached(value="create(cachedSignatureInfo, cachedExecutable)") LibFFIClosure.MonomorphicClosureInfo cachedClosureInfo) {
            assert (signature.signatureInfo == cachedSignatureInfo && executable == cachedExecutable);
            ClosureNativePointer nativePointer = cachedClosureInfo.allocateClosure(LibFFIContext.get((Node)self), signature);
            return LibFFIClosure.newClosureWrapper(nativePointer);
        }

        @Specialization(replaces={"doCachedExecutable"}, guards={"signature.signatureInfo == cachedSignatureInfo"}, limit="3")
        static LibFFIClosure doCachedSignature(LibFFISignature signature, Object executable, @Cached(value="signature.signatureInfo") CachedSignatureInfo cachedSignatureInfo, @CachedLibrary(value="signature") NFIBackendSignatureLibrary self, @Cached(value="create(cachedSignatureInfo)") LibFFIClosure.PolymorphicClosureInfo cachedClosureInfo) {
            assert (signature.signatureInfo == cachedSignatureInfo);
            ClosureNativePointer nativePointer = cachedClosureInfo.allocateClosure(LibFFIContext.get((Node)self), signature, executable);
            return LibFFIClosure.newClosureWrapper(nativePointer);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCachedSignature"})
        static LibFFIClosure createClosure(LibFFISignature signature, Object executable, @CachedLibrary(value="signature") NFIBackendSignatureLibrary self) {
            LibFFIClosure.PolymorphicClosureInfo cachedClosureInfo = signature.signatureInfo.getCachedClosureInfo();
            ClosureNativePointer nativePointer = cachedClosureInfo.allocateClosure(LibFFIContext.get((Node)self), signature, executable);
            return LibFFIClosure.newClosureWrapper(nativePointer);
        }
    }

    @ExportMessage
    static class Call {
        Call() {
        }

        @Specialization
        static Object callLibFFI(LibFFISignature self, LibFFISymbol functionPointer, Object[] args, @Bind(value="$node") Node node, @Cached.Exclusive @Cached FunctionExecuteNode functionExecute) throws ArityException, UnsupportedTypeException {
            long pointer = functionPointer.asPointer();
            return functionExecute.execute(node, pointer, self, args);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        static Object callGeneric(LibFFISignature self, Object functionPointer, Object[] args, @CachedLibrary(value="functionPointer") InteropLibrary interop, @Bind(value="$node") Node node, @Cached InlinedBranchProfile isExecutable, @Cached InlinedBranchProfile toNative, @Cached InlinedBranchProfile error, @Cached.Exclusive @Cached FunctionExecuteNode functionExecute) throws ArityException, UnsupportedTypeException {
            long pointer;
            if (interop.isExecutable(functionPointer)) {
                try {
                    isExecutable.enter(node);
                    return interop.execute(functionPointer, args);
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw UnsupportedTypeException.create((Object[])new Object[]{functionPointer}, (String)"functionPointer", (Throwable)e);
                }
            }
            if (!interop.isPointer(functionPointer)) {
                toNative.enter(node);
                interop.toNative(functionPointer);
            }
            try {
                pointer = interop.asPointer(functionPointer);
            }
            catch (UnsupportedMessageException e) {
                error.enter(node);
                throw UnsupportedTypeException.create((Object[])new Object[]{functionPointer}, (String)"functionPointer", (Throwable)e);
            }
            return functionExecute.execute(node, pointer, self, args);
        }
    }
}

