/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.libffi;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.nfi.backend.libffi.ClosureArgumentNode;
import com.oracle.truffle.nfi.backend.libffi.ClosureArgumentNodeFactory;
import com.oracle.truffle.nfi.backend.libffi.LibFFIContext;
import com.oracle.truffle.nfi.backend.libffi.NativeArgumentBuffer;
import com.oracle.truffle.nfi.backend.libffi.NativePointer;
import com.oracle.truffle.nfi.backend.libffi.NativeString;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentNode;
import com.oracle.truffle.nfi.backend.libffi.SerializeArgumentNodeFactory;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import java.nio.ByteOrder;

final class LibFFIType {
    protected final long type;
    @NeverDefault
    protected final CachedTypeInfo typeInfo;

    static CachedTypeInfo createSimpleTypeInfo(NativeSimpleType simpleType, int size, int alignment) {
        switch (simpleType) {
            case VOID: {
                return new VoidType(size, alignment);
            }
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case FLOAT: 
            case DOUBLE: {
                return new SimpleType(simpleType, size, alignment);
            }
            case FP80: {
                return new FP80Type(size, alignment);
            }
            case FP128: {
                return new FP128Type(size, alignment);
            }
            case POINTER: {
                return new PointerType(size, alignment);
            }
            case STRING: {
                return new StringType(size, alignment);
            }
            case OBJECT: {
                return new ObjectType(size, alignment);
            }
            case NULLABLE: {
                return new NullableType(size, alignment);
            }
        }
        throw new AssertionError((Object)simpleType.name());
    }

    static CachedTypeInfo createVarargsPromotedTypeInfo(NativeSimpleType simpleType, CachedTypeInfo promotedType) {
        return new SimpleType(simpleType, (SimpleType)promotedType);
    }

    static CachedTypeInfo createArrayTypeInfo(CachedTypeInfo ptrType, NativeSimpleType simpleType) {
        switch (simpleType) {
            case UINT8: 
            case SINT8: 
            case UINT16: 
            case SINT16: 
            case UINT32: 
            case SINT32: 
            case UINT64: 
            case SINT64: 
            case FLOAT: 
            case DOUBLE: {
                return new ArrayType(ptrType, simpleType);
            }
        }
        return null;
    }

    protected LibFFIType(CachedTypeInfo typeInfo, long type) {
        assert (typeInfo != null);
        this.typeInfo = typeInfo;
        this.type = type;
    }

    LibFFIType varargsPromoteType(Node node) {
        if (this.typeInfo instanceof SimpleType) {
            NativeSimpleType simpleType = ((SimpleType)this.typeInfo).simpleType;
            switch (simpleType) {
                case UINT8: 
                case SINT8: 
                case UINT16: 
                case SINT16: 
                case FLOAT: {
                    return LibFFIContext.get(node).lookupVarargsType(simpleType);
                }
            }
        }
        return this;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeInfo.toString();
    }

    static final class VoidType
    extends BasicType {
        private VoidType(int size, int alignment) {
            super(NativeSimpleType.VOID, size, alignment, 0);
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            throw new AssertionError((Object)"invalid argument type VOID");
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            throw new AssertionError((Object)"invalid argument type VOID");
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            return NativePointer.NULL;
        }
    }

    static final class SimpleType
    extends BasicType {
        private final SerializeArgumentNode sharedArgumentNode;

        SimpleType(NativeSimpleType simpleType, int size, int alignment) {
            super(simpleType, size, alignment, 0);
            this.sharedArgumentNode = this.createSharedArgumentNode();
            assert (!this.sharedArgumentNode.isAdoptable());
        }

        SimpleType(NativeSimpleType simpleType, SimpleType promotedType) {
            super(simpleType, promotedType.size, promotedType.alignment, 0);
            this.sharedArgumentNode = promotedType.createVarargsArgumentNode(simpleType);
            assert (!this.sharedArgumentNode.isAdoptable());
        }

        public Object fromPrimitive(long primitive) {
            switch (this.simpleType) {
                case VOID: {
                    return NativePointer.NULL;
                }
                case UINT8: 
                case SINT8: {
                    return (byte)primitive;
                }
                case UINT16: 
                case SINT16: {
                    return (short)primitive;
                }
                case UINT32: 
                case SINT32: {
                    return (int)primitive;
                }
                case UINT64: 
                case SINT64: {
                    return primitive;
                }
                case FLOAT: {
                    int ret = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (int)(primitive >>> 32) : (int)primitive;
                    return Float.valueOf(Float.intBitsToFloat(ret));
                }
                case DOUBLE: {
                    return Double.longBitsToDouble(primitive);
                }
                case POINTER: {
                    return NativePointer.create(primitive);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)this.simpleType.name());
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return this.sharedArgumentNode;
        }

        private SerializeArgumentNode createSharedArgumentNode() {
            switch (this.simpleType) {
                case UINT8: 
                case SINT8: {
                    return new SerializeArgumentNode.SerializeInt8Node(this);
                }
                case UINT16: 
                case SINT16: {
                    return new SerializeArgumentNode.SerializeInt16Node(this);
                }
                case UINT32: 
                case SINT32: {
                    return new SerializeArgumentNode.SerializeInt32Node(this);
                }
                case UINT64: 
                case SINT64: {
                    return new SerializeArgumentNode.SerializeInt64Node(this);
                }
                case FLOAT: {
                    return new SerializeArgumentNode.SerializeFloatNode(this);
                }
                case DOUBLE: {
                    return new SerializeArgumentNode.SerializeDoubleNode(this);
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)this.simpleType.name());
        }

        private SerializeArgumentNode createVarargsArgumentNode(NativeSimpleType originalType) {
            switch (originalType) {
                case SINT8: {
                    return new SerializeArgumentNode.SerializeInt8VarargsNode(this);
                }
                case UINT8: {
                    return new SerializeArgumentNode.SerializeUInt8VarargsNode(this);
                }
                case SINT16: {
                    return new SerializeArgumentNode.SerializeInt16VarargsNode(this);
                }
                case UINT16: {
                    return new SerializeArgumentNode.SerializeUInt16VarargsNode(this);
                }
                case FLOAT: {
                    return new SerializeArgumentNode.SerializeFloatVarargsNode(this);
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)this.simpleType.name());
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.BufferClosureArgumentNodeGen.create(this, arg);
        }
    }

    static final class FP80Type
    extends BasicType {
        private FP80Type(int size, int alignment) {
            super(NativeSimpleType.FP80, size, alignment, 0);
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return SerializeArgumentNodeFactory.SerializeSerializableNodeGen.create(this);
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.BufferClosureArgumentNodeGen.create(this, arg);
        }
    }

    static final class FP128Type
    extends BasicType {
        private FP128Type(int size, int alignment) {
            super(NativeSimpleType.FP128, size, alignment, 0);
        }

        @Override
        public SerializeArgumentNode createSerializeArgumentNode() {
            return SerializeArgumentNodeFactory.SerializeSerializableNodeGen.create(this);
        }

        @Override
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.BufferClosureArgumentNodeGen.create(this, arg);
        }
    }

    static final class PointerType
    extends BasicType {
        private PointerType(int size, int alignment) {
            super(NativeSimpleType.POINTER, size, alignment, 1);
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return SerializeArgumentNodeFactory.SerializePointerNodeGen.create(this);
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.BufferClosureArgumentNodeGen.create(this, arg);
        }
    }

    static final class StringType
    extends BasicType {
        private StringType(int size, int alignment) {
            super(NativeSimpleType.STRING, size, alignment, 1);
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return SerializeArgumentNodeFactory.SerializeStringNodeGen.create(this);
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.StringClosureArgumentNodeGen.create(arg);
        }
    }

    static final class ObjectType
    extends BasicType {
        private final SerializeArgumentNode sharedArgumentNode = new SerializeArgumentNode.SerializeObjectNode(this);

        ObjectType(int size, int alignment) {
            super(NativeSimpleType.OBJECT, size, alignment, 1);
            assert (!this.sharedArgumentNode.isAdoptable());
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return this.sharedArgumentNode;
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.ObjectClosureArgumentNodeGen.create(arg);
        }
    }

    static final class NullableType
    extends BasicType {
        NullableType(int size, int alignment) {
            super(NativeSimpleType.NULLABLE, size, alignment, 1, Direction.JAVA_TO_NATIVE_ONLY);
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return SerializeArgumentNodeFactory.SerializeNullableNodeGen.create(this);
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return ClosureArgumentNodeFactory.ObjectClosureArgumentNodeGen.create(arg);
        }
    }

    static final class ArrayType
    extends BasePointerType {
        final NativeSimpleType elementType;

        ArrayType(CachedTypeInfo pointerType, NativeSimpleType elementType) {
            super(pointerType, Direction.JAVA_TO_NATIVE_ONLY, false);
            switch (elementType) {
                case UINT8: 
                case SINT8: 
                case UINT16: 
                case SINT16: 
                case UINT32: 
                case SINT32: 
                case UINT64: 
                case SINT64: 
                case FLOAT: 
                case DOUBLE: {
                    this.elementType = elementType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("only primitive array types are supported, got [%s]", elementType));
                }
            }
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return SerializeArgumentNodeFactory.SerializeArrayNodeGen.create(this);
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"Arrays can only be passed from Java to native");
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            throw new AssertionError((Object)"Arrays can only be passed from Java to native");
        }

        public String toString() {
            return "[" + this.elementType.toString() + "]";
        }
    }

    static abstract class CachedTypeInfo {
        protected final int size;
        protected final int alignment;
        protected final int objectCount;
        protected final Direction allowedDataFlowDirection;
        protected final boolean injectedArgument;

        protected CachedTypeInfo(int size, int alignment, int objectCount, Direction direction, boolean injectedArgument) {
            this.size = size;
            this.alignment = alignment;
            this.objectCount = objectCount;
            this.allowedDataFlowDirection = direction;
            this.injectedArgument = injectedArgument;
        }

        @NeverDefault
        public abstract SerializeArgumentNode createSerializeArgumentNode();

        @NeverDefault
        public abstract ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode var1);

        public abstract Object deserializeRet(Node var1, NativeArgumentBuffer var2);

        public CachedTypeInfo overrideClosureRetType() {
            return this;
        }
    }

    static final class EnvType
    extends BasePointerType {
        private final SerializeArgumentNode sharedArgumentNode = new SerializeArgumentNode.SerializeEnvNode(this);

        EnvType(CachedTypeInfo pointerType) {
            super(pointerType, Direction.BOTH, true);
        }

        @Override
        @NeverDefault
        public SerializeArgumentNode createSerializeArgumentNode() {
            return this.sharedArgumentNode;
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"environment pointer can not be used as return type");
        }

        @Override
        @NeverDefault
        public ClosureArgumentNode createClosureArgumentNode(ClosureArgumentNode arg) {
            return new ClosureArgumentNode.InjectedClosureArgumentNode();
        }

        public String toString() {
            return "ENV";
        }
    }

    static abstract class BasePointerType
    extends CachedTypeInfo {
        protected BasePointerType(CachedTypeInfo pointerType, Direction direction, boolean injectedArgument) {
            super(pointerType.size, pointerType.alignment, 1, direction, injectedArgument);
        }
    }

    static abstract class BasicType
    extends CachedTypeInfo {
        final NativeSimpleType simpleType;

        BasicType(NativeSimpleType simpleType, int size, int alignment, int objectCount, Direction direction) {
            super(size, alignment, objectCount, direction, false);
            this.simpleType = simpleType;
        }

        BasicType(NativeSimpleType simpleType, int size, int alignment, int objectCount) {
            this(simpleType, size, alignment, objectCount, Direction.BOTH);
        }

        @Override
        public Object deserializeRet(Node node, NativeArgumentBuffer buffer) {
            buffer.align(this.alignment);
            switch (this.simpleType) {
                case VOID: {
                    return null;
                }
                case UINT8: 
                case SINT8: {
                    return buffer.getInt8();
                }
                case UINT16: 
                case SINT16: {
                    return buffer.getInt16();
                }
                case UINT32: 
                case SINT32: {
                    return buffer.getInt32();
                }
                case UINT64: 
                case SINT64: {
                    return buffer.getInt64();
                }
                case FLOAT: {
                    return Float.valueOf(buffer.getFloat());
                }
                case DOUBLE: {
                    return buffer.getDouble();
                }
                case FP80: {
                    return buffer.get(this.size);
                }
                case FP128: {
                    return buffer.get(this.size);
                }
                case POINTER: {
                    return NativePointer.create(buffer.getPointer(this.size));
                }
                case STRING: {
                    return new NativeString(buffer.getPointer(this.size));
                }
                case OBJECT: 
                case NULLABLE: {
                    Object ret = buffer.getObject(this.size);
                    if (ret == null) {
                        return NativePointer.create(0L);
                    }
                    return ret;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)this.simpleType.name());
        }

        public String toString() {
            return this.simpleType.toString();
        }
    }

    static enum Direction {
        JAVA_TO_NATIVE_ONLY,
        NATIVE_TO_JAVA_ONLY,
        BOTH;


        Direction reverse() {
            switch (this) {
                case JAVA_TO_NATIVE_ONLY: {
                    return NATIVE_TO_JAVA_ONLY;
                }
                case NATIVE_TO_JAVA_ONLY: {
                    return JAVA_TO_NATIVE_ONLY;
                }
                case BOTH: {
                    return BOTH;
                }
            }
            return null;
        }
    }
}

