/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi;

import com.oracle.truffle.nfi.spi.types.NativeLibraryDescriptor;
import java.util.ArrayList;
import java.util.List;

final class NativeSource {
    private final String nfiId;
    private final NativeLibraryDescriptor libraryDescriptor;
    private final List<String> preBoundSymbols;
    private final List<String> preBoundSignatures;

    NativeSource(String nfiId, NativeLibraryDescriptor libraryDescriptor) {
        this.nfiId = nfiId;
        this.libraryDescriptor = libraryDescriptor;
        this.preBoundSymbols = new ArrayList<String>();
        this.preBoundSignatures = new ArrayList<String>();
    }

    public boolean isDefaultBackend() {
        return this.nfiId == null;
    }

    public String getNFIBackendId() {
        return this.nfiId;
    }

    public NativeLibraryDescriptor getLibraryDescriptor() {
        return this.libraryDescriptor;
    }

    public int preBoundSymbolsLength() {
        return this.preBoundSymbols.size();
    }

    public String getPreBoundSymbol(int i) {
        return this.preBoundSymbols.get(i);
    }

    public String getPreBoundSignature(int i) {
        return this.preBoundSignatures.get(i);
    }

    void register(String symbol, String signature) {
        this.preBoundSymbols.add(symbol);
        this.preBoundSignatures.add(signature);
    }
}

