/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.gelfclient;

import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.transport.AbstractGelfTransport;
import org.graylog2.gelfclient.transport.GelfTcpTransport;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.graylog2.gelfclient.transport.GelfUdpTransport;

public enum GelfTransports {
    TCP,
    UDP;


    public static GelfTransport create(GelfTransports transport, GelfConfiguration config) {
        AbstractGelfTransport gelfTransport;
        switch (transport) {
            case TCP: {
                gelfTransport = new GelfTcpTransport(config);
                break;
            }
            case UDP: {
                gelfTransport = new GelfUdpTransport(config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported GELF transport: " + (Object)((Object)transport));
            }
        }
        return gelfTransport;
    }

    public static GelfTransport create(GelfConfiguration config) {
        return GelfTransports.create(config.getTransport(), config);
    }
}

