/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.cfg.spi.IdUniquenessResolver;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.impl.ErrorContextBuilder;
import org.hibernate.search.indexes.impl.PropertiesParseHelper;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractWorkspaceImpl
implements Workspace {
    private static final Log log = LoggerFactory.make();
    private final OptimizerStrategy optimizerStrategy;
    private final DirectoryBasedIndexManager indexManager;
    private final ServiceManager serviceManager;
    protected final IndexWriterHolder writerHolder;
    private final boolean deleteByTermEnforced;
    private boolean indexMetadataIsComplete;
    private final AtomicLong operations = new AtomicLong(0L);

    public AbstractWorkspaceImpl(DirectoryBasedIndexManager indexManager, WorkerBuildContext context, Properties cfg) {
        this.indexManager = indexManager;
        this.optimizerStrategy = indexManager.getOptimizerStrategy();
        this.writerHolder = new IndexWriterHolder(context.getErrorHandler(), indexManager);
        this.indexMetadataIsComplete = PropertiesParseHelper.isIndexMetadataComplete(cfg, context);
        this.deleteByTermEnforced = context.isDeleteByTermEnforced();
        this.serviceManager = context.getServiceManager();
    }

    @Override
    public DocumentBuilderIndexedEntity getDocumentBuilder(IndexedTypeIdentifier type) {
        return this.indexManager.getIndexBinding(type).getDocumentBuilder();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.indexManager.getAnalyzer(name);
    }

    @Override
    public void optimizerPhase() {
        this.optimizerStrategy.addOperationWithinTransactionCount(this.operations.getAndSet(0L));
        this.optimizerStrategy.optimize(this);
    }

    @Override
    public void performOptimization(IndexWriter writer) {
        this.optimizerStrategy.performOptimization(writer);
    }

    protected void incrementModificationCounter() {
        this.operations.addAndGet(1L);
    }

    @Override
    public IndexedTypeSet getEntitiesInIndexManager() {
        return this.indexManager.getContainedTypes();
    }

    @Override
    public void afterTransactionApplied(boolean someFailureHappened, boolean streaming) {
        this.getCommitPolicy().onChangeSetApplied(someFailureHappened, streaming);
    }

    public void shutDownNow() {
        this.getCommitPolicy().onClose();
        log.shuttingDownBackend(this.indexManager.getIndexName());
        this.closeIndexWriter();
    }

    public void closeIndexWriter() {
        log.closingIndexWriter(this.indexManager.getIndexName());
        this.writerHolder.closeIndexWriter();
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.writerHolder.getIndexWriter();
    }

    public IndexWriter getIndexWriter(ErrorContextBuilder errorContextBuilder) {
        return this.writerHolder.getIndexWriter(errorContextBuilder);
    }

    @Override
    public boolean areSingleTermDeletesSafe() {
        return this.indexMetadataIsComplete && this.getEntitiesInIndexManager().size() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeleteByTermEnforced() {
        if (this.deleteByTermEnforced) {
            return true;
        }
        if (this.indexMetadataIsComplete) {
            IndexedTypeSet entitiesInvolved = this.getEntitiesInIndexManager();
            if (entitiesInvolved.size() == 1) {
                return true;
            }
            IdUniquenessResolver idUniquenessResolver = this.serviceManager.requestService(IdUniquenessResolver.class);
            try {
                for (IndexedTypeIdentifier firstEntity : entitiesInvolved) {
                    boolean firstEntityIsUsingJPAId = this.indexManager.getIndexBinding(firstEntity).getDocumentBuilder().getTypeMetadata().isJpaIdUsedAsDocumentId();
                    boolean followingEntities = false;
                    for (IndexedTypeIdentifier secondEntity : entitiesInvolved) {
                        boolean uniqueIdEqualityMeansEntityEquality;
                        if (firstEntity.equals(secondEntity)) {
                            followingEntities = true;
                            continue;
                        }
                        if (!followingEntities) continue;
                        boolean secondEntityIsUsingJPAId = this.indexManager.getIndexBinding(secondEntity).getDocumentBuilder().getTypeMetadata().isJpaIdUsedAsDocumentId();
                        boolean bl = uniqueIdEqualityMeansEntityEquality = firstEntityIsUsingJPAId && secondEntityIsUsingJPAId && idUniquenessResolver.areIdsUniqueForClasses(firstEntity, secondEntity);
                        if (uniqueIdEqualityMeansEntityEquality) continue;
                        boolean bl2 = false;
                        return bl2;
                    }
                }
            }
            finally {
                this.serviceManager.releaseService(IdUniquenessResolver.class);
            }
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        this.getCommitPolicy().onFlush();
    }

    @Override
    public String getIndexName() {
        return this.indexManager.getIndexName();
    }

    public IndexWriterDelegate getIndexWriterDelegate(ErrorContextBuilder errorContextBuilder) {
        IndexWriter indexWriter = this.getIndexWriter(errorContextBuilder);
        if (indexWriter != null) {
            return new IndexWriterDelegate(indexWriter);
        }
        return null;
    }

    public IndexWriterDelegate getIndexWriterDelegate() {
        IndexWriter indexWriter = this.getIndexWriter();
        if (indexWriter != null) {
            return new IndexWriterDelegate(indexWriter);
        }
        return null;
    }
}

