/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import java.io.InputStream;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.ReaderOperator;
import org.hswebframework.reactor.excel.WriterOperator;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.hswebframework.reactor.excel.spi.ExcelReader;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class ReactorExcel {
    private static final Logger log = LoggerFactory.getLogger(ReactorExcel.class);
    private static Map<String, ExcelReader> readers = new ConcurrentHashMap<String, ExcelReader>();
    private static Map<String, ExcelWriter> writers = new ConcurrentHashMap<String, ExcelWriter>();

    public static ExcelReader lookupReader(String format) {
        ExcelReader reader = readers.get(format);
        if (reader == null) {
            throw new UnsupportedOperationException("unsupported format:" + format);
        }
        return reader;
    }

    public static ExcelWriter lookupWriter(String format) {
        ExcelWriter writer = writers.get(format);
        if (writer == null) {
            throw new UnsupportedOperationException("unsupported format:" + format);
        }
        return writer;
    }

    public static <T> Flux<T> read(InputStream input, String format, RowWrapper<T> wrapper) {
        return ReactorExcel.lookupReader(format).read(input, new ExcelOption[0]).flatMap(wrapper);
    }

    public static ReaderOperator<Map<String, Object>> mapReader(String format) {
        return ReaderOperator.ofMap(ReactorExcel.lookupReader(format));
    }

    public static <T> ReaderOperator<T> reader(Class<T> type, String format) {
        return ReaderOperator.of(ReactorExcel.lookupReader(format), type);
    }

    public static <T> WriterOperator<T> writer(String format) {
        return WriterOperator.of(ReactorExcel.lookupWriter(format));
    }

    static {
        try {
            ServiceLoader.load(ExcelReader.class).forEach(reader -> {
                for (String excelFormat : reader.getSupportFormat()) {
                    readers.put(excelFormat, (ExcelReader)reader);
                }
            });
            ServiceLoader.load(ExcelWriter.class).forEach(reader -> {
                for (String excelFormat : reader.getSupportFormat()) {
                    writers.put(excelFormat, (ExcelWriter)reader);
                }
            });
        }
        catch (Exception e) {
            log.error("load excel reader error", (Throwable)e);
        }
    }
}

