/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.beanutils.BeanMap;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.reactor.excel.ExcelOption;
import org.hswebframework.reactor.excel.WritableCell;
import org.hswebframework.reactor.excel.converter.HeaderCell;
import org.hswebframework.reactor.excel.converter.MapRowExpander;
import org.hswebframework.reactor.excel.spi.ExcelWriter;
import org.hswebframework.reactor.excel.utils.StreamUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WriterOperator<T> {
    ExcelWriter writer;
    private List<ExcelOption> options = new ArrayList<ExcelOption>();
    static Function<Object, Map<String, Object>> defaultConverter = v -> new BeanMap(v);
    private Function<T, Map<String, Object>> mapConverter = v -> defaultConverter.apply(v);
    private MapRowExpander expander = new MapRowExpander();

    WriterOperator(ExcelWriter writer) {
        this.writer = writer;
    }

    public WriterOperator<T> header(String key, String header, CellDataType type) {
        this.expander.header(key, header, type);
        return this;
    }

    public WriterOperator<T> converter(Function<T, Map<String, Object>> mapConverter) {
        this.mapConverter = mapConverter;
        return this;
    }

    public WriterOperator<T> header(String key, String header) {
        this.expander.header(key, header);
        return this;
    }

    public WriterOperator<T> header(ExcelHeader header) {
        this.expander.header(header);
        return this;
    }

    public WriterOperator<T> headers(Collection<ExcelHeader> headers) {
        this.expander.headers(headers);
        return this;
    }

    public WriterOperator<T> headers(Class<?> typeSpec) {
        return this;
    }

    public WriterOperator<T> options(ExcelOption ... option) {
        this.options.addAll(Arrays.asList(option));
        return this;
    }

    public WriterOperator<T> option(ExcelOption option) {
        this.options.add(option);
        return this;
    }

    protected Map<String, Object> toMap(T val) {
        if (val instanceof Map) {
            return (Map)val;
        }
        if (this.mapConverter != null) {
            return this.mapConverter.apply(val);
        }
        throw new UnsupportedOperationException("can not convert " + val + " to map");
    }

    public Flux<byte[]> writeBuffer(Flux<T> dataStream) {
        return this.writeBuffer(dataStream, 10240);
    }

    public Flux<byte[]> writeBuffer(Flux<T> dataStream, int buffer) {
        return StreamUtils.buffer(buffer, output -> this.write(dataStream, (OutputStream)output));
    }

    public Mono<Void> write(Flux<T> dataStream, OutputStream output) {
        return (Mono)Flux.concat((Publisher[])new Publisher[]{Flux.fromIterable(this.expander.getHeaders()).index((index, header) -> new HeaderCell((ExcelHeader)header, index.intValue(), index == (long)(this.expander.getHeaders().size() - 1))), dataStream.index().flatMap(idx -> this.expander.apply((Long)idx.getT1() + 1L, this.toMap(idx.getT2())))}).as(flux -> this.writer.write((Flux<WritableCell>)flux, output, this.options.toArray(new ExcelOption[0])));
    }

    public static <T> WriterOperator<T> of(ExcelWriter writer) {
        return new WriterOperator<T>(writer);
    }
}

