/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.reactor.excel.Cell;
import reactor.core.publisher.Mono;

public abstract class RowWrapper<T>
implements Function<Cell, Mono<T>> {
    protected T current;
    protected int headerIndex;
    protected volatile long currentRow;
    protected Map<Integer, Cell> headerMapping = new HashMap<Integer, Cell>();

    protected abstract T newInstance();

    protected abstract T wrap(T var1, Cell var2, Cell var3);

    @Override
    public Mono<T> apply(Cell cell) {
        if (cell.getRowIndex() == (long)this.getHeaderIndex()) {
            this.headerMapping.put(cell.getColumnIndex(), cell);
            return Mono.empty();
        }
        if (this.headerMapping.isEmpty()) {
            return Mono.empty();
        }
        if (this.current == null) {
            this.current = this.newInstance();
        }
        this.currentRow = cell.getRowIndex();
        Cell header = this.headerMapping.get(cell.getColumnIndex());
        if (header != null) {
            this.current = this.wrap(this.current, header, cell);
        }
        if (cell.isEnd()) {
            Mono result = Mono.justOrEmpty(this.current);
            this.current = this.newInstance();
            return result;
        }
        return Mono.empty();
    }

    public int getHeaderIndex() {
        return this.headerIndex;
    }

    public void setHeaderIndex(int headerIndex) {
        this.headerIndex = headerIndex;
    }
}

