/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.reactor.excel.poi;

import java.math.BigDecimal;
import java.util.Optional;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.CellDataType;

public class PoiCell
implements Cell {
    private int sheetIndex;
    private org.apache.poi.ss.usermodel.Cell cell;
    private boolean end;
    private Object value;

    public PoiCell(int sheetIndex, org.apache.poi.ss.usermodel.Cell cell, boolean end) {
        this.sheetIndex = sheetIndex;
        this.cell = cell;
        this.end = end;
        this.value = this.convertValue();
    }

    private Object convertValue() {
        if (this.cell == null) {
            return null;
        }
        switch (this.cell.getCellType()) {
            case BOOLEAN: {
                return this.cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (this.isCellDateFormatted()) {
                    return this.cell.getDateCellValue();
                }
                BigDecimal value = new BigDecimal(this.cell.getNumericCellValue());
                return value.scale() == 0 ? Long.valueOf(value.longValue()) : value;
            }
            case STRING: {
                return this.cell.getRichStringCellValue().getString();
            }
            case FORMULA: {
                FormulaEvaluator evaluator = this.cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(this.cell);
                switch (cellValue.getCellType()) {
                    case BOOLEAN: {
                        return this.cell.getBooleanCellValue();
                    }
                    case NUMERIC: {
                        if (this.isCellDateFormatted()) {
                            return this.cell.getDateCellValue();
                        }
                        BigDecimal value = new BigDecimal(this.cell.getNumericCellValue());
                        return value.scale() == 0 ? Long.valueOf(value.longValue()) : value;
                    }
                    case BLANK: {
                        return "";
                    }
                }
                return cellValue.getStringValue();
            }
        }
        return this.cell.getStringCellValue();
    }

    public boolean isCellDateFormatted() {
        if (this.cell == null) {
            return false;
        }
        boolean bDate = false;
        double d = this.cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate((double)d)) {
            CellStyle style = this.cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short i = style.getDataFormat();
            if (i == 58 || i == 31) {
                return true;
            }
            String f = style.getDataFormatString();
            f = f.replaceAll("[\"|']", "").replaceAll("[\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2|\u6beb\u79d2|\u5fae\u79d2]", "");
            bDate = DateUtil.isADateFormat((int)i, (String)f);
        }
        return bDate;
    }

    @Override
    public int getSheetIndex() {
        return this.sheetIndex;
    }

    @Override
    public long getRowIndex() {
        return this.cell.getRowIndex();
    }

    @Override
    public int getColumnIndex() {
        return this.cell.getColumnIndex();
    }

    @Override
    public Optional<Object> value() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public CellDataType getType() {
        switch (this.cell.getCellType()) {
            case NUMERIC: {
                return CellDataType.NUMBER;
            }
            case FORMULA: {
                return CellDataType.FORMULA;
            }
            case BOOLEAN: {
                return CellDataType.BOOLEAN;
            }
        }
        if (this.isCellDateFormatted()) {
            return CellDataType.DATE_TIME;
        }
        return CellDataType.STRING;
    }

    public org.apache.poi.ss.usermodel.Cell getCell() {
        return this.cell;
    }

    @Override
    public boolean isEnd() {
        return this.end;
    }

    public Object getValue() {
        return this.value;
    }

    public PoiCell(int sheetIndex, org.apache.poi.ss.usermodel.Cell cell, boolean end, Object value) {
        this.sheetIndex = sheetIndex;
        this.cell = cell;
        this.end = end;
        this.value = value;
    }
}

