/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class SybaseTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(SybaseTableManager.class, Log.class);

    SybaseTableManager(InitializationContext ctx, ConnectionFactory connectionFactory, JdbcStringBasedStoreConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, log);
    }

    @Override
    protected String getDropTimestampSql(String indexName) {
        return String.format("DROP INDEX %s.%s", this.dataTableName, this.getIndexName(this.dbMetadata.getMaxTableNameLength(), true, indexName));
    }

    @Override
    protected String initUpdateRowSql() {
        return String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = convert(%s,?)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initSelectRowSql() {
        return String.format("SELECT %s, %s FROM %s WHERE %s = convert(%s,?)", this.config.idColumnName(), this.config.dataColumnName(), this.dataTableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initSelectIdRowSql() {
        return String.format("SELECT %s FROM %s WHERE %s = convert(%s,?)", this.config.idColumnName(), this.dataTableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initDeleteRowSql() {
        return String.format("DELETE FROM %s WHERE %s = convert(%s,?)", this.dataTableName, this.config.idColumnName(), this.config.idColumnType());
    }

    @Override
    protected String initUpsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("MERGE INTO %1$s AS t USING (SELECT ? %2$s, ? %3$s, ? %4$s) AS tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE INTO %1$s AS t USING (SELECT ? %2$s, ? %3$s, ? %4$s, ? %5$s) AS tmp ON (t.%4$s = tmp.%4$s) WHEN MATCHED THEN UPDATE SET t.%2$s = tmp.%2$s, t.%3$s = tmp.%3$s WHEN NOT MATCHED THEN INSERT VALUES (tmp.%4$s, tmp.%2$s, tmp.%3$s, tmp.%5$s)", this.dataTableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean indexExists(String indexName, Connection conn) throws PersistenceException {
        ResultSet rs;
        block7: {
            boolean bl;
            block6: {
                rs = null;
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    rs = meta.getIndexInfo(null, this.dataTableName.getSchema(), this.dataTableName.getName(), false, false);
                    while (rs.next()) {
                        String index = rs.getString("INDEX_NAME");
                        if (index == null || !indexName.equalsIgnoreCase(index.replaceAll("\"", ""))) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        throw throwable;
                    }
                }
            }
            JdbcUtil.safeClose((ResultSet)rs);
            return bl;
        }
        JdbcUtil.safeClose((ResultSet)rs);
        return false;
    }
}

