/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.nio.charset.StandardCharsets;

public enum MemcachedStatus {
    NO_ERROR(0),
    KEY_NOT_FOUND(1, "NOT_FOUND"),
    KEY_EXISTS(2, "EXISTS"),
    VALUE_TOO_LARGE(3),
    INVALID_ARGUMENTS(4),
    ITEM_NOT_STORED(5, "NOT_STORED"),
    INCR_DECR_NON_NUMERIC(6),
    VBUCKET_ON_OTHER_SERVER(7),
    AUTHN_ERROR(32),
    AUTHN_CONTINUE(33),
    UNKNOWN_COMMAND(129),
    OUT_OF_MEMORY(130),
    NOT_SUPPORTED(131),
    INTERNAL_ERROR(132, "SERVER_ERROR"),
    BUSY(133),
    TEMPORARY_FAILURE(134),
    DELETED(0);

    private final short binaryOpCode;
    private final byte[] text;

    private MemcachedStatus(int binaryOpCode, String text) {
        this.binaryOpCode = (short)binaryOpCode;
        this.text = text.getBytes(StandardCharsets.US_ASCII);
    }

    private MemcachedStatus(int binaryOpCode) {
        this.binaryOpCode = (short)binaryOpCode;
        this.text = null;
    }

    public short getBinary() {
        return this.binaryOpCode;
    }

    public byte[] getText() {
        return this.text;
    }
}

