/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.resp;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.endpoint.EndpointConfigurationBuilder;
import org.infinispan.server.configuration.resp.Attribute;
import org.infinispan.server.configuration.resp.Element;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.configuration.RespAuthenticationConfigurationBuilder;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.security.ElytronRESPAuthenticator;
import org.infinispan.server.security.ElytronUsernamePasswordAuthenticator;
import org.infinispan.server.security.RespClientCertAuthenticator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="resp-connector"), @Namespace(uri="urn:infinispan:server:*", root="resp-connector")})
public class RespServerConfigurationParser
implements ConfigurationParser {
    private static final Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case RESP_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseResp(reader, serverBuilder);
                    break;
                }
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseResp(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder) {
        boolean dedicatedSocketBinding = false;
        String securityRealm = null;
        EndpointConfigurationBuilder endpoint = serverBuilder.endpoints().current();
        RespServerConfigurationBuilder builder = endpoint.addConnector(RespServerConfigurationBuilder.class);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = StringPropertyReplacer.replaceProperties((String)reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CACHE: {
                    builder.defaultCacheName(value);
                    continue block10;
                }
                case NAME: {
                    builder.name(value);
                    continue block10;
                }
                case SOCKET_BINDING: {
                    builder.socketBinding(value);
                    builder.startTransport(true);
                    dedicatedSocketBinding = true;
                    continue block10;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, serverBuilder, builder);
                }
            }
        }
        if (!dedicatedSocketBinding) {
            ((RespServerConfigurationBuilder)builder.socketBinding(endpoint.singlePort().socketBinding())).startTransport(false);
        }
        block11: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHENTICATION: {
                    this.parseAuthentication(reader, serverBuilder, builder.authentication().enable(), securityRealm);
                    continue block11;
                }
                case ENCRYPTION: {
                    if (!dedicatedSocketBinding) {
                        throw Server.log.cannotConfigureProtocolEncryptionUnderSinglePort();
                    }
                    this.parseEncryption(reader, serverBuilder, builder.encryption(), securityRealm);
                    continue block11;
                }
            }
            ServerConfigurationParser.parseCommonConnectorElements(reader, builder);
        }
    }

    private void parseAuthentication(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, RespAuthenticationConfigurationBuilder builder, String securityRealmName) {
        if (securityRealmName == null) {
            securityRealmName = serverBuilder.endpoints().current().securityRealm();
        }
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SECURITY_REALM: {
                    builder.securityRealm(value);
                    securityRealmName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
        if (securityRealmName == null) {
            throw Server.log.authenticationWithoutSecurityRealm();
        }
        ElytronRESPAuthenticator authenticator = new ElytronRESPAuthenticator();
        authenticator.withUsernamePasswordAuth(new ElytronUsernamePasswordAuthenticator(securityRealmName));
        authenticator.withClientCertAuth(new RespClientCertAuthenticator(securityRealmName));
        builder.authenticator((RespAuthenticator)authenticator);
    }

    private void parseEncryption(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, EncryptionConfigurationBuilder encryption, String securityRealmName) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            org.infinispan.server.configuration.rest.Attribute attribute = org.infinispan.server.configuration.rest.Attribute.forName(reader.getAttributeName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case REQUIRE_SSL_CLIENT_AUTH: {
                    encryption.requireClientAuth(Boolean.parseBoolean(value));
                    continue block4;
                }
                case SECURITY_REALM: {
                    securityRealmName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        if (securityRealmName == null) {
            throw Server.log.encryptionWithoutSecurityRealm();
        }
        encryption.realm(securityRealmName).sslContext(serverBuilder.serverSSLContextSupplier(securityRealmName));
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }
}

