/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.binary.OperationImpl;

public abstract class SASLBaseOperationImpl
extends OperationImpl {
    private static final byte SASL_CONTINUE = 33;
    protected final SaslClient sc;
    protected final byte[] ch;

    public SASLBaseOperationImpl(byte c, SaslClient sasl, byte[] challenge, OperationCallback cb) {
        super(c, SASLBaseOperationImpl.generateOpaque(), cb);
        this.sc = sasl;
        this.ch = challenge;
    }

    @Override
    public void initialize() {
        try {
            byte[] response = this.buildResponse();
            String mechanism = this.sc.getMechanismName();
            this.getLogger().debug("Using SASL auth mechanism: " + mechanism);
            this.prepareBuffer(mechanism, 0L, response, new Object[0]);
        }
        catch (SaslException e) {
            throw new RuntimeException("Can't make SASL go.", e);
        }
    }

    protected abstract byte[] buildResponse() throws SaslException;

    @Override
    protected void decodePayload(byte[] pl) {
        this.getLogger().debug("Auth response:  %s", new String(pl));
    }

    @Override
    protected void finishedPayload(byte[] pl) throws IOException {
        if (this.errorCode == 33) {
            this.getCallback().receivedStatus(new OperationStatus(true, new String(pl), StatusCode.SUCCESS));
            this.transitionState(OperationState.COMPLETE);
        } else if (this.errorCode == 0) {
            this.getCallback().receivedStatus(new OperationStatus(true, "", StatusCode.SUCCESS));
            this.transitionState(OperationState.COMPLETE);
        } else {
            super.finishedPayload(pl);
        }
    }

    @Override
    public String toString() {
        return "SASL base operation";
    }
}

