/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.jpa;

import jakarta.transaction.Transactional;
import java.util.Map;
import org.javers.common.validation.Validate;
import org.javers.core.Javers;
import org.javers.core.commit.Commit;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.spring.transactions.JaversTransactionalDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class JaversTransactionalJpaDecorator
extends JaversTransactionalDecorator
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(JaversTransactionalJpaDecorator.class);
    private final JaversSqlRepository javersSqlRepository;
    private final PlatformTransactionManager txManager;

    JaversTransactionalJpaDecorator(Javers delegate, JaversSqlRepository javersSqlRepository, PlatformTransactionManager txManager) {
        super(delegate);
        Validate.argumentsAreNotNull((Object[])new Object[]{javersSqlRepository, txManager});
        this.javersSqlRepository = javersSqlRepository;
        this.txManager = txManager;
    }

    @Transactional
    public Commit commit(String author, Object currentVersion) {
        this.registerRollbackListener();
        return super.commit(author, currentVersion);
    }

    @Transactional
    public Commit commit(String author, Object currentVersion, Map<String, String> commitProperties) {
        this.registerRollbackListener();
        return super.commit(author, currentVersion, commitProperties);
    }

    public void afterPropertiesSet() throws Exception {
        this.ensureSchema();
    }

    private void ensureSchema() {
        if (this.javersSqlRepository.getConfiguration().isSchemaManagementEnabled()) {
            TransactionTemplate tmpl = new TransactionTemplate(this.txManager);
            tmpl.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    JaversTransactionalJpaDecorator.this.javersSqlRepository.ensureSchema();
                }
            });
        }
    }

    private void registerRollbackListener() {
        if (this.javersSqlRepository.getConfiguration().isGlobalIdCacheDisabled()) {
            return;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive() && TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    if (1 == status) {
                        logger.info("evicting javersSqlRepository local cache due to transaction rollback");
                        JaversTransactionalJpaDecorator.this.javersSqlRepository.evictCache();
                    }
                }
            });
        }
    }
}

