/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.classfilewriter.AccessFlag;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.invocation.proxy.AbstractSubclassFactory;
import org.jboss.invocation.proxy.classloading.MethodStore;
import org.jboss.invocation.proxy.reflection.ReflectionMetadataSource;

public abstract class AbstractProxyFactory<T>
extends AbstractSubclassFactory<T> {
    private static final String METHOD_FIELD_PREFIX = "METHOD$$IDENTIFIER";
    private static final String METHOD_FIELD_DESCRIPTOR = "Ljava/lang/reflect/Method;";
    private final Map<Method, Integer> methodIdentifiers = new HashMap<Method, Integer>();
    private int identifierCount = 0;
    private ClassMethod staticConstructor;
    private final List<Method> cachedMethods = new ArrayList<Method>(0);

    protected AbstractProxyFactory(String className, Class<T> superClass, ClassLoader classLoader, ProtectionDomain protectionDomain, ReflectionMetadataSource reflectionMetadataSource) {
        super(className, superClass, classLoader, protectionDomain, reflectionMetadataSource);
        this.staticConstructor = this.classFile.addMethod(AccessFlag.of((int[])new int[]{1, 8}), "<clinit>", "V", new String[0]);
    }

    protected void finalizeStaticConstructor() {
        this.setupCachedProxyFields();
        this.staticConstructor.getCodeAttribute().returnInstruction();
    }

    @Override
    public void afterClassLoad(Class<?> clazz) {
        super.afterClassLoad(clazz);
        try {
            Class.forName(clazz.getName(), true, clazz.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        MethodStore.METHODS.remove();
    }

    private void setupCachedProxyFields() {
        this.cachedMethods.addAll(this.methodIdentifiers.keySet());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Method method : AbstractProxyFactory.this.cachedMethods) {
                    method.setAccessible(true);
                }
                return null;
            }
        });
        Method[] methods = new Method[this.identifierCount];
        for (Map.Entry<Method, Integer> entry : this.methodIdentifiers.entrySet()) {
            methods[entry.getValue().intValue()] = entry.getKey();
        }
        MethodStore.METHODS.set(methods);
        CodeAttribute ca = this.staticConstructor.getCodeAttribute();
        ca.getstatic(MethodStore.class.getName(), "METHODS", "Ljava/lang/ThreadLocal;");
        ca.invokevirtual(ThreadLocal.class.getName(), "get", "()Ljava/lang/Object;");
        ca.checkcast("[Ljava/lang/reflect/Method;");
        for (int i = 0; i < this.identifierCount; ++i) {
            ca.dup();
            ca.ldc(i);
            ca.aaload();
            ca.putstatic(this.getClassName(), METHOD_FIELD_PREFIX + i, METHOD_FIELD_DESCRIPTOR);
        }
    }

    public List<Method> getCachedMethods() {
        this.defineClass();
        return this.cachedMethods;
    }

    @Override
    protected void cleanup() {
        this.staticConstructor = null;
        this.methodIdentifiers.clear();
        super.cleanup();
    }

    protected void loadMethodIdentifier(Method methodToLoad, ClassMethod method) {
        if (!this.methodIdentifiers.containsKey(methodToLoad)) {
            int identifierNo = this.identifierCount++;
            String fieldName = METHOD_FIELD_PREFIX + identifierNo;
            this.classFile.addField(10, fieldName, Method.class);
            this.methodIdentifiers.put(methodToLoad, identifierNo);
        }
        Integer fieldNo = this.methodIdentifiers.get(methodToLoad);
        method.getCodeAttribute().getstatic(this.getClassName(), METHOD_FIELD_PREFIX + fieldNo, METHOD_FIELD_DESCRIPTOR);
    }

    private class CachedMethodGetter
    implements PrivilegedAction<Method[]> {
        private CachedMethodGetter() {
        }

        @Override
        public Method[] run() {
            Method[] methods = new Method[AbstractProxyFactory.this.identifierCount];
            Class clazz = AbstractProxyFactory.this.defineClass();
            int i = 0;
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    if (!field.getName().startsWith(AbstractProxyFactory.METHOD_FIELD_PREFIX)) continue;
                    field.setAccessible(true);
                    methods[i] = (Method)field.get(null);
                    methods[i].setAccessible(true);
                    ++i;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return methods;
        }
    }
}

