/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public final class UninterruptibleOutputStream
extends FilterOutputStream {
    public UninterruptibleOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        boolean intr = false;
        while (true) {
            try {
                super.write(b);
                return;
            }
            catch (InterruptedIOException e) {
                int transferred = e.bytesTransferred;
                if (transferred == 1) {
                    return;
                }
                intr |= Thread.interrupted();
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        block9: {
            boolean intr = false;
            while (true) {
                if (len <= 0) break block9;
                try {
                    super.write(b, off, len);
                    return;
                }
                catch (InterruptedIOException e) {
                    int transferred = e.bytesTransferred;
                    if (transferred > 0) {
                        off += transferred;
                        len -= transferred;
                    }
                    intr |= Thread.interrupted();
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        boolean intr = false;
        while (true) {
            try {
                super.flush();
                return;
            }
            catch (InterruptedIOException e) {
                intr |= Thread.interrupted();
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() throws IOException {
        boolean intr = false;
        while (true) {
            try {
                super.close();
                return;
            }
            catch (InterruptedIOException e) {
                intr |= Thread.interrupted();
                continue;
            }
            break;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "uninterruptible " + this.out.toString();
    }
}

