/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

final class ColorUtil {
    private ColorUtil() {
    }

    static StringBuilder startFgColor(StringBuilder target, boolean trueColor, int r, int g, int b) {
        return ColorUtil.startColor(target, 38, trueColor, r, g, b);
    }

    static StringBuilder startBgColor(StringBuilder target, boolean trueColor, int r, int g, int b) {
        return ColorUtil.startColor(target, 48, trueColor, r, g, b);
    }

    static StringBuilder startColor(StringBuilder target, int mode, boolean trueColor, int r, int g, int b) {
        if (trueColor) {
            return target.appendCodePoint(27).append('[').append(mode).append(';').append(2).append(';').append(ColorUtil.clip(r)).append(';').append(ColorUtil.clip(g)).append(';').append(ColorUtil.clip(b)).append('m');
        }
        int ar = 5 * ColorUtil.clip(r) / 255;
        int ag = 5 * ColorUtil.clip(g) / 255;
        int ab = 5 * ColorUtil.clip(b) / 255;
        int col = 16 + 36 * ar + 6 * ag + ab;
        return target.appendCodePoint(27).append('[').append(mode).append(';').append('5').append(';').append(col).append('m');
    }

    private static int clip(int color) {
        return Math.min(Math.max(0, color), 255);
    }

    static StringBuilder endFgColor(StringBuilder target) {
        return ColorUtil.endColor(target, 39);
    }

    static StringBuilder endBgColor(StringBuilder target) {
        return ColorUtil.endColor(target, 49);
    }

    static StringBuilder endColor(StringBuilder target, int mode) {
        return target.appendCodePoint(27).append('[').append(mode).append('m');
    }
}

