/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.marshalling.ClassExternalizerFactory;
import org.jboss.marshalling.Externalizer;

public class ChainingClassExternalizerFactory
implements ClassExternalizerFactory {
    private final ClassExternalizerFactory[] externalizerFactories;

    public ChainingClassExternalizerFactory(Collection<ClassExternalizerFactory> factories) {
        this.externalizerFactories = factories.toArray(new ClassExternalizerFactory[factories.size()]);
    }

    public ChainingClassExternalizerFactory(Iterable<ClassExternalizerFactory> factories) {
        this(factories.iterator());
    }

    public ChainingClassExternalizerFactory(Iterator<ClassExternalizerFactory> factories) {
        this.externalizerFactories = ChainingClassExternalizerFactory.unroll(factories, 0);
    }

    public ChainingClassExternalizerFactory(ClassExternalizerFactory[] factories) {
        this.externalizerFactories = (ClassExternalizerFactory[])factories.clone();
    }

    private static ClassExternalizerFactory[] unroll(Iterator<ClassExternalizerFactory> iterator, int i) {
        if (iterator.hasNext()) {
            ClassExternalizerFactory factory = iterator.next();
            ClassExternalizerFactory[] array = ChainingClassExternalizerFactory.unroll(iterator, i + 1);
            array[i] = factory;
            return array;
        }
        return new ClassExternalizerFactory[i];
    }

    @Override
    public Externalizer getExternalizer(Class<?> type) {
        for (ClassExternalizerFactory externalizerFactory : this.externalizerFactories) {
            Externalizer externalizer = externalizerFactory.getExternalizer(type);
            if (externalizer == null) continue;
            return externalizer;
        }
        return null;
    }
}

