/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.causeway.dto.push;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import lombok.NonNull;
import org.jboss.pnc.api.causeway.dto.push.BuiltArtifact;

@JsonTypeName(value="maven")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=MavenBuiltArtifactBuilder.class)
public class MavenBuiltArtifact
extends BuiltArtifact {
    @NonNull
    private final String groupId;
    @NonNull
    private final String artifactId;
    @NonNull
    private final String version;

    public MavenBuiltArtifact(String groupId, String artifactId, String version, String id, String filename, String architecture, String md5, String artifactPath, String repositoryPath, int size) {
        super(id, filename, architecture, md5, artifactPath, repositoryPath, size);
        this.groupId = Objects.requireNonNull(groupId, "GroupID must be set");
        this.artifactId = Objects.requireNonNull(artifactId, "ArtifactID must be set");
        this.version = Objects.requireNonNull(version, "Version must be set");
    }

    public static MavenBuiltArtifactBuilder builder() {
        return new MavenBuiltArtifactBuilder();
    }

    @NonNull
    public String getGroupId() {
        return this.groupId;
    }

    @NonNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return "MavenBuiltArtifact(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenBuiltArtifact)) {
            return false;
        }
        MavenBuiltArtifact other = (MavenBuiltArtifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MavenBuiltArtifact;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @JsonTypeName(value="maven")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MavenBuiltArtifactBuilder {
        private String groupId;
        private String artifactId;
        private String version;
        private String id;
        private String filename;
        private String architecture;
        private String md5;
        private String artifactPath;
        private String repositoryPath;
        private int size;

        MavenBuiltArtifactBuilder() {
        }

        public MavenBuiltArtifactBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public MavenBuiltArtifactBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public MavenBuiltArtifactBuilder version(String version) {
            this.version = version;
            return this;
        }

        public MavenBuiltArtifactBuilder id(String id) {
            this.id = id;
            return this;
        }

        public MavenBuiltArtifactBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public MavenBuiltArtifactBuilder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public MavenBuiltArtifactBuilder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public MavenBuiltArtifactBuilder artifactPath(String artifactPath) {
            this.artifactPath = artifactPath;
            return this;
        }

        public MavenBuiltArtifactBuilder repositoryPath(String repositoryPath) {
            this.repositoryPath = repositoryPath;
            return this;
        }

        public MavenBuiltArtifactBuilder size(int size) {
            this.size = size;
            return this;
        }

        public MavenBuiltArtifact build() {
            return new MavenBuiltArtifact(this.groupId, this.artifactId, this.version, this.id, this.filename, this.architecture, this.md5, this.artifactPath, this.repositoryPath, this.size);
        }

        public String toString() {
            return "MavenBuiltArtifact.MavenBuiltArtifactBuilder(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", id=" + this.id + ", filename=" + this.filename + ", architecture=" + this.architecture + ", md5=" + this.md5 + ", artifactPath=" + this.artifactPath + ", repositoryPath=" + this.repositoryPath + ", size=" + this.size + ")";
        }
    }
}

