/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.api.repositorydriver.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import org.jboss.pnc.api.enums.BuildType;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class RepositoryCreateRequest {
    private final String buildContentId;
    private final BuildType buildType;
    private final boolean tempBuild;
    private final List<String> extraRepositories;

    public static Builder builder() {
        return new Builder();
    }

    public RepositoryCreateRequest(String buildContentId, BuildType buildType, boolean tempBuild, List<String> extraRepositories) {
        this.buildContentId = buildContentId;
        this.buildType = buildType;
        this.tempBuild = tempBuild;
        this.extraRepositories = extraRepositories;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public boolean isTempBuild() {
        return this.tempBuild;
    }

    public List<String> getExtraRepositories() {
        return this.extraRepositories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryCreateRequest)) {
            return false;
        }
        RepositoryCreateRequest other = (RepositoryCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTempBuild() != other.isTempBuild()) {
            return false;
        }
        String this$buildContentId = this.getBuildContentId();
        String other$buildContentId = other.getBuildContentId();
        if (this$buildContentId == null ? other$buildContentId != null : !this$buildContentId.equals(other$buildContentId)) {
            return false;
        }
        BuildType this$buildType = this.getBuildType();
        BuildType other$buildType = other.getBuildType();
        if (this$buildType == null ? other$buildType != null : !((Object)((Object)this$buildType)).equals((Object)other$buildType)) {
            return false;
        }
        List<String> this$extraRepositories = this.getExtraRepositories();
        List<String> other$extraRepositories = other.getExtraRepositories();
        return !(this$extraRepositories == null ? other$extraRepositories != null : !((Object)this$extraRepositories).equals(other$extraRepositories));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepositoryCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTempBuild() ? 79 : 97);
        String $buildContentId = this.getBuildContentId();
        result = result * 59 + ($buildContentId == null ? 43 : $buildContentId.hashCode());
        BuildType $buildType = this.getBuildType();
        result = result * 59 + ($buildType == null ? 43 : ((Object)((Object)$buildType)).hashCode());
        List<String> $extraRepositories = this.getExtraRepositories();
        result = result * 59 + ($extraRepositories == null ? 43 : ((Object)$extraRepositories).hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryCreateRequest(buildContentId=" + this.getBuildContentId() + ", buildType=" + (Object)((Object)this.getBuildType()) + ", tempBuild=" + this.isTempBuild() + ", extraRepositories=" + this.getExtraRepositories() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class Builder {
        private String buildContentId;
        private BuildType buildType;
        private boolean tempBuild;
        private List<String> extraRepositories;

        Builder() {
        }

        public Builder buildContentId(String buildContentId) {
            this.buildContentId = buildContentId;
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            return this;
        }

        public Builder tempBuild(boolean tempBuild) {
            this.tempBuild = tempBuild;
            return this;
        }

        public Builder extraRepositories(List<String> extraRepositories) {
            this.extraRepositories = extraRepositories;
            return this;
        }

        public RepositoryCreateRequest build() {
            return new RepositoryCreateRequest(this.buildContentId, this.buildType, this.tempBuild, this.extraRepositories);
        }

        public String toString() {
            return "RepositoryCreateRequest.Builder(buildContentId=" + this.buildContentId + ", buildType=" + (Object)((Object)this.buildType) + ", tempBuild=" + this.tempBuild + ", extraRepositories=" + this.extraRepositories + ")";
        }
    }
}

