/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.datatype.impl.type;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jbpm.process.core.datatype.DataType;

public class IntegerDataType
implements DataType {
    private static final long serialVersionUID = 510L;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public boolean verifyDataType(Object value) {
        if (value instanceof Integer) {
            return true;
        }
        return value == null;
    }

    @Override
    public Object readValue(String value) {
        return new Integer(value);
    }

    @Override
    public String writeValue(Object value) {
        Integer i = (Integer)value;
        return i == null ? "" : i.toString();
    }

    @Override
    public String getStringType() {
        return "Integer";
    }

    @Override
    public Object valueOf(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return value;
        }
    }
}

