/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.function.UnaryOperator;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.kie.api.fluent.BoundaryEventNodeBuilder;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.NodeContainerBuilder;

public class BoundaryEventNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<BoundaryEventNodeBuilder<T>, T>
implements BoundaryEventNodeBuilder<T> {
    private String attachedToUniqueId;

    public BoundaryEventNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new BoundaryEventNode(), id);
    }

    public BoundaryEventNodeFactory<T> attachedTo(long attachedToId) {
        this.attachedToUniqueId = (String)this.nodeContainer.getNode(attachedToId).getMetaData().get("UniqueId");
        this.getBoundaryEventNode().setAttachedToNodeId(this.attachedToUniqueId);
        this.getBoundaryEventNode().setMetaData("AttachedTo", this.attachedToUniqueId);
        return this;
    }

    protected BoundaryEventNode getBoundaryEventNode() {
        return (BoundaryEventNode)this.getNode();
    }

    public BoundaryEventNodeFactory<T> variableName(String variableName) {
        this.getBoundaryEventNode().setVariableName(variableName);
        return this;
    }

    public BoundaryEventNodeFactory<T> eventFilter(EventFilter eventFilter) {
        this.getBoundaryEventNode().addEventFilter(eventFilter);
        return this;
    }

    public BoundaryEventNodeFactory<T> eventType(String eventType) {
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType(eventType);
        return this.eventFilter(filter);
    }

    public BoundaryEventNodeFactory<T> eventType(String eventTypePrefix, String eventTypeSurffix) {
        if (this.attachedToUniqueId == null) {
            throw new IllegalStateException("attachedTo() must be called before");
        }
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType(eventTypePrefix + "-" + this.attachedToUniqueId + "-" + eventTypeSurffix);
        return this.eventFilter(filter);
    }

    public BoundaryEventNodeFactory<T> timeCycle(String timeCycle) {
        this.eventType("Timer", timeCycle);
        this.setMetadata("TimeCycle", timeCycle);
        return this;
    }

    public BoundaryEventNodeFactory<T> timeCycle(String timeCycle, String language) {
        this.eventType("Timer", timeCycle);
        this.setMetadata("TimeCycle", timeCycle);
        this.setMetadata("Language", language);
        return this;
    }

    public BoundaryEventNodeFactory<T> timeDuration(String timeDuration) {
        this.eventType("Timer", timeDuration);
        this.setMetadata("TimeDuration", timeDuration);
        return this;
    }

    public BoundaryEventNodeFactory<T> cancelActivity(boolean cancelActivity) {
        this.setMetadata("CancelActivity", cancelActivity);
        return this;
    }

    public BoundaryEventNodeFactory<T> eventTransformer(EventTransformer transformer) {
        this.getBoundaryEventNode().setEventTransformer(transformer);
        return this;
    }

    public BoundaryEventNodeFactory<T> scope(String scope) {
        this.getBoundaryEventNode().setScope(scope);
        return this;
    }

    public BoundaryEventNodeBuilder<T> timeCycle(String timeCycle, Dialect dialect) {
        return this.timeCycle(timeCycle, DialectConverter.fromDialect(dialect));
    }

    public BoundaryEventNodeBuilder<T> eventTransformer(UnaryOperator<Object> function) {
        return this.eventTransformer(function::apply);
    }
}

