/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.HumanTaskNodeBuilder;
import org.kie.api.fluent.NodeContainerBuilder;

public class HumanTaskNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<HumanTaskNodeBuilder<T>, T>
implements HumanTaskNodeBuilder<T> {
    public HumanTaskNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new HumanTaskNode(), id);
    }

    protected HumanTaskNode getHumanTaskNode() {
        return (HumanTaskNode)this.getNode();
    }

    @Override
    public HumanTaskNodeFactory<T> name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public HumanTaskNodeFactory<T> taskName(String taskName) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter("TaskName", taskName);
        return this;
    }

    public HumanTaskNodeFactory<T> actorId(String actorId) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter("ActorId", actorId);
        return this;
    }

    public HumanTaskNodeFactory<T> priority(String priority) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter("Priority", priority);
        return this;
    }

    public HumanTaskNodeFactory<T> comment(String comment) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter("Comment", comment);
        return this;
    }

    public HumanTaskNodeFactory<T> skippable(boolean skippable) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter("Skippable", Boolean.toString(skippable));
        return this;
    }

    public HumanTaskNodeFactory<T> content(String content) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter("Content", content);
        return this;
    }

    public HumanTaskNodeFactory<T> inMapping(String parameterName, String variableName) {
        this.getHumanTaskNode().addInMapping(parameterName, variableName);
        return this;
    }

    public HumanTaskNodeFactory<T> outMapping(String parameterName, String variableName) {
        this.getHumanTaskNode().addOutMapping(parameterName, variableName);
        return this;
    }

    public HumanTaskNodeFactory<T> waitForCompletion(boolean waitForCompletion) {
        this.getHumanTaskNode().setWaitForCompletion(waitForCompletion);
        return this;
    }

    public HumanTaskNodeFactory<T> swimlane(String swimlane) {
        this.getHumanTaskNode().setSwimlane(swimlane);
        return this;
    }

    public HumanTaskNodeFactory<T> onEntryAction(String dialect, String action) {
        if (this.getHumanTaskNode().getActions(dialect) != null) {
            this.getHumanTaskNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getHumanTaskNode().setActions("onEntry", actions);
        }
        return this;
    }

    public HumanTaskNodeFactory<T> onExitAction(String dialect, String action) {
        if (this.getHumanTaskNode().getActions(dialect) != null) {
            this.getHumanTaskNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getHumanTaskNode().setActions("onExit", actions);
        }
        return this;
    }

    public HumanTaskNodeFactory<T> timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getHumanTaskNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }

    public HumanTaskNodeFactory<T> workParameter(String name, Object value) {
        Work work = this.getHumanTaskNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getHumanTaskNode().setWork(work);
        }
        work.setParameter(name, value);
        return this;
    }

    public HumanTaskNodeBuilder<T> onEntryAction(Dialect dialect, String action) {
        return this.onEntryAction(DialectConverter.fromDialect(dialect), action);
    }

    public HumanTaskNodeBuilder<T> onExitAction(Dialect dialect, String action) {
        return this.onExitAction(DialectConverter.fromDialect(dialect), action);
    }

    public HumanTaskNodeBuilder<T> timer(String delay, String period, Dialect dialect, String action) {
        return this.timer(delay, period, DialectConverter.fromDialect(dialect), action);
    }
}

