/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.core;

import com.google.common.base.Preconditions;
import org.jeecg.boot.starter.lock.core.strategy.RedissonConfigStrategy;
import org.jeecg.boot.starter.lock.core.strategy.impl.ClusterRedissonConfigStrategyImpl;
import org.jeecg.boot.starter.lock.core.strategy.impl.MasterslaveRedissonConfigStrategyImpl;
import org.jeecg.boot.starter.lock.core.strategy.impl.SentinelRedissonConfigStrategyImpl;
import org.jeecg.boot.starter.lock.core.strategy.impl.StandaloneRedissonConfigStrategyImpl;
import org.jeecg.boot.starter.lock.enums.RedisConnectionType;
import org.jeecg.boot.starter.lock.prop.RedissonProperties;
import org.redisson.Redisson;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonManager {
    private static final Logger log = LoggerFactory.getLogger(RedissonManager.class);
    private Config config = new Config();
    private Redisson redisson = null;

    public RedissonManager() {
    }

    public RedissonManager(RedissonProperties redissonProperties) {
        Boolean enabled = redissonProperties.getEnabled();
        if (enabled.booleanValue()) {
            try {
                this.config = RedissonConfigFactory.getInstance().createConfig(redissonProperties);
                this.redisson = (Redisson)Redisson.create((Config)this.config);
            }
            catch (Exception e) {
                log.error("Redisson\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
            }
        }
    }

    public Redisson getRedisson() {
        return this.redisson;
    }

    static class RedissonConfigFactory {
        private static volatile RedissonConfigFactory factory = null;

        private RedissonConfigFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static RedissonConfigFactory getInstance() {
            if (factory != null) return factory;
            Class<Object> clazz = Object.class;
            synchronized (Object.class) {
                if (factory != null) return factory;
                factory = new RedissonConfigFactory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return factory;
            }
        }

        Config createConfig(RedissonProperties redissonProperties) {
            Preconditions.checkNotNull((Object)redissonProperties);
            Preconditions.checkNotNull((Object)redissonProperties.getAddress(), (Object)"redis\u5730\u5740\u672a\u914d\u7f6e");
            RedisConnectionType connectionType = redissonProperties.getType();
            RedissonConfigStrategy redissonConfigStrategy = connectionType.equals((Object)RedisConnectionType.SENTINEL) ? new SentinelRedissonConfigStrategyImpl() : (connectionType.equals((Object)RedisConnectionType.CLUSTER) ? new ClusterRedissonConfigStrategyImpl() : (connectionType.equals((Object)RedisConnectionType.MASTERSLAVE) ? new MasterslaveRedissonConfigStrategyImpl() : new StandaloneRedissonConfigStrategyImpl()));
            Preconditions.checkNotNull((Object)redissonConfigStrategy, (Object)"\u8fde\u63a5\u65b9\u5f0f\u521b\u5efa\u5f02\u5e38");
            return redissonConfigStrategy.createRedissonConfig(redissonProperties);
        }
    }
}

