/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.rabbitmq.client;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.jeecg.boot.starter.rabbitmq.event.EventObj;
import org.jeecg.boot.starter.rabbitmq.event.JeecgRemoteApplicationEvent;
import org.jeecg.common.base.BaseMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

@Configuration
public class RabbitMqClient {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqClient.class);
    private RocketMQTemplate rocketMQTemplate;
    private ApplicationEventPublisher publisher;
    private BusProperties busProperties;

    public void sendMessage(String topic, Object payload) {
        this.rocketMQTemplate.convertAndSend((Object)topic, payload);
    }

    public <T> SendResult sendMessage(String topic, Collection<T> payload) {
        return this.rocketMQTemplate.syncSend(topic, this.convert(payload));
    }

    public void sendAsyncMessage(String topic, Object payload, SendCallback callback) {
        this.rocketMQTemplate.asyncSend(topic, payload, callback);
    }

    public <T> void sendAsyncMessage(String topic, Collection<T> payload, SendCallback sendCallback) {
        this.rocketMQTemplate.asyncSend(topic, this.convert(payload), sendCallback);
    }

    public void sendOrderlyMessage(String topic, Object payload, String hashKey) {
        this.rocketMQTemplate.syncSendOrderly(topic, payload, hashKey);
    }

    public void sendAsyncOrderlyMessage(String topic, Object payload, String hashKey, SendCallback callback) {
        this.rocketMQTemplate.asyncSendOrderly(topic, payload, hashKey, callback);
    }

    public void sendOneway(String topic, Object payload) {
        this.rocketMQTemplate.sendOneWay(topic, payload);
    }

    public void sendOnewayOrderly(String topic, Object payload, String hashKey) {
        this.rocketMQTemplate.sendOneWayOrderly(topic, payload, hashKey);
    }

    public void sendMessageInTransaction(String topic, Object payload, Object arg) {
        this.rocketMQTemplate.sendMessageInTransaction(topic, MessageBuilder.withPayload((Object)payload).build(), arg);
    }

    public <T> List<T> receive(Class<T> clazz) {
        return this.rocketMQTemplate.receive(clazz);
    }

    public SendResult sendMessage(String topic, Object payload, Integer delayLevel) {
        return this.rocketMQTemplate.syncSend(topic, MessageBuilder.withPayload((Object)payload).build(), (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), delayLevel.intValue());
    }

    public void publishEvent(String handlerName, BaseMap baseMap) {
        EventObj eventObj = new EventObj();
        eventObj.setHandlerName(handlerName);
        eventObj.setBaseMap(baseMap);
        this.publisher.publishEvent((ApplicationEvent)new JeecgRemoteApplicationEvent(eventObj, this.busProperties.getId()));
    }

    public <T> List<Message<T>> convert(Collection<T> payload) {
        return payload.stream().map(p -> MessageBuilder.withPayload((Object)p).build()).collect(Collectors.toList());
    }

    public RabbitMqClient(RocketMQTemplate rocketMQTemplate, ApplicationEventPublisher publisher, BusProperties busProperties) {
        this.rocketMQTemplate = rocketMQTemplate;
        this.publisher = publisher;
        this.busProperties = busProperties;
    }
}

