/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.chatgpt.service.impl;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jeecg.ai.handler.LLMHandler;
import org.jeecg.chatgpt.dto.chat.MultiChatMessage;
import org.jeecg.chatgpt.dto.image.ImageFormat;
import org.jeecg.chatgpt.dto.image.ImageSize;
import org.jeecg.chatgpt.service.AiChatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGptService
implements AiChatService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatGptService.class);
    LLMHandler llmHandler;

    public ChatGptService(LLMHandler llmHandler) {
        this.llmHandler = llmHandler;
    }

    @Override
    public String completions(String message) {
        if (StringUtils.isEmpty((String)message)) {
            return "";
        }
        return this.llmHandler.completions(message);
    }

    @Override
    public String multiCompletions(List<MultiChatMessage> messages) {
        if (null == messages || messages.isEmpty()) {
            return "";
        }
        List<ChatMessage> chatMessages = messages.stream().map(m -> {
            if (MultiChatMessage.Role.SYSTEM.getName().equalsIgnoreCase(m.getRole())) {
                return new SystemMessage(m.getContent());
            }
            if (MultiChatMessage.Role.ASSISTANT.getName().equalsIgnoreCase(m.getRole())) {
                return new AiMessage(m.getContent());
            }
            return new UserMessage(m.getContent());
        }).collect(Collectors.toList());
        return this.llmHandler.completions(chatMessages, null);
    }

    @Override
    public String genSchemaModules(String prompt) {
        if (StringUtils.isEmpty((String)prompt)) {
            return "";
        }
        String sysMsgContent = "\u6839\u636e\u4e1a\u52a1\u9700\u6c42\u8bbe\u8ba1\u4e00\u5957\u8868\u5355\uff1b\u53ea\u56de\u7b54json\u6570\u636e\u4e0d\u8981\u6709\u5176\u4ed6\u63cf\u8ff0\u3002\u6574\u4f53\u662f\u4e00\u4e2ajson\u6570\u7ec4\uff0c\u6bcf\u4e2a\u8868\u662f\u4e00\u4e2ajson\u5bf9\u8c61\uff0c\u5c5e\u6027\u5305\u542b\uff1a\u4e2d\u6587\u540d\uff08comment)\uff0c\u82f1\u6587\u540d(tableName)\uff0c\u5b57\u6bb5\u5217\u8868(fields);\u5b57\u6bb5\u5217\u8868\u662f\u4e00\u4e2ajson\u6570\u7ec4\uff0c\u5305\u542b\u5b57\u6bb5\u82f1\u6587\u540d(field)\u3001\u5b57\u6bb5\u4e2d\u6587\u540d(comment)\u3001\u5b57\u6bb5\u6570\u636e\u5e93\u7c7b\u578b(fieldDbType)\u3001\u5b57\u6bb5\u7ec4\u4ef6(component)\u3002\u53ef\u7528\u7684\u7ec4\u4ef6\u5305\u542b\uff1ainput\u3001textarea\u3001number\u3001money\u3001radio\u3001checkbox\u3001select\u3001switch\u3001phone\u3001email\u3001file\u3001date\u3001time\u3002\u53c2\u8003json\uff1a[{\\\"tableName\\\":\\\"order\\\",\\\"comment\\\":\\\"\u8ba2\u5355\u8868\\\",\\\"fields\\\":[{\\\"field\\\":\\\"name\\\",\\\"comment\\\":\\\"\u59d3\u540d\\\",\\\"fieldDbType\\\":\\\"varchar\\\",\\\"component\\\":\\\"input\\\"}]}]\u3002";
        MultiChatMessage sysMsg = MultiChatMessage.builder().role(MultiChatMessage.Role.USER).content(sysMsgContent).build();
        MultiChatMessage userMsg = MultiChatMessage.builder().role(MultiChatMessage.Role.USER).content("\u4e1a\u52a1\u9700\u6c42\u5982\u4e0b:" + prompt).build();
        String gptResp = this.multiCompletions(Arrays.asList(sysMsg, userMsg));
        if (gptResp.contains("</think>")) {
            String[] thinkSplit = gptResp.split("</think>");
            gptResp = thinkSplit[thinkSplit.length - 1];
        }
        Pattern pattern = Pattern.compile("\\[.*?].*$", 32);
        Matcher matcher = pattern.matcher(gptResp);
        String returnData = "";
        if (matcher.find()) {
            returnData = matcher.group(0);
        }
        return returnData;
    }

    @Override
    public String genArticleWithMd(String prompt) {
        if (StringUtils.isEmpty((String)prompt)) {
            return "";
        }
        ArrayList<MultiChatMessage> messages = new ArrayList<MultiChatMessage>();
        messages.add(MultiChatMessage.builder().role(MultiChatMessage.Role.SYSTEM).content("\u6839\u636e\u6587\u7ae0\u5185\u5bb9\u63cf\u8ff0\u7528MarkDown\u5199\u4e00\u7bc7\u8f6f\u6587\uff1b\u53ea\u8f93\u51faMarkDown,\u4e0d\u8981\u5176\u4ed6\u7684\u63cf\u8ff0\u3002").build());
        messages.add(MultiChatMessage.builder().role(MultiChatMessage.Role.USER).content("\u6587\u7ae0\u5185\u5bb9\u63cf\u8ff0\u5982\u4e0b:" + prompt).build());
        String gptResp = this.multiCompletions(messages);
        if (gptResp.contains("</think>")) {
            String[] thinkSplit = gptResp.split("</think>");
            gptResp = thinkSplit[thinkSplit.length - 1];
        }
        return gptResp;
    }

    @Override
    public String imageGenerate(String prompt) {
        log.warn("\u6682\u4e0d\u652f\u6301\u56fe\u50cf\u751f\u6210");
        return null;
    }

    @Override
    public List<String> imageGenerate(String prompt, Integer n, ImageSize size, ImageFormat format) {
        log.warn("\u6682\u4e0d\u652f\u6301\u56fe\u50cf\u751f\u6210");
        return null;
    }
}

