/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.dynamicdb;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.jeecg.modules.drag.config.dynamicdb.OnlDragDataSourceConfig;
import org.jeecg.modules.drag.config.dynamicdb.a;
import org.jeecg.modules.drag.dao.OnlDragDataSourceDao;
import org.jeecg.modules.drag.entity.OnlDragDataSource;
import org.jeecg.modules.drag.exception.DbConnectErrorException;
import org.jeecg.modules.drag.exception.DbConnectMoreErrorException;
import org.jeecg.modules.drag.util.f;
import org.jeecg.modules.drag.util.h;
import org.jeecg.modules.drag.util.k;
import org.jeecg.modules.drag.vo.DynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="OnlDragDynamicDbUtil")
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private OnlDragDataSourceConfig onlDragDataSourceConfig;
    @Autowired
    private OnlDragDataSourceDao onlDragDataSourceDao;
    @Autowired
    private f redisUtil;

    private HikariDataSource a(DynamicDataSourceVo dbSource) {
        HikariDataSource dataSource = new HikariDataSource();
        String driverClassName = dbSource.getDbDriver();
        String url = dbSource.getDbUrl();
        String dbUser = dbSource.getDbUsername();
        String dbPassword = dbSource.getDbPassword();
        dataSource.setDriverClassName(driverClassName);
        dataSource.setJdbcUrl(url);
        dataSource.setUsername(dbUser);
        dataSource.setPassword(dbPassword);
        dataSource.setAutoCommit(this.onlDragDataSourceConfig.getAutoCommit().booleanValue());
        dataSource.setMaximumPoolSize(this.onlDragDataSourceConfig.getMaximumPoolSize().intValue());
        dataSource.setMinimumIdle(this.onlDragDataSourceConfig.getMinimumIdle().intValue());
        dataSource.setConnectionTimeout((long)this.onlDragDataSourceConfig.getConnectionTimeout().intValue());
        dataSource.setIdleTimeout((long)this.onlDragDataSourceConfig.getIdleTimeout().intValue());
        dataSource.setMaxLifetime((long)this.onlDragDataSourceConfig.getMaxLifetime().intValue());
        dataSource.setPoolName(this.onlDragDataSourceConfig.getPoolName());
        return dataSource;
    }

    public DataSource a(String dbId) {
        DataSource cacheDbSource = org.jeecg.modules.drag.config.dynamicdb.a.a(dbId);
        try {
            if (cacheDbSource != null) {
                return cacheDbSource;
            }
            OnlDragDataSource dragDataSource = this.onlDragDataSourceDao.get(dbId);
            DynamicDataSourceVo dbSource = new DynamicDataSourceVo(dragDataSource);
            if (dbSource == null) {
                throw new DbConnectErrorException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff0cdbId\uff1a" + dbId);
            }
            HikariDataSource dataSource = this.a(dbSource);
            if (dataSource == null) {
                throw new DbConnectErrorException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0cdbId\uff1a" + dbId);
            }
            org.jeecg.modules.drag.config.dynamicdb.a.a(dbId, (DataSource)dataSource);
            return dataSource;
        }
        catch (Exception e2) {
            a.warn(e2.getMessage(), (Throwable)e2);
            throw e2;
        }
    }

    private void b(String dbId) {
        DataSource dataSource = this.a(dbId);
        try {
            if (dataSource != null && !dataSource.getConnection().isClosed()) {
                dataSource.getConnection().commit();
                dataSource.getConnection().close();
                dataSource.getConnection().close();
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    private JdbcTemplate c(String dbId) {
        DataSource dataSource;
        String key = String.format("drag:error:dbconn:%s", dbId);
        if (this.redisUtil.a(key)) {
            int connectTimes = h.a(this.redisUtil.b(key), 0);
            a.warn("------\u6570\u636e\u6e90\u5df2\u8fde\u63a5\u9519\u8bef\u6b21\u6570connectTimes\uff1a{}--------------", (Object)connectTimes);
            if (connectTimes > 10) {
                a.error("------\u6570\u636e\u6e90\u5df2\u8fde\u63a5\u9519\u8bef10\u6b21\u4ee5\u4e0a,\u8bf7\u68c0\u67e5,dbId:--------------" + dbId);
                throw new DbConnectMoreErrorException("\u6570\u636e\u6e90\u5df2\u8fde\u63a5\u9519\u8bef10\u6b21\u4ee5\u4e0a,\u8bf7\u68c0\u67e5,dbId:" + dbId);
            }
        }
        if ((dataSource = this.a(dbId)) == null) {
            throw new DbConnectErrorException("\u6570\u636e\u6e90\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\uff01");
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        Integer timeout = h.a((Object)this.onlDragDataSourceConfig.getConnectionTimeout(), 60000);
        jdbcTemplate.setQueryTimeout(timeout / 1000);
        return jdbcTemplate;
    }

    public List<Map<String, Object>> a(String dbId, String sql, Map<String, Object> param) {
        List list;
        k.b(sql);
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = this.c(dbId);
            if (h.c(param)) {
                list = jdbcTemplate.queryForList(sql);
            } else {
                NamedParameterJdbcTemplate parameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
                list = parameterJdbcTemplate.queryForList(sql, param);
            }
            String key = String.format("drag:error:dbconn:%s", dbId);
            if (this.redisUtil.a(key)) {
                this.redisUtil.a(new String[]{key});
            }
        }
        catch (Exception exception) {
            if (exception instanceof DbConnectErrorException || exception instanceof CannotGetJdbcConnectionException) {
                String key = String.format("drag:error:dbconn:%s", dbId);
                if (this.redisUtil.a(key)) {
                    this.redisUtil.a(key, 1L);
                } else {
                    this.redisUtil.a(key, 1, 86400L);
                }
                org.jeecg.modules.drag.config.dynamicdb.a.b(dbId);
            } else if (exception instanceof DbConnectMoreErrorException) {
                throw exception;
            }
            throw exception;
        }
        return list;
    }

    public Object b(String dbId, String sql, Map<String, Object> param) {
        k.b(sql);
        List<Map<String, Object>> list = this.a(dbId, sql, param);
        if (h.c(list)) {
            a.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            a.error("Except one, but more than one actually");
        }
        return list.get(0);
    }
}

