/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.token;

import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManager;
import com.alibaba.nacos.plugin.auth.impl.token.impl.CachedJwtTokenManager;
import com.alibaba.nacos.plugin.auth.impl.token.impl.JwtTokenManager;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.sys.env.EnvUtil;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class TokenManagerDelegate
implements TokenManager {
    public static final String NACOS_AUTH_TOKEN_CACHING_ENABLED = "nacos.core.auth.plugin.nacos.token.cache.enable";
    private boolean tokenCacheEnabled = false;
    @Autowired
    private JwtTokenManager jwtTokenManager;
    @Autowired
    private CachedJwtTokenManager cachedJwtTokenManager;

    @PostConstruct
    public void init() {
        this.tokenCacheEnabled = (Boolean)EnvUtil.getProperty((String)NACOS_AUTH_TOKEN_CACHING_ENABLED, Boolean.class, (Object)false);
    }

    private TokenManager getExecuteTokenManager() {
        return this.tokenCacheEnabled ? this.cachedJwtTokenManager : this.jwtTokenManager;
    }

    @Override
    public String createToken(Authentication authentication) throws AccessException {
        return this.getExecuteTokenManager().createToken(authentication);
    }

    @Override
    public String createToken(String userName) throws AccessException {
        return this.getExecuteTokenManager().createToken(userName);
    }

    @Override
    public Authentication getAuthentication(String token) throws AccessException {
        return this.getExecuteTokenManager().getAuthentication(token);
    }

    @Override
    public void validateToken(String token) throws AccessException {
        this.getExecuteTokenManager().validateToken(token);
    }

    @Override
    public NacosUser parseToken(String token) throws AccessException {
        return this.getExecuteTokenManager().parseToken(token);
    }

    @Override
    public long getTokenValidityInSeconds() throws AccessException {
        return this.getExecuteTokenManager().getTokenValidityInSeconds();
    }

    @Override
    public long getTokenTtlInSeconds(String token) throws AccessException {
        return this.getExecuteTokenManager().getTokenTtlInSeconds(token);
    }
}

