/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.token.impl;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthConstants;
import com.alibaba.nacos.plugin.auth.impl.jwt.NacosJwtParser;
import com.alibaba.nacos.plugin.auth.impl.token.TokenManager;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenManager
extends Subscriber<ServerConfigChangeEvent>
implements TokenManager {
    private static final String AUTH_DISABLED_TOKEN = "AUTH_DISABLED";
    private volatile long tokenValidityInSeconds;
    private volatile NacosJwtParser jwtParser;
    private final AuthConfigs authConfigs;

    public JwtTokenManager(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.processProperties();
    }

    private void processProperties() {
        block2: {
            this.tokenValidityInSeconds = (Long)EnvUtil.getProperty((String)"nacos.core.auth.plugin.nacos.token.expire.seconds", Long.class, (Object)AuthConstants.DEFAULT_TOKEN_EXPIRE_SECONDS);
            String encodedSecretKey = EnvUtil.getProperty((String)"nacos.core.auth.plugin.nacos.token.secret.key", (String)"");
            try {
                this.jwtParser = new NacosJwtParser(encodedSecretKey);
            }
            catch (Exception e) {
                this.jwtParser = null;
                if (!this.authConfigs.isAuthEnabled()) break block2;
                throw new IllegalArgumentException("the length of secret key must great than or equal 32 bytes; And the secret key  must be encoded by base64.Please see https://nacos.io/zh-cn/docs/v2/guide/user/auth.html", e);
            }
        }
    }

    @Override
    @Deprecated
    public String createToken(Authentication authentication) {
        return this.createToken(authentication.getName());
    }

    @Override
    public String createToken(String userName) {
        if (!this.authConfigs.isAuthEnabled()) {
            return AUTH_DISABLED_TOKEN;
        }
        this.checkJwtParser();
        return this.jwtParser.jwtBuilder().setUserName(userName).setExpiredTime(this.tokenValidityInSeconds).compact();
    }

    @Override
    @Deprecated
    public Authentication getAuthentication(String token) throws AccessException {
        NacosUser nacosUser = this.jwtParser.parse(token);
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)"");
        User principal = new User(nacosUser.getUserName(), "", (Collection)authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", (Collection)authorities);
    }

    @Override
    public void validateToken(String token) throws AccessException {
        this.parseToken(token);
    }

    @Override
    public NacosUser parseToken(String token) throws AccessException {
        this.checkJwtParser();
        return this.jwtParser.parse(token);
    }

    @Override
    public long getTokenValidityInSeconds() {
        return this.tokenValidityInSeconds;
    }

    @Override
    public long getTokenTtlInSeconds(String token) throws AccessException {
        if (!this.authConfigs.isAuthEnabled()) {
            return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) + this.tokenValidityInSeconds;
        }
        return this.jwtParser.getExpireTimeInSeconds(token) - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    public long getExpiredTimeInSeconds(String token) throws AccessException {
        if (!this.authConfigs.isAuthEnabled()) {
            return this.tokenValidityInSeconds;
        }
        return this.jwtParser.getExpireTimeInSeconds(token);
    }

    public void onEvent(ServerConfigChangeEvent event) {
        this.processProperties();
    }

    public Class<? extends Event> subscribeType() {
        return ServerConfigChangeEvent.class;
    }

    private void checkJwtParser() {
        if (null == this.jwtParser) {
            throw new NacosRuntimeException(400, "Please config `nacos.core.auth.plugin.nacos.token.secret.key`, detail see https://nacos.io/zh-cn/docs/v2/guide/user/auth.html");
        }
    }
}

