/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.io.Serializable;

public final class Status
implements Serializable {
    public static final Status UNKNOWN = new Status(0, "UNKNOWN");
    public static final Status NORMAL = new Status(1, "NORMAL");
    public static final Status WARNING = new Status(2, "WARNING");
    public static final Status FAILURE = new Status(3, "FAILURE");
    public static final Status ERROR = new Status(4, "ERROR");
    private static final Status[] ourAllInstances = new Status[]{UNKNOWN, NORMAL, WARNING, FAILURE, ERROR};
    private final byte myPriority;
    private final String myStatusName;

    Status(int priority, String name2) {
        this.myPriority = (byte)priority;
        this.myStatusName = name2;
    }

    public byte getPriority() {
        return this.myPriority;
    }

    public String getText() {
        return this.myStatusName.equals("NORMAL") ? "SUCCESS" : this.myStatusName;
    }

    public boolean isSuccessful() {
        return this.getPriority() <= WARNING.getPriority() && this != UNKNOWN;
    }

    public boolean isFailed() {
        return this.getPriority() > WARNING.getPriority();
    }

    public boolean isIgnored() {
        return UNKNOWN.equals(this);
    }

    public static Status getStatus(int priority) {
        switch (priority) {
            case 1: {
                return NORMAL;
            }
            case 2: {
                return WARNING;
            }
            case 3: {
                return FAILURE;
            }
            case 4: {
                return ERROR;
            }
        }
        return UNKNOWN;
    }

    public static Status getStatus(String statusName) {
        for (int i2 = 0; i2 < ourAllInstances.length; ++i2) {
            Status instance = ourAllInstances[i2];
            if (!instance.myStatusName.equals(statusName) && !instance.getText().equals(statusName)) continue;
            return instance;
        }
        return null;
    }

    public String toString() {
        return this.myStatusName;
    }

    public boolean above(Status status) {
        return this.getPriority() > status.getPriority();
    }
}

