/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.hash.FileHasher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.com.google.gson.JsonParseException;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001:\u0002-.B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0002J'\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020\u00052\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070&H\u0000\u00a2\u0006\u0002\b'J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005H\u0014R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache;", "Ljava/lang/AutoCloseable;", "project", "Lorg/gradle/api/Project;", "targetDir", "Ljava/io/File;", "stateFileName", "", "version", "(Lorg/gradle/api/Project;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "gson", "Lorg/jetbrains/kotlin/com/google/gson/Gson;", "kotlin.jvm.PlatformType", "hasher", "Lorg/gradle/internal/hash/FileHasher;", "new", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$State;", "old", "getProject", "()Lorg/gradle/api/Project;", "stateFile", "getTargetDir", "()Ljava/io/File;", "targets", "", "getTargets", "()Ljava/util/Collection;", "getVersion", "()Ljava/lang/String;", "close", "", "deleteTarget", "key", "getDeletedTargets", "", "getOrCompute", "file", "compute", "Lkotlin/Function0;", "getOrCompute$kotlin_gradle_plugin", "reportTargetClash", "", "target", "existedSrc", "newSrc", "Element", "State", "kotlin-gradle-plugin"})
public class ProcessedFilesCache
implements AutoCloseable {
    private final FileHasher hasher;
    private final Gson gson;
    private final File stateFile;
    private final State old;
    private final State new;
    @NotNull
    private final Project project;
    @NotNull
    private final File targetDir;
    @NotNull
    private final String version;

    @Nullable
    public final String getOrCompute$kotlin_gradle_plugin(@NotNull File file, @NotNull Function0<String> compute) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(compute, (String)"compute");
        byte[] hash2 = this.hasher.hash(file).toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)hash2, (String)"hash");
        Element old = this.old.get(hash2);
        if (old != null) {
            this.new.set(hash2, old);
            return old.getTarget();
        }
        String key = (String)compute.invoke();
        Map<String, Element> map2 = this.new.getByTarget();
        boolean bl = false;
        Element existedTarget = map2.get(key);
        if (key != null && existedTarget != null && Intrinsics.areEqual((Object)existedTarget.getSrc(), (Object)file.getCanonicalPath()) ^ true) {
            Void void_ = this.reportTargetClash(key, file, new File(existedTarget.getSrc()));
            throw null;
        }
        String string = file.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
        this.new.set(hash2, new Element(string, key));
        return key;
    }

    public final void deleteTarget(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        FilesKt.deleteRecursively((File)FilesKt.resolve((File)this.targetDir, (String)key));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> getTargets() {
        void var2_3;
        void $this$mapNotNullTo$iv;
        Map<String, Element> map2 = this.new.getByHash();
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        void var6_7 = $this$forEach$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var6_7.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry element$iv$iv;
            Map.Entry element$iv = element$iv$iv = iterator.next();
            boolean bl3 = false;
            Map.Entry it = element$iv;
            boolean bl4 = false;
            if (((Element)it.getValue()).getTarget() == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            String it$iv = string;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return var2_3;
    }

    @NotNull
    protected Void reportTargetClash(@NotNull String target, @NotNull File existedSrc, @NotNull File newSrc) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)existedSrc, (String)"existedSrc");
        Intrinsics.checkParameterIsNotNull((Object)newSrc, (String)"newSrc");
        String string = "Both `" + existedSrc + "` and `" + newSrc + "` produces `" + target + '`';
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final Set<String> getDeletedTargets() {
        String target;
        Map.Entry<String, Element> it;
        Map.Entry<String, Element> element$iv;
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        Map<String, Element> $this$forEach$iv = this.old.getByHash();
        boolean $i$f$forEach = false;
        Map<String, Element> map2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator<Map.Entry<String, Element>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl3 = false;
            target = it.getValue().getTarget();
            if (target == null) continue;
            result2.add(target);
        }
        $this$forEach$iv = this.new.getByHash();
        $i$f$forEach = false;
        map2 = $this$forEach$iv;
        bl2 = false;
        iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv = iterator.next();
            boolean bl4 = false;
            target = it.getValue().getTarget();
            if (target == null) continue;
            result2.remove(target);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object element$iv2;
        Iterable $this$forEach$iv = this.getDeletedTargets();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String it = (String)element$iv2;
            boolean bl = false;
            this.deleteTarget(it);
        }
        Object object = this.stateFile;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        element$iv2 = object;
        boolean it = false;
        element$iv2 = new FileOutputStream((File)element$iv2);
        it = false;
        object = new OutputStreamWriter((OutputStream)element$iv2, charset);
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it2 = (OutputStreamWriter)object;
            boolean bl3 = false;
            this.gson.toJson((Object)this.new, (Appendable)it2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final File getTargetDir() {
        return this.targetDir;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessedFilesCache(@NotNull Project project, @NotNull File targetDir, @NotNull String stateFileName, @NotNull String version2) {
        State state;
        State state2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)targetDir, (String)"targetDir");
        Intrinsics.checkParameterIsNotNull((Object)stateFileName, (String)"stateFileName");
        Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version");
        this.project = project;
        this.targetDir = targetDir;
        this.version = version2;
        Project project2 = this.project;
        if (project2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.project.ProjectInternal");
        }
        this.hasher = (FileHasher)((ProjectInternal)project2).getServices().get(FileHasher.class);
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.stateFile = FilesKt.resolve((File)this.targetDir, (String)stateFileName);
        this.targetDir.mkdirs();
        if (this.stateFile.exists()) {
            Object object2;
            try {
                Object object3;
                Object it2;
                object2 = this.stateFile;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                Object object4 = object2;
                boolean bl2 = false;
                object4 = new FileInputStream((File)object4);
                bl2 = false;
                object2 = new InputStreamReader((InputStream)object4, charset);
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    it2 = (InputStreamReader)object2;
                    boolean bl4 = false;
                    it2 = this.gson.fromJson((Reader)it2, State.class);
                }
                catch (Throwable it2) {
                    throwable = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object2 = it2;
                bl3 = false;
                boolean bl5 = false;
                it2 = object2;
                boolean bl6 = false;
                if (Intrinsics.areEqual((Object)((State)it2).getVersion(), (Object)this.version) ^ true) {
                    FilesKt.deleteRecursively((File)this.targetDir);
                    object3 = null;
                } else {
                    object3 = it2;
                }
                object2 = object3;
            }
            catch (JsonParseException e) {
                this.project.getLogger().warn("Cannot read " + this.stateFile, (Throwable)e);
                if (this.targetDir.exists()) {
                    FilesKt.deleteRecursively((File)this.targetDir);
                }
                object2 = null;
            }
            object = object2;
        } else {
            object = null;
        }
        if ((state2 = (state = object)) == null) {
            state2 = new State();
        }
        this.old = state2;
        this.new = new State();
        this.new.setVersion(this.version);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002J\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006H\u0086\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$State;", "", "()V", "byHash", "", "", "Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$Element;", "getByHash", "()Ljava/util/Map;", "byTarget", "getByTarget", "version", "getVersion", "()Ljava/lang/String;", "setVersion", "(Ljava/lang/String;)V", "get", "elementHash", "", "set", "", "element", "kotlin-gradle-plugin"})
    private static final class State {
        @Nullable
        private String version;
        @NotNull
        private final Map<String, Element> byHash;
        @NotNull
        private final Map<String, Element> byTarget;

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(@Nullable String string) {
            this.version = string;
        }

        @NotNull
        public final Map<String, Element> getByHash() {
            return this.byHash;
        }

        @NotNull
        public final Map<String, Element> getByTarget() {
            return this.byTarget;
        }

        @Nullable
        public final Element get(@NotNull byte[] elementHash) {
            Intrinsics.checkParameterIsNotNull((Object)elementHash, (String)"elementHash");
            return this.byHash.get(DaemonParamsKt.toHexString((byte[])elementHash));
        }

        public final void set(@NotNull byte[] elementHash, @NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)elementHash, (String)"elementHash");
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.byHash.put(DaemonParamsKt.toHexString((byte[])elementHash), element);
            String target = element.getTarget();
            if (target != null) {
                this.byTarget.put(target, element);
            }
        }

        public State() {
            Map map2;
            State state = this;
            boolean bl = false;
            state.byHash = map2 = (Map)new LinkedHashMap();
            state = this;
            bl = false;
            state.byTarget = map2 = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/ProcessedFilesCache$Element;", "", "src", "", "target", "(Ljava/lang/String;Ljava/lang/String;)V", "getSrc", "()Ljava/lang/String;", "getTarget", "kotlin-gradle-plugin"})
    public static final class Element {
        @NotNull
        private final String src;
        @Nullable
        private final String target;

        @NotNull
        public final String getSrc() {
            return this.src;
        }

        @Nullable
        public final String getTarget() {
            return this.target;
        }

        public Element(@NotNull String src, @Nullable String target) {
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            this.src = src;
            this.target = target;
        }
    }
}

