/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.internal.state.TaskExecutionResults;
import org.jetbrains.kotlin.gradle.report.KotlinBuildReporter;
import org.jetbrains.kotlin.gradle.report.TaskExecutionResult;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0014\u0010\u001e\u001a\u00020\u001a*\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporter;", "Lorg/gradle/BuildAdapter;", "Lorg/gradle/api/execution/TaskExecutionListener;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "perfReportFile", "Ljava/io/File;", "(Lorg/gradle/api/invocation/Gradle;Ljava/io/File;)V", "allTasksTimeNs", "", "kotlinTaskTimeNs", "Ljava/util/HashMap;", "Lorg/gradle/api/Task;", "taskStartNs", "tasksSb", "Ljava/lang/StringBuilder;", "afterExecute", "", "task", "state", "Lorg/gradle/api/tasks/TaskState;", "beforeExecute", "buildFinished", "result", "Lorg/gradle/BuildResult;", "buildInfo", "", "formatTime", "ns", "taskOverview", "asString", "", "decPoints", "", "TextTable", "kotlin-gradle-plugin"})
public final class KotlinBuildReporter
extends BuildAdapter
implements TaskExecutionListener {
    private final HashMap<Task, Long> taskStartNs;
    private final HashMap<Task, Long> kotlinTaskTimeNs;
    private final StringBuilder tasksSb;
    private volatile long allTasksTimeNs;
    private final Gradle gradle;
    private final File perfReportFile;

    public synchronized void beforeExecute(@NotNull Task task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        ((Map)this.taskStartNs).put(task, System.nanoTime());
    }

    public synchronized void afterExecute(@NotNull Task task, @NotNull TaskState state) {
        String path;
        boolean bl;
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Long l = this.taskStartNs.get(task);
        if (l == null) {
            return;
        }
        Long startNs = l;
        long endNs = System.nanoTime();
        Long l2 = startNs;
        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"startNs");
        long timeNs = endNs - l2;
        this.allTasksTimeNs += timeNs;
        String string2 = task.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.javaClass.name");
        if (!StringsKt.startsWith$default((String)string2, (String)"org.jetbrains.kotlin", (boolean)false, (int)2, null)) {
            return;
        }
        ((Map)this.kotlinTaskTimeNs).put(task, timeNs);
        StringsKt.appendln((StringBuilder)this.tasksSb);
        String skipMessage = state.getSkipMessage();
        if (skipMessage != null) {
            stringBuilder = this.tasksSb;
            string = task + " was skipped: " + skipMessage;
            bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
        } else {
            stringBuilder = this.tasksSb;
            string = task + " finished in " + this.formatTime(timeNs);
            bl = false;
            StringBuilder stringBuilder3 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
        }
        String string3 = path = task.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"path");
        TaskExecutionResult executionResult = TaskExecutionResults.INSTANCE.get(string3);
        if (executionResult != null) {
            Object object = this.tasksSb;
            String string4 = "Execution strategy: " + executionResult.getExecutionStrategy();
            boolean bl2 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)object).append(string4);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            List<String> list2 = executionResult.getIcLogLines();
            if (list2 != null) {
                object = list2;
                boolean bl3 = false;
                bl2 = false;
                Object lines = object;
                boolean bl4 = false;
                StringBuilder stringBuilder5 = this.tasksSb;
                String string5 = "Compilation log for " + task + ':';
                boolean bl5 = false;
                StringBuilder stringBuilder6 = stringBuilder5.append(string5);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
                Iterable $this$forEach$iv = (Iterable)lines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl6 = false;
                    StringBuilder stringBuilder7 = this.tasksSb;
                    String string6 = "  " + it;
                    boolean bl7 = false;
                    StringBuilder stringBuilder8 = stringBuilder7.append(string6);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder8);
                }
            }
        }
    }

    public synchronized void buildFinished(@NotNull BuildResult result2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            Gradle gradle = result2.getGradle();
            Logger logger = gradle != null && (gradle = gradle.getRootProject()) != null ? gradle.getLogger() : null;
            try {
                FilesKt.writeText$default((File)this.perfReportFile, (String)(this.buildInfo(result2) + this.taskOverview() + this.tasksSb.toString()), null, (int)2, null);
                Logger logger2 = logger;
                if (logger2 == null) break block2;
                logger2.lifecycle("Kotlin build report is written to " + this.perfReportFile.getCanonicalPath());
            }
            catch (Throwable e) {
                Logger logger3 = logger;
                if (logger3 == null) break block2;
                logger3.error("Could not write Kotlin build report to " + this.perfReportFile.getCanonicalPath(), e);
            }
        }
    }

    private final String buildInfo(BuildResult result2) {
        boolean bl = false;
        ArrayList<String> startParams = new ArrayList<String>();
        StartParameter startParameter = this.gradle.getStartParameter();
        boolean bl2 = false;
        boolean bl3 = false;
        StartParameter $receiver = startParameter;
        boolean bl4 = false;
        StringBuilder stringBuilder = new StringBuilder().append("tasks = ");
        List list2 = $receiver.getTaskRequests();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"taskRequests");
        startParams.add(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)buildInfo.1.1.INSTANCE, (int)31, null)).toString());
        startParams.add("excluded tasks = " + $receiver.getExcludedTaskNames());
        startParams.add("current dir = " + $receiver.getCurrentDir());
        startParams.add("project properties args = " + $receiver.getProjectProperties());
        startParams.add("system properties args = " + $receiver.getSystemPropertiesArgs());
        boolean bl5 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        bl3 = false;
        boolean bl6 = false;
        StringBuilder $receiver2 = stringBuilder2;
        boolean bl7 = false;
        StringBuilder stringBuilder3 = $receiver2;
        String string = "Gradle start parameters:";
        boolean bl8 = false;
        StringBuilder stringBuilder4 = stringBuilder3.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        Iterable $this$forEach$iv = startParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl9 = false;
            StringBuilder stringBuilder5 = $receiver2;
            String string2 = "  " + it;
            boolean bl10 = false;
            StringBuilder stringBuilder6 = stringBuilder5.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        if (result2.getFailure() != null) {
            stringBuilder3 = $receiver2;
            String string3 = "Build failed: " + result2.getFailure();
            boolean bl11 = false;
            StringBuilder stringBuilder7 = stringBuilder3.append(string3);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
        }
        StringsKt.appendln((StringBuilder)$receiver2);
        String string4 = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private final String taskOverview() {
        if (this.kotlinTaskTimeNs.isEmpty()) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder $receiver = stringBuilder;
            boolean bl4 = false;
            StringBuilder stringBuilder2 = $receiver;
            String string = "No Kotlin task was run";
            boolean bl5 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            String string2 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            return string2;
        }
        StringBuilder sb = new StringBuilder();
        Collection<Long> collection = this.kotlinTaskTimeNs.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"kotlinTaskTimeNs.values");
        long kotlinTotalTimeNs = CollectionsKt.sumOfLong((Iterable)collection);
        String ktTaskPercent = this.asString((double)kotlinTotalTimeNs / (double)this.allTasksTimeNs * (double)100, 1);
        StringBuilder $receiver = sb;
        String bl4 = "Total time for Kotlin tasks: " + this.formatTime(kotlinTotalTimeNs) + " (" + ktTaskPercent + " % of all tasks time)";
        boolean bl = false;
        StringBuilder stringBuilder = $receiver.append(bl4);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        TextTable table = new TextTable("Time", "% of Kotlin time", "Task");
        Set<Map.Entry<Task, Long>> set2 = this.kotlinTaskTimeNs.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"kotlinTaskTimeNs.entries");
        Iterable $this$sortedByDescending$iv = set2;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl6 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry $dstr$_u24__u24$timeNs = (Map.Entry)b;
                boolean bl2 = false;
                Map.Entry entry = $dstr$_u24__u24$timeNs;
                boolean bl3 = false;
                Long timeNs = (Long)entry.getValue();
                $dstr$_u24__u24$timeNs = (Map.Entry)a;
                Comparable comparable = timeNs;
                bl2 = false;
                entry = $dstr$_u24__u24$timeNs;
                bl3 = false;
                Long l = timeNs = (Long)entry.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry $dstr$task$timeNs = (Map.Entry)element$iv;
            boolean bl7 = false;
            Map.Entry entry = $dstr$task$timeNs;
            boolean bl8 = false;
            Task task = (Task)entry.getKey();
            entry = $dstr$task$timeNs;
            bl8 = false;
            Long timeNs = (Long)entry.getValue();
            String percent = this.asString((double)timeNs.longValue() / (double)kotlinTotalTimeNs * (double)100, 1);
            String[] stringArray = new String[3];
            Long l = timeNs;
            Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"timeNs");
            stringArray[0] = this.formatTime(l);
            stringArray[1] = percent + " %";
            Task task2 = task;
            Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"task");
            String string = task2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.path");
            stringArray[2] = string;
            table.addRow(stringArray);
        }
        table.printTo(sb);
        StringsKt.appendln((StringBuilder)sb);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String formatTime(long ns) {
        double seconds = (double)ns / (double)1000000000;
        return this.asString(seconds, 2) + " s";
    }

    private final String asString(double $receiver, int decPoints) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%." + decPoints + 'f';
        Object[] objectArray = new Object[]{$receiver};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public KotlinBuildReporter(@NotNull Gradle gradle, @NotNull File perfReportFile) {
        File dir2;
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull((Object)perfReportFile, (String)"perfReportFile");
        this.gradle = gradle;
        this.perfReportFile = perfReportFile;
        File file = dir2 = this.perfReportFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dir");
        boolean bl = file.isDirectory();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = dir2 + " does not exist or is a file";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = !this.perfReportFile.isFile();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Build report log file " + this.perfReportFile + " exists already";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.taskStartNs = new HashMap();
        this.kotlinTaskTimeNs = new HashMap();
        this.tasksSb = new StringBuilder();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/gradle/report/KotlinBuildReporter$TextTable;", "", "columnNames", "", "", "([Ljava/lang/String;)V", "columnsCount", "", "maxLengths", "", "rows", "Ljava/util/ArrayList;", "", "addRow", "", "row", "printTo", "sb", "Ljava/lang/StringBuilder;", "kotlin-gradle-plugin"})
    private static final class TextTable {
        private final ArrayList<List<String>> rows;
        private final int columnsCount;
        private final int[] maxLengths;

        /*
         * WARNING - void declaration
         */
        public final void addRow(String ... row) {
            Intrinsics.checkParameterIsNotNull((Object)row, (String)"row");
            int n = row.length == this.columnsCount ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (n == 0) {
                boolean bl3 = false;
                String string = "Row size " + row.length + " differs from columns count " + this.columnsCount;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.rows.add(ArraysKt.toList((Object[])row));
            String[] stringArray = row;
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                int n3;
                void i2;
                String col = stringArray[n];
                int n4 = this.maxLengths[i2];
                int n5 = col.length();
                void var10_14 = i2++;
                int[] nArray = this.maxLengths;
                boolean bl4 = false;
                nArray[var10_14] = n3 = Math.max(n4, n5);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void printTo(@NotNull StringBuilder sb) {
            Intrinsics.checkParameterIsNotNull((Object)sb, (String)"sb");
            for (List<String> row : this.rows) {
                StringsKt.appendln((StringBuilder)sb);
                boolean bl = false;
                List<String> list2 = row;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"row");
                for (String col : (Iterable)list2) {
                    void i2;
                    if (i2 > 0) {
                        sb.append("|");
                    }
                    sb.append(StringsKt.padEnd((String)col, (int)this.maxLengths[i2], (char)' '));
                    ++i2;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public TextTable(String ... columnNames) {
            int[] nArray;
            Intrinsics.checkParameterIsNotNull((Object)columnNames, (String)"columnNames");
            this.rows = new ArrayList();
            int n = this.columnsCount = columnNames.length;
            TextTable textTable = this;
            int[] nArray2 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n2;
                int n5 = n2++;
                nArray = nArray2;
                boolean bl = false;
                nArray[n5] = n3 = columnNames[it].length();
            }
            nArray = nArray2;
            textTable.maxLengths = nArray;
            this.rows.add(ArraysKt.toList((Object[])columnNames));
        }
    }
}

