/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.fmap;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.Expression;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.ValueFlatMapFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ArrayValueFlatMapFeature
implements ValueFlatMapFeature {
    static String ID = FeatureId.ValueFlatMap.of("flat_array").getId();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public BiFunction<String, Flux<ReactorQLRecord>, Flux<ReactorQLRecord>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)expression;
        if (function.getParameters() == null || CollectionUtils.isEmpty((Collection)function.getParameters().getExpressions())) {
            throw new IllegalArgumentException("\u51fd\u6570[" + expression + "]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Expression expr = (Expression)function.getParameters().getExpressions().get(0);
        Function<ReactorQLRecord, Publisher<?>> valueMap = ValueMapFeature.createMapperNow(expr, metadata);
        return (alias, flux) -> flux.flatMap(record -> Flux.from((Publisher)((Publisher)valueMap.apply((ReactorQLRecord)record))).flatMap(result -> {
            if (result instanceof Iterable) {
                return Flux.fromIterable((Iterable)((Iterable)result));
            }
            if (result instanceof Object[]) {
                return Flux.just((Object[])((Object[])result));
            }
            return Flux.just((Object)result);
        }).map(v -> record.setResult((String)alias, v)));
    }
}

