/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.reactor.ql.supports.map;

import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.WhenClause;
import org.jetlinks.reactor.ql.ReactorQLMetadata;
import org.jetlinks.reactor.ql.ReactorQLRecord;
import org.jetlinks.reactor.ql.feature.FeatureId;
import org.jetlinks.reactor.ql.feature.FilterFeature;
import org.jetlinks.reactor.ql.feature.ValueMapFeature;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CaseMapFeature
implements ValueMapFeature {
    private static final String ID = FeatureId.ValueMap.caseWhen.getId();

    @Override
    public Function<ReactorQLRecord, Publisher<?>> createMapper(Expression expression, ReactorQLMetadata metadata) {
        CaseExpression caseExpression = (CaseExpression)expression;
        Expression switchExpr = caseExpression.getSwitchExpression();
        Function<ReactorQLRecord, Publisher> valueMapper = switchExpr == null ? v -> Mono.just((Object)v.getRecord()) : ValueMapFeature.createMapperNow(switchExpr, metadata);
        LinkedHashMap cases = new LinkedHashMap();
        for (WhenClause whenClause : caseExpression.getWhenClauses()) {
            Expression when = whenClause.getWhenExpression();
            Expression then = whenClause.getThenExpression();
            cases.put(this.createWhen(when, metadata), this.createThen(then, metadata));
        }
        Function<ReactorQLRecord, Publisher<?>> thenElse = this.createThen(caseExpression.getElseExpression(), metadata);
        return ctx -> {
            Mono switchValue = Mono.from((Publisher)((Publisher)valueMapper.apply((ReactorQLRecord)ctx)));
            return Flux.fromIterable(cases.entrySet()).filterWhen(whenAndThen -> switchValue.flatMap(v -> (Mono)((BiFunction)whenAndThen.getKey()).apply(ctx, v))).flatMap(whenAndThen -> (Publisher)((Function)whenAndThen.getValue()).apply(ctx)).switchIfEmpty((Publisher)thenElse.apply((ReactorQLRecord)ctx));
        };
    }

    protected Function<ReactorQLRecord, Publisher<?>> createThen(Expression expression, ReactorQLMetadata metadata) {
        if (expression == null) {
            return ctx -> Mono.empty();
        }
        return ValueMapFeature.createMapperNow(expression, metadata);
    }

    protected BiFunction<ReactorQLRecord, Object, Mono<Boolean>> createWhen(Expression expression, ReactorQLMetadata metadata) {
        if (expression == null) {
            return (ctx, v) -> Mono.just((Object)false);
        }
        return FilterFeature.createPredicateNow(expression, metadata);
    }

    @Override
    public String getId() {
        return ID;
    }
}

